/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.common;

import com.ishland.c2me.base.mixin.access.IChunkLevelManager;
import com.ishland.c2me.notickvd.common.Config;
import com.ishland.c2me.notickvd.common.NoTickSystem;
import com.ishland.c2me.notickvd.common.iterators.ChunkIterator;
import com.ishland.c2me.notickvd.common.iterators.SpiralIterator;
import com.ishland.c2me.rewrites.chunksystem.common.NewChunkStatus;
import com.ishland.c2me.rewrites.chunksystem.common.ducks.IChunkSystemAccess;
import com.ishland.flowsched.scheduler.ItemHolder;
import com.ishland.flowsched.scheduler.ItemStatus;
import com.ishland.flowsched.scheduler.ItemTicket;
import com.ishland.flowsched.scheduler.StatusAdvancingScheduler;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongFunction;
import net.minecraft.class_1923;
import net.minecraft.class_3230;
import net.minecraft.class_3898;
import org.slf4j.Logger;

public class PlayerNoTickLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ItemTicket.TicketType TICKET_TYPE = new ItemTicket.TicketType("c2me:notickvd");
    public static final class_3230 VANILLA_TICKET_TYPE = new class_3230(0L, 2);
    private final class_3898 tacs;
    private final NoTickSystem noTickSystem;
    private final Long2ReferenceLinkedOpenHashMap<ChunkIterator> iterators = new Long2ReferenceLinkedOpenHashMap();
    private final LongSet managedChunks = new LongLinkedOpenHashSet();
    private final LongFunction<ChunkIterator> createFunction = pos -> new SpiralIterator(class_1923.method_8325((long)pos), class_1923.method_8332((long)pos), this.viewDistance);
    private final ReferenceArrayList<CompletableFuture<Void>> chunkLoadFutures = new ReferenceArrayList();
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private int viewDistance = 12;
    private boolean dirtyManagedChunks = false;
    private boolean recreateIterators = false;
    private volatile long pendingLoadsCountSnapshot = 0L;

    public PlayerNoTickLoader(class_3898 tacs, NoTickSystem noTickSystem) {
        this.tacs = tacs;
        this.noTickSystem = noTickSystem;
    }

    public void addSource(class_1923 chunkPos) {
        this.iterators.computeIfAbsent(chunkPos.method_8324(), this.createFunction);
    }

    public void removeSource(class_1923 chunkPos) {
        this.iterators.remove(chunkPos.method_8324());
        this.dirtyManagedChunks = true;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
        this.recreateIterators = true;
    }

    public void tick() {
        if (this.closing.get()) {
            this.clearTickets();
            return;
        }
        if (this.recreateIterators) {
            this.dirtyManagedChunks = true;
            ObjectBidirectionalIterator iterator = this.iterators.long2ReferenceEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Long2ReferenceMap.Entry entry = (Long2ReferenceMap.Entry)iterator.next();
                entry.setValue((Object)this.createFunction.apply(entry.getLongKey()));
            }
            this.recreateIterators = false;
        }
        if (this.dirtyManagedChunks) {
            LongIterator chunkIterator = this.managedChunks.iterator();
            ObjectBidirectionalIterator iteratorIterator = this.iterators.long2ReferenceEntrySet().fastIterator();
            while (chunkIterator.hasNext()) {
                long pos = chunkIterator.nextLong();
                int packedX = class_1923.method_8325((long)pos);
                int packedZ = class_1923.method_8332((long)pos);
                boolean isUsed = false;
                if (iteratorIterator.hasNext()) {
                    while (iteratorIterator.hasNext()) {
                        entry = (Long2ReferenceMap.Entry)iteratorIterator.next();
                        isUsed |= ((ChunkIterator)entry.getValue()).isInRange(packedX, packedZ);
                    }
                } else if (iteratorIterator.hasPrevious()) {
                    while (iteratorIterator.hasPrevious()) {
                        entry = (Long2ReferenceMap.Entry)iteratorIterator.previous();
                        isUsed |= ((ChunkIterator)entry.getValue()).isInRange(packedX, packedZ);
                    }
                }
                if (isUsed) continue;
                this.removeTicket0(packedX, packedZ);
                chunkIterator.remove();
            }
            this.dirtyManagedChunks = false;
        }
        this.tickFutures();
    }

    private void clearTickets() {
        LongIterator iterator = this.managedChunks.iterator();
        while (iterator.hasNext()) {
            long pos = iterator.nextLong();
            this.removeTicket0(class_1923.method_8325((long)pos), class_1923.method_8332((long)pos));
            iterator.remove();
        }
    }

    void tickFutures() {
        this.chunkLoadFutures.removeIf(CompletableFuture::isDone);
        if (this.closing.get()) {
            return;
        }
        while (this.chunkLoadFutures.size() < Config.maxConcurrentChunkLoads && this.addOneTicket()) {
        }
        long pendingLoadsCount = 0L;
        ObjectBidirectionalIterator iterator = this.iterators.long2ReferenceEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ReferenceMap.Entry entry = (Long2ReferenceMap.Entry)iterator.next();
            pendingLoadsCount += ((ChunkIterator)entry.getValue()).remaining();
        }
        this.pendingLoadsCountSnapshot = pendingLoadsCount;
    }

    private boolean addOneTicket() {
        ObjectBidirectionalIterator iteratorIterator = this.iterators.long2ReferenceEntrySet().fastIterator();
        while (iteratorIterator.hasNext()) {
            Long2ReferenceMap.Entry entry = (Long2ReferenceMap.Entry)iteratorIterator.next();
            ChunkIterator iterator = (ChunkIterator)entry.getValue();
            while (iterator.hasNext()) {
                class_1923 pos = (class_1923)iterator.next();
                if (!this.managedChunks.add(pos.method_8324())) continue;
                this.chunkLoadFutures.add(this.loadChunk(pos.field_9181, pos.field_9180));
                this.iterators.getAndMoveToLast(entry.getLongKey());
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Void> loadChunk(int x, int z) {
        CompletableFuture<Void> future = this.loadChunk0(x, z);
        future.thenRunAsync(() -> {
            try {
                this.chunkLoadFutures.remove((Object)future);
                this.tickFutures();
            }
            catch (Throwable t) {
                LOGGER.error("Error while loading chunk [{}, {}]", new Object[]{x, z, t});
            }
        }, this.noTickSystem.executor);
        return future;
    }

    private CompletableFuture<Void> loadChunk0(int x, int z) {
        class_1923 pos = new class_1923(x, z);
        ItemHolder holder = ((IChunkSystemAccess)this.tacs).c2me$getTheChunkSystem().addTicket((Object)pos, TICKET_TYPE, (Object)pos, (ItemStatus)NewChunkStatus.SERVER_ACCESSIBLE_CHUNK_SENDING, StatusAdvancingScheduler.NO_OP);
        this.noTickSystem.mainBeforeTicketTicks.add(() -> ((IChunkLevelManager)this.tacs.method_17263()).getTicketManager().method_66358(VANILLA_TICKET_TYPE, pos, 0));
        return holder.getFutureForStatus((ItemStatus)NewChunkStatus.SERVER_ACCESSIBLE);
    }

    private void removeTicket0(int x, int z) {
        class_1923 pos = new class_1923(x, z);
        ((IChunkSystemAccess)this.tacs).c2me$getTheChunkSystem().removeTicket((Object)pos, TICKET_TYPE, (Object)pos, (ItemStatus)NewChunkStatus.SERVER_ACCESSIBLE_CHUNK_SENDING);
        this.noTickSystem.mainBeforeTicketTicks.add(() -> ((IChunkLevelManager)this.tacs.method_17263()).getTicketManager().method_66373(VANILLA_TICKET_TYPE, pos, 0));
    }

    public long getPendingLoadsCount() {
        return this.pendingLoadsCountSnapshot;
    }

    public void close() {
        this.closing.set(true);
    }
}

