/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.scheduler;

import com.google.common.base.Preconditions;
import io.netty.util.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SingleThreadExecutor
extends Thread
implements Executor {
    private final AtomicInteger size = new AtomicInteger();
    public final Queue<Runnable> queue = PlatformDependent.newMpscQueue();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final Object sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (this.pollTasks()) {
                continue;
            }
            if (this.shutdown.get()) {
                return;
            }
            Object object = this.sync;
            synchronized (object) {
                if (this.size.get() != 0 || this.shutdown.get()) {
                    continue;
                }
                try {
                    this.sync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean pollTasks() {
        Runnable task;
        boolean hasWork = false;
        while ((task = this.queue.poll()) != null) {
            this.size.decrementAndGet();
            try {
                task.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            hasWork = true;
        }
        return hasWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull Runnable command) {
        Preconditions.checkNotNull((Object)command, (Object)"command");
        boolean wasEmpty = this.size.getAndIncrement() == 0;
        this.queue.add(command);
        if (wasEmpty) {
            Object object = this.sync;
            synchronized (object) {
                this.sync.notify();
            }
        }
    }
}

