/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.threadstate;

import com.ishland.c2me.base.common.threadstate.RunningWork;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ThreadState {
    private final ArrayDeque<RunningWork> runningWorks = new ArrayDeque();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public void push(RunningWork runningWork) {
        this.lock.writeLock().lock();
        try {
            this.runningWorks.push(runningWork);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pop(RunningWork runningWork) {
        this.lock.writeLock().lock();
        try {
            RunningWork popped = this.runningWorks.peek();
            if (popped != runningWork) {
                IllegalArgumentException exception = new IllegalArgumentException("Corrupt ThreadState");
                exception.printStackTrace();
                throw exception;
            }
            this.runningWorks.pop();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public WorkClosable begin(RunningWork runningWork) {
        this.lock.writeLock().lock();
        try {
            this.runningWorks.push(runningWork);
            WorkClosable workClosable = new WorkClosable(this, runningWork);
            return workClosable;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public RunningWork[] toArray() {
        this.lock.readLock().lock();
        try {
            RunningWork[] runningWorkArray = (RunningWork[])this.runningWorks.toArray(RunningWork[]::new);
            return runningWorkArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public record WorkClosable(ThreadState state, RunningWork work) implements Closeable
    {
        @Override
        public void close() {
            this.state.pop(this.work);
        }
    }
}

