/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ishland.c2me.base.common.util.CFUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;

public class C2MEForkJoinWorkerThreadFactory
implements ForkJoinPool.ForkJoinWorkerThreadFactory {
    private final AtomicLong serial = new AtomicLong(0L);
    private final String groupName;
    private final String namePattern;
    private final int priority;
    private final ExecutorService threadCreator;
    private final ThreadGroup threadGroup;

    public C2MEForkJoinWorkerThreadFactory(String groupName, String namePattern, int priority) {
        this.groupName = groupName;
        this.namePattern = namePattern;
        this.priority = priority;
        this.threadGroup = new ThreadGroup(this.groupName);
        this.threadCreator = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(String.format("%s daemon", this.groupName)).setPriority(4).setDaemon(true).setThreadFactory(r -> new Thread(this.threadGroup, r)).build());
    }

    @Override
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        return CFUtil.join(CompletableFuture.supplyAsync(() -> {
            C2MEForkJoinWorkerThread newThread = new C2MEForkJoinWorkerThread(pool);
            newThread.setName(String.format(this.namePattern, this.serial.incrementAndGet()));
            newThread.setPriority(this.priority);
            newThread.setDaemon(true);
            return newThread;
        }, this.threadCreator));
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public static class C2MEForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        protected C2MEForkJoinWorkerThread(ForkJoinPool pool) {
            super(pool);
        }
    }
}

