/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.impl.entrypoint;

import dev.yumi.mc.core.api.entrypoint.EntrypointContainer;
import dev.yumi.mc.core.impl.EnvironmentUtils;
import dev.yumi.mc.core.impl.entrypoint.CommonEntrypointStorage;
import dev.yumi.mc.core.impl.entrypoint.EntrypointStorage;
import dev.yumi.mc.core.impl.entrypoint.FabricEntrypointStorage;
import dev.yumi.mc.core.impl.mod.ExtendedModContainer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class JoinedEntrypointStorage
implements EntrypointStorage {
    private final List<EntrypointStorage> layers;

    public JoinedEntrypointStorage(List<EntrypointStorage> layers) {
        this.layers = layers;
    }

    @Override
    public <T> List<EntrypointContainer<T>> getEntrypoints(String key, Class<T> type) {
        ArrayList<EntrypointContainer<T>> list = new ArrayList<EntrypointContainer<T>>();
        for (EntrypointStorage layer : this.layers) {
            list.addAll(layer.getEntrypoints(key, type));
        }
        return list;
    }

    public static EntrypointStorage init(List<ExtendedModContainer> mods) {
        ArrayList<EntrypointStorage> layers = new ArrayList<EntrypointStorage>();
        layers.add(new CommonEntrypointStorage(mods));
        if (EnvironmentUtils.FABRIC) {
            layers.add(new FabricEntrypointStorage());
        }
        return new JoinedEntrypointStorage(layers);
    }
}

