/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.impl.mod;

import dev.yumi.mc.core.api.ModContainer;
import dev.yumi.mc.core.api.YumiMods;
import dev.yumi.mc.core.api.metadata.ManifestCustomValue;
import dev.yumi.mc.core.impl.mod.AbstractModContainer;
import dev.yumi.mc.core.impl.mod.ExtendedModContainer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

@ApiStatus.Internal
public final class FabricModContainer
extends AbstractModContainer {
    private final net.fabricmc.loader.api.ModContainer fabric;

    public FabricModContainer(net.fabricmc.loader.api.ModContainer fabric) {
        super(FabricModContainer.readCustomProperties(fabric.getMetadata()));
        this.fabric = fabric;
        this.readEntrypoints();
    }

    private static ManifestCustomValue.ObjectValue readCustomProperties(ModMetadata metadata) {
        HashMap map = new HashMap();
        for (Map.Entry entry : metadata.getCustomValues().entrySet()) {
            ManifestCustomValue<?> value = FabricModContainer.mapCustomValue((CustomValue)entry.getValue());
            if (value == null) continue;
            map.put((String)entry.getKey(), value);
        }
        return new ManifestCustomValue.ObjectValue(Map.copyOf(map));
    }

    @Override
    public String id() {
        return this.fabric.getMetadata().getId();
    }

    @Override
    public String getName() {
        return this.fabric.getMetadata().getName();
    }

    @Override
    public String getVersionString() {
        return this.fabric.getMetadata().getVersion().toString();
    }

    @Override
    public Optional<Path> findPath(String first, String ... more) {
        StringBuilder path = new StringBuilder(first);
        for (String part : more) {
            path.append('/').append(part);
        }
        return this.fabric.findPath(path.toString());
    }

    @Override
    public Optional<ModContainer> getContainingMod() {
        return this.fabric.getContainingMod().flatMap(mod -> YumiMods.get().getMod(mod.getMetadata().getId()));
    }

    @Override
    public @Unmodifiable Collection<ModContainer> getContainedMods() {
        return this.fabric.getContainedMods().stream().map(mod -> YumiMods.get().getMod(mod.getMetadata().getId())).filter(Optional::isPresent).map(Optional::get).toList();
    }

    @Override
    public @Unmodifiable Collection<String> getProvidedIds() {
        return this.fabric.getMetadata().getProvides();
    }

    public static void init(List<ExtendedModContainer> mods) {
        FabricLoader.getInstance().getAllMods().forEach(mod -> {
            FabricModContainer modContainer = new FabricModContainer((net.fabricmc.loader.api.ModContainer)mod);
            mods.add(modContainer);
        });
    }

    private static @Nullable ManifestCustomValue<?> mapCustomValue(CustomValue customValue) {
        return switch (customValue.getType()) {
            default -> throw new MatchException(null, null);
            case CustomValue.CvType.OBJECT -> {
                HashMap map = new HashMap();
                for (Map.Entry entry : customValue.getAsObject()) {
                    map.put((String)entry.getKey(), FabricModContainer.mapCustomValue((CustomValue)entry.getValue()));
                }
                yield new ManifestCustomValue.ObjectValue(Collections.unmodifiableMap(map));
            }
            case CustomValue.CvType.ARRAY -> {
                ArrayList list = new ArrayList();
                for (CustomValue entry : customValue.getAsArray()) {
                    list.add(FabricModContainer.mapCustomValue(entry));
                }
                yield new ManifestCustomValue.ArrayValue(List.copyOf(list));
            }
            case CustomValue.CvType.STRING -> new ManifestCustomValue.StringValue(customValue.getAsString());
            case CustomValue.CvType.NUMBER -> new ManifestCustomValue.NumberValue(customValue.getAsNumber());
            case CustomValue.CvType.BOOLEAN -> new ManifestCustomValue.BooleanValue(customValue.getAsBoolean());
            case CustomValue.CvType.NULL -> null;
        };
    }
}

