/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.impl.mod;

import com.electronwill.nightconfig.core.Config;
import com.google.common.base.Suppliers;
import dev.yumi.mc.core.api.ModContainer;
import dev.yumi.mc.core.api.metadata.ManifestCustomValue;
import dev.yumi.mc.core.impl.mod.AbstractModContainer;
import dev.yumi.mc.core.impl.mod.ExtendedModContainer;
import dev.yumi.mc.core.impl.neoforge.NeoForgeFileSystem;
import dev.yumi.mc.core.impl.neoforge.NeoForgeFileSystemProvider;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

@ApiStatus.Internal
public final class NeoModContainer
extends AbstractModContainer {
    private final IModInfo modInfo;
    private final Supplier<NeoForgeFileSystem> fileSystem;

    public NeoModContainer(IModInfo modInfo) {
        super(NeoModContainer.mapObjectCustomValue(modInfo.getModProperties()));
        this.modInfo = modInfo;
        this.readEntrypoints();
        this.fileSystem = Suppliers.memoize(() -> new NeoForgeFileSystem(NeoForgeFileSystemProvider.INSTANCE, this.id(), modInfo.getOwningFile().getFile().getContents()));
    }

    @Override
    public String id() {
        return this.modInfo.getModId();
    }

    @Override
    public String getName() {
        return this.modInfo.getDisplayName();
    }

    @Override
    public String getVersionString() {
        return this.modInfo.getVersion().toString();
    }

    @Override
    public Optional<Path> findPath(String first, String ... more) {
        Path path = this.fileSystem.get().getPath(first, more).toAbsolutePath();
        if (Files.exists(path, new LinkOption[0])) {
            return Optional.of(path);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ModContainer> getContainingMod() {
        return Optional.empty();
    }

    @Override
    public @Unmodifiable Collection<ModContainer> getContainedMods() {
        return List.of();
    }

    @Override
    public @Unmodifiable Collection<String> getProvidedIds() {
        return List.of();
    }

    public static void init(List<ExtendedModContainer> mods) {
        FMLLoader.getCurrent().getLoadingModList().getMods().forEach(mod -> mods.add(new NeoModContainer((IModInfo)mod)));
    }

    private static @Nullable ManifestCustomValue<?> mapCustomValue(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Config.class, Map.class, List.class, String.class, Number.class, Boolean.class}, (Object)object2, n)) {
            case 0 -> {
                Config object = (Config)object2;
                yield NeoModContainer.mapObjectCustomValue(object.valueMap());
            }
            case 1 -> {
                Map map = (Map)object2;
                yield NeoModContainer.mapObjectCustomValue(map);
            }
            case 2 -> {
                List list = (List)object2;
                yield new ManifestCustomValue.ArrayValue(list.stream().map(NeoModContainer::mapCustomValue).toList());
            }
            case 3 -> {
                String string = (String)object2;
                yield new ManifestCustomValue.StringValue(string);
            }
            case 4 -> {
                Number number = (Number)object2;
                yield new ManifestCustomValue.NumberValue(number);
            }
            case 5 -> {
                Boolean bool = (Boolean)object2;
                yield new ManifestCustomValue.BooleanValue(bool);
            }
            default -> null;
        };
    }

    private static ManifestCustomValue.ObjectValue mapObjectCustomValue(Map<String, Object> value) {
        HashMap map = new HashMap();
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            ManifestCustomValue<?> mappedValue = NeoModContainer.mapCustomValue(entry.getValue());
            if (mappedValue == null) continue;
            map.put(entry.getKey(), mappedValue);
        }
        return new ManifestCustomValue.ObjectValue(Map.copyOf(map));
    }
}

