/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.impl.neoforge;

import dev.yumi.mc.core.impl.neoforge.NeoForgeFileSystemProvider;
import dev.yumi.mc.core.impl.neoforge.NeoForgePath;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarcontents.JarResource;
import org.jspecify.annotations.Nullable;

public class NeoForgeFileSystem
extends FileSystem {
    static final String URI_SCHEME = "yumi.virtual.neoforge";
    private static final String REGEX_SYNTAX = "regex";
    private final NeoForgeFileSystemProvider provider;
    final String name;
    final NeoForgePath root;
    final Directory rootEntries;

    public NeoForgeFileSystem(NeoForgeFileSystemProvider provider, String name, JarContents jarContents) {
        this.provider = provider;
        this.name = name;
        this.root = new NeoForgePath(this, null, "/");
        this.rootEntries = new Directory("/", NeoForgeFileSystem.buildTree(jarContents));
    }

    @Override
    public NeoForgeFileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return List.of(this.root);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return List.of();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Set.of();
    }

    @Nullable Entry resolveEntry(NeoForgePath path) {
        if (path.getFileName() == null) {
            return null;
        }
        if (path.isRoot()) {
            return this.rootEntries;
        }
        path = path.normalize().toAbsolutePath();
        List<String> names = path.names();
        Entry entry = this.rootEntries.entries.get(names.getFirst());
        for (int i = 1; i < names.size(); ++i) {
            if (!(entry instanceof Directory)) {
                return null;
            }
            Directory dir = (Directory)entry;
            entry = dir.entries().get(names.get(i - 1));
        }
        return entry;
    }

    NeoForgePath createPath(@Nullable NeoForgePath parent, String name) {
        return new NeoForgePath(this, parent, name);
    }

    @Override
    public Path getPath(String first, String ... more) {
        NeoForgePath path;
        if (first.isEmpty()) {
            return this.createPath(null, "");
        }
        if (more.length == 0) {
            path = first.startsWith("/") ? this.root : null;
            for (String sub : first.split("/")) {
                path = path == null ? this.createPath(null, sub) : path.resolve(sub);
            }
        } else {
            path = this.createPath(null, first);
            for (String sub : more) {
                path = path.resolve(sub);
            }
        }
        assert (path != null);
        return path;
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        int pos = syntaxAndPattern.indexOf(58);
        if (pos <= 0) {
            throw new IllegalArgumentException();
        }
        String syntax = syntaxAndPattern.substring(0, pos);
        String input = syntaxAndPattern.substring(pos + 1);
        if (!syntax.equalsIgnoreCase(REGEX_SYNTAX)) {
            throw new UnsupportedOperationException("Syntax '" + syntax + "' not recognized");
        }
        String expr = input;
        Pattern pattern = Pattern.compile(expr);
        return path -> pattern.matcher(path.toString()).matches();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException("Watch service is not supported for NeoForge filesystems.");
    }

    static Map<String, Entry> buildTree(JarContents contents) {
        Object2ObjectOpenHashMap rootEntries = new Object2ObjectOpenHashMap();
        contents.visitContent((arg_0, arg_1) -> NeoForgeFileSystem.lambda$buildTree$2((Map)rootEntries, arg_0, arg_1));
        return rootEntries;
    }

    private static /* synthetic */ void lambda$buildTree$2(Map rootEntries, String path, JarResource resource) {
        String[] parts = path.split("/");
        Map<String, Entry> entries = rootEntries;
        for (int i = 0; i < parts.length - 1; ++i) {
            Directory entry = (Directory)entries.computeIfAbsent(parts[i], name -> new Directory((String)name, (Map<String, Entry>)new Object2ObjectOpenHashMap()));
            entries = entry.entries;
        }
        entries.put(parts[parts.length - 1], new File(parts[parts.length - 1], resource.retain()));
    }

    record Directory(String name, Map<String, Entry> entries) implements Entry
    {
    }

    static sealed interface Entry
    permits Directory, File {
        public String name();
    }

    record File(String name, JarResource resource) implements Entry
    {
    }
}

