/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.impl.neoforge;

import dev.yumi.mc.core.impl.neoforge.NeoForgeFileSystem;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class NeoForgePath
implements Path {
    static final String ROOT = "/";
    private static final String SELF = ".";
    private static final String PARENT = "..";
    private final NeoForgeFileSystem fileSystem;
    private final @Nullable NeoForgePath parent;
    private final String name;
    private final boolean absolute;
    private final boolean normalized;
    private final int nameCount;
    private final int hash;

    public NeoForgePath(NeoForgeFileSystem fileSystem, @Nullable NeoForgePath parent, String name) {
        this.fileSystem = fileSystem;
        this.parent = parent;
        this.name = name;
        if (ROOT.equals(name)) {
            if (parent != null) {
                throw new IllegalArgumentException("Root paths cannot have a parent!");
            }
            this.nameCount = 1;
            this.absolute = true;
            this.normalized = true;
        } else {
            boolean isNormalName;
            int count = 0;
            if (parent != null) {
                count += parent.getNameCount();
            }
            if (!name.isEmpty()) {
                ++count;
            }
            this.nameCount = count;
            boolean bl = isNormalName = !name.equals(PARENT) && !name.equals(SELF);
            if (parent == null) {
                this.absolute = false;
                this.normalized = isNormalName;
            } else {
                this.absolute = parent.isAbsolute();
                this.normalized = parent.normalized && isNormalName;
            }
        }
        this.hash = fileSystem.hashCode() * 31 + (parent == null ? name.hashCode() : parent.hash * 31 + name.hashCode());
    }

    @Override
    public NeoForgeFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isRoot() {
        return this.name.equals(ROOT);
    }

    @Override
    public @Nullable Path getRoot() {
        if (this.absolute) {
            return this.fileSystem.root;
        }
        return null;
    }

    @Override
    public @Nullable Path getFileName() {
        if (this.name.isEmpty()) {
            return null;
        }
        if (this.parent == null) {
            return this;
        }
        return this.fileSystem.createPath(null, this.name);
    }

    @Override
    public @Nullable NeoForgePath getParent() {
        return this.parent;
    }

    @Override
    public int getNameCount() {
        return this.nameCount;
    }

    @Override
    public Path getName(int index) {
        if (index < 0 || index >= this.getNameCount()) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        if (index == 0 && this.parent == null) {
            return this;
        }
        if (index == this.getNameCount() - 1) {
            return this.fileSystem.createPath(null, this.name);
        }
        NeoForgePath p = this;
        for (int i = index + 1; i < this.getNameCount(); ++i) {
            if (p == null) {
                throw new IllegalStateException("Name count is incorrect: cannot find name at index " + index);
            }
            p = p.parent;
        }
        if (p == null) {
            throw new IllegalStateException("Name count is incorrect: cannot find name at index " + index);
        }
        return this.fileSystem.createPath(null, p.name);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex < 0!");
        }
        if (endIndex > this.getNameCount()) {
            throw new IllegalArgumentException("endIndex > getNameCount()!");
        }
        NeoForgePath end = this;
        for (int i = this.getNameCount(); i > endIndex; --i) {
            if (end == null) {
                throw new IllegalStateException("Name count is incorrect: cannot find name at index " + endIndex);
            }
            end = end.parent;
        }
        NeoForgePath from = end;
        ArrayList<String> names = new ArrayList<String>();
        for (int i = endIndex - 1; i > beginIndex; --i) {
            assert (from != null);
            from = from.parent;
            assert (from != null);
            names.add(from.name);
        }
        if (from == null) {
            throw new IllegalStateException("Name count is incorrect: cannot find name at index " + endIndex);
        }
        String fromS = from.name;
        if (fromS.startsWith(ROOT)) {
            fromS = fromS.substring(1);
        }
        NeoForgePath path = this.fileSystem.createPath(null, fromS);
        for (String sub : names.reversed()) {
            path = path.resolve(sub);
        }
        return path;
    }

    @Override
    public boolean startsWith(Path other) {
        if (other instanceof NeoForgePath) {
            NeoForgePath o = (NeoForgePath)other;
            if (this.isAbsolute() != o.isAbsolute()) {
                return false;
            }
            if (o.getNameCount() > this.getNameCount()) {
                return false;
            }
            NeoForgePath p = this;
            do {
                if (!other.equals(p)) continue;
                return true;
            } while ((p = p.parent) != null);
        }
        return false;
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public boolean endsWith(Path other) {
        if (other instanceof NeoForgePath) {
            NeoForgePath o = (NeoForgePath)other;
            NeoForgePath t = this;
            while (o != null && t != null) {
                if (!t.name.equals(o.name)) {
                    return false;
                }
                o = o.parent;
                t = t.parent;
            }
            return o == null;
        }
        return false;
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public NeoForgePath normalize() {
        if (this.normalized) {
            return this;
        }
        if (SELF.equals(this.name)) {
            if (this.parent != null) {
                return this.parent.normalize();
            }
            return this;
        }
        if (PARENT.equals(this.name)) {
            NeoForgePath path = this;
            if (this.parent == null) {
                return path;
            }
            NeoForgePath p = this.parent.normalize();
            if (PARENT.equals(p.name)) {
                return p.resolve(this.name);
            }
            if (p.parent != null) {
                return p.parent;
            }
            return this.fileSystem.createPath(null, SELF);
        }
        if (this.parent == null) {
            return this;
        }
        NeoForgePath p = this.parent.normalize();
        if (p == this.parent) {
            return this;
        }
        return p.resolve(this.name);
    }

    @Override
    public NeoForgePath resolve(Path other) {
        if (other.isAbsolute()) {
            return (NeoForgePath)other;
        }
        if (other.getNameCount() == 0) {
            return this;
        }
        NeoForgePath o = (NeoForgePath)other;
        ArrayDeque<NeoForgePath> stack = new ArrayDeque<NeoForgePath>();
        do {
            stack.push(o);
        } while ((o = o.parent) != null);
        NeoForgePath p = this;
        while (!stack.isEmpty()) {
            p = this.fileSystem.createPath(p, ((NeoForgePath)stack.pop()).name);
        }
        return p;
    }

    @Override
    public NeoForgePath resolve(String other) {
        NeoForgePath p = this;
        for (String s : other.split(this.fileSystem.getSeparator())) {
            if (s.isEmpty()) continue;
            p = this.fileSystem.createPath(p, s);
        }
        return p;
    }

    @Override
    public Path relativize(Path other) {
        int j;
        String b;
        String a;
        NeoForgePath o = (NeoForgePath)other;
        if (o.equals(this)) {
            return this.fileSystem.createPath(null, "");
        }
        if (this.isAbsolute() != o.isAbsolute()) {
            throw new IllegalArgumentException("You can only relativize paths if they are both absolute, OR both relative - not one and the other!");
        }
        List<String> names = this.normalize().names();
        List<String> oNames = o.normalize().names();
        for (int i = 0; i < Math.min(names.size(), oNames.size()) && (a = names.get(i)).equals(b = oNames.get(i)); ++i) {
        }
        NeoForgePath path = null;
        for (j = i; j < names.size(); ++j) {
            path = path == null ? this.fileSystem.createPath(null, PARENT) : path.resolve(PARENT);
        }
        for (j = i; j < oNames.size(); ++j) {
            path = path == null ? this.fileSystem.createPath(null, oNames.get(j)) : path.resolve(oNames.get(j));
        }
        assert (path != null);
        return path;
    }

    @Override
    public URI toUri() {
        if (!this.isAbsolute()) {
            return this.toAbsolutePath().toUri();
        }
        try {
            return new URI(this.fileSystem.provider().getScheme(), this.fileSystem.name + "!" + String.valueOf(this), null).normalize();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NeoForgePath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.fileSystem.root.resolve(this);
    }

    @Override
    public NeoForgePath toRealPath(LinkOption ... options) {
        return this.toAbsolutePath();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    List<String> names() {
        if (this.parent == null) {
            if (this.isRoot()) {
                return List.of();
            }
            return List.of(this.name);
        }
        ArrayList<String> list = new ArrayList<String>(this.getNameCount());
        NeoForgePath p = this;
        while (!p.isRoot()) {
            list.add(p.name);
            if ((p = p.getParent()) != null) continue;
        }
        return list.reversed();
    }

    @Override
    public int compareTo(Path other) {
        return this.toString().compareTo(other.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        NeoForgePath o = (NeoForgePath)obj;
        return this.fileSystem == o.fileSystem && this.absolute == o.absolute && this.normalized == o.normalized && this.nameCount == o.nameCount && this.name.equals(o.name) && Objects.equals(this.parent, o.parent);
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public String toString() {
        if (this.isRoot()) {
            return ROOT;
        }
        if (this.parent != null) {
            return (this.parent.name.equals(ROOT) ? "" : this.parent.toString()) + this.fileSystem.getSeparator() + this.name;
        }
        return this.name;
    }
}

