/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.BerException;

public class BerDecoder {
    public static final int BooleanTag = 1;
    public static final int IntegerTag = 2;
    public static final int OctetStringTag = 4;
    public static final int NullTag = 5;
    public static final int OidTag = 6;
    public static final int SequenceTag = 48;
    private final byte[] bytes;
    private int next = 0;
    private final int[] stackBuf = new int[200];
    private int stackTop = 0;

    public BerDecoder(byte[] byArray) {
        this.bytes = byArray;
        this.reset();
    }

    public void reset() {
        this.next = 0;
        this.stackTop = 0;
    }

    public int fetchInteger() throws BerException {
        return this.fetchInteger(2);
    }

    public int fetchInteger(int n) throws BerException {
        int n2 = 0;
        int n3 = this.next;
        try {
            if (this.fetchTag() != n) {
                throw new BerException();
            }
            n2 = this.fetchIntegerValue();
        }
        catch (BerException berException) {
            this.next = n3;
            throw berException;
        }
        return n2;
    }

    public long fetchIntegerAsLong() throws BerException {
        return this.fetchIntegerAsLong(2);
    }

    public long fetchIntegerAsLong(int n) throws BerException {
        long l = 0L;
        int n2 = this.next;
        try {
            if (this.fetchTag() != n) {
                throw new BerException();
            }
            l = this.fetchIntegerValueAsLong();
        }
        catch (BerException berException) {
            this.next = n2;
            throw berException;
        }
        return l;
    }

    public byte[] fetchOctetString() throws BerException {
        return this.fetchOctetString(4);
    }

    public byte[] fetchOctetString(int n) throws BerException {
        byte[] byArray = null;
        int n2 = this.next;
        try {
            if (this.fetchTag() != n) {
                throw new BerException();
            }
            byArray = this.fetchStringValue();
        }
        catch (BerException berException) {
            this.next = n2;
            throw berException;
        }
        return byArray;
    }

    public long[] fetchOid() throws BerException {
        return this.fetchOid(6);
    }

    public long[] fetchOid(int n) throws BerException {
        long[] lArray = null;
        int n2 = this.next;
        try {
            if (this.fetchTag() != n) {
                throw new BerException();
            }
            lArray = this.fetchOidValue();
        }
        catch (BerException berException) {
            this.next = n2;
            throw berException;
        }
        return lArray;
    }

    public void fetchNull() throws BerException {
        this.fetchNull(5);
    }

    public void fetchNull(int n) throws BerException {
        int n2 = this.next;
        try {
            if (this.fetchTag() != n) {
                throw new BerException();
            }
            int n3 = this.fetchLength();
            if (n3 != 0) {
                throw new BerException();
            }
        }
        catch (BerException berException) {
            this.next = n2;
            throw berException;
        }
    }

    public byte[] fetchAny() throws BerException {
        byte[] byArray = null;
        int n = this.next;
        try {
            int n2 = this.fetchTag();
            int n3 = this.fetchLength();
            if (n3 < 0) {
                throw new BerException();
            }
            int n4 = this.next + n3 - n;
            if (n3 > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            byte[] byArray2 = new byte[n4];
            System.arraycopy(this.bytes, n, byArray2, 0, n4);
            this.next += n3;
            byArray = byArray2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n;
            throw new BerException();
        }
        return byArray;
    }

    public byte[] fetchAny(int n) throws BerException {
        if (this.getTag() != n) {
            throw new BerException();
        }
        return this.fetchAny();
    }

    public void openSequence() throws BerException {
        this.openSequence(48);
    }

    public void openSequence(int n) throws BerException {
        int n2 = this.next;
        try {
            if (this.fetchTag() != n) {
                throw new BerException();
            }
            int n3 = this.fetchLength();
            if (n3 < 0) {
                throw new BerException();
            }
            if (n3 > this.bytes.length - this.next) {
                throw new BerException();
            }
            this.stackBuf[this.stackTop++] = this.next + n3;
        }
        catch (BerException berException) {
            this.next = n2;
            throw berException;
        }
    }

    public void closeSequence() throws BerException {
        if (this.stackBuf[this.stackTop - 1] == this.next) {
            --this.stackTop;
        } else {
            throw new BerException();
        }
    }

    public boolean cannotCloseSequence() {
        return this.next < this.stackBuf[this.stackTop - 1];
    }

    public int getTag() throws BerException {
        int n = 0;
        int n2 = this.next;
        try {
            n = this.fetchTag();
        }
        finally {
            this.next = n2;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.bytes.length * 2);
        for (int i = 0; i < this.bytes.length; ++i) {
            int n;
            int n2 = n = this.bytes[i] > 0 ? this.bytes[i] : this.bytes[i] + 256;
            if (i == this.next) {
                stringBuffer.append("(");
            }
            stringBuffer.append(Character.forDigit(n / 16, 16));
            stringBuffer.append(Character.forDigit(n % 16, 16));
            if (i != this.next) continue;
            stringBuffer.append(")");
        }
        if (this.bytes.length == this.next) {
            stringBuffer.append("()");
        }
        return new String(stringBuffer);
    }

    private final int fetchTag() throws BerException {
        int n = 0;
        int n2 = this.next;
        try {
            int n3 = this.bytes[this.next++];
            int n4 = n = n3 >= 0 ? n3 : n3 + 256;
            if ((n & 0x1F) == 31) {
                while ((this.bytes[this.next] & 0x80) != 0) {
                    n <<= 7;
                    n |= this.bytes[this.next++] & 0x7F;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n2;
            throw new BerException();
        }
        return n;
    }

    private final int fetchLength() throws BerException {
        int n = 0;
        int n2 = this.next;
        try {
            int n3 = this.bytes[this.next++];
            if (n3 >= 0) {
                n = n3;
            } else {
                for (int i = 128 + n3; i > 0; --i) {
                    int n4 = this.bytes[this.next++];
                    n <<= 8;
                    n |= n4 >= 0 ? n4 : n4 + 256;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n2;
            throw new BerException();
        }
        return n;
    }

    private int fetchIntegerValue() throws BerException {
        int n = 0;
        int n2 = this.next;
        try {
            int n3 = this.fetchLength();
            if (n3 <= 0) {
                throw new BerException();
            }
            if (n3 > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            int n4 = this.next + n3;
            n = this.bytes[this.next++];
            while (this.next < n4) {
                byte by;
                if ((by = this.bytes[this.next++]) < 0) {
                    n = n << 8 | 256 + by;
                    continue;
                }
                n = n << 8 | by;
            }
        }
        catch (BerException berException) {
            this.next = n2;
            throw berException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n2;
            throw new BerException();
        }
        catch (ArithmeticException arithmeticException) {
            this.next = n2;
            throw new BerException();
        }
        return n;
    }

    private final long fetchIntegerValueAsLong() throws BerException {
        long l = 0L;
        int n = this.next;
        try {
            int n2 = this.fetchLength();
            if (n2 <= 0) {
                throw new BerException();
            }
            if (n2 > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            int n3 = this.next + n2;
            l = this.bytes[this.next++];
            while (this.next < n3) {
                byte by;
                if ((by = this.bytes[this.next++]) < 0) {
                    l = l << 8 | (long)(256 + by);
                    continue;
                }
                l = l << 8 | (long)by;
            }
        }
        catch (BerException berException) {
            this.next = n;
            throw berException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n;
            throw new BerException();
        }
        catch (ArithmeticException arithmeticException) {
            this.next = n;
            throw new BerException();
        }
        return l;
    }

    private byte[] fetchStringValue() throws BerException {
        byte[] byArray = null;
        int n = this.next;
        try {
            int n2 = this.fetchLength();
            if (n2 < 0) {
                throw new BerException();
            }
            if (n2 > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.bytes, this.next, byArray2, 0, n2);
            this.next += n2;
            byArray = byArray2;
        }
        catch (BerException berException) {
            this.next = n;
            throw berException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n;
            throw new BerException();
        }
        catch (ArithmeticException arithmeticException) {
            this.next = n;
            throw new BerException();
        }
        return byArray;
    }

    private final long[] fetchOidValue() throws BerException {
        long[] lArray = null;
        int n = this.next;
        try {
            byte by;
            int n2;
            int n3 = this.fetchLength();
            if (n3 <= 0) {
                throw new BerException();
            }
            if (n3 > this.bytes.length - this.next) {
                throw new IndexOutOfBoundsException("Decoded length exceeds buffer");
            }
            int n4 = 2;
            for (n2 = 1; n2 < n3; ++n2) {
                if ((this.bytes[this.next + n2] & 0x80) != 0) continue;
                ++n4;
            }
            n2 = n4;
            long[] lArray2 = new long[n2];
            if ((by = this.bytes[this.next++]) < 0) {
                throw new BerException();
            }
            long l = by / 40;
            if (l > 2L) {
                throw new BerException();
            }
            long l2 = by % 40;
            lArray2[0] = l;
            lArray2[1] = l2;
            int n5 = 2;
            while (n5 < n2) {
                long l3 = 0L;
                byte by2 = this.bytes[this.next++];
                while ((by2 & 0x80) != 0) {
                    if ((l3 = l3 << 7 | (long)(by2 & 0x7F)) < 0L) {
                        throw new BerException();
                    }
                    by2 = this.bytes[this.next++];
                }
                if ((l3 = l3 << 7 | (long)by2) < 0L) {
                    throw new BerException();
                }
                lArray2[n5++] = l3;
            }
            lArray = lArray2;
        }
        catch (BerException berException) {
            this.next = n;
            throw berException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.next = n;
            throw new BerException();
        }
        return lArray;
    }
}

