/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.cl;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ProtectionDomainHelper {
    private static final Map<URL, CodeSource> csCache = new HashMap<URL, CodeSource>();
    private static final Map<CodeSource, ProtectionDomain> pdCache = new HashMap<CodeSource, ProtectionDomain>();
    private static final VarHandle PKG_MODULE_HANDLE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeSource createCodeSource(URL url, CodeSigner[] signers) {
        Map<URL, CodeSource> map = csCache;
        synchronized (map) {
            return csCache.computeIfAbsent(url, u -> new CodeSource(url, signers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProtectionDomain createProtectionDomain(CodeSource codeSource, ClassLoader cl) {
        Map<CodeSource, ProtectionDomain> map = pdCache;
        synchronized (map) {
            return pdCache.computeIfAbsent(codeSource, cs -> {
                Permissions perms = new Permissions();
                perms.add(new AllPermission());
                return new ProtectionDomain(codeSource, perms, cl, null);
            });
        }
    }

    static void trySetPackageModule(Package pkg, Module module) {
        Module value = PKG_MODULE_HANDLE.get(pkg);
        if (value == null || !value.isNamed()) {
            try {
                PKG_MODULE_HANDLE.set(pkg, module);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error setting package module", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Package tryDefinePackage(ClassLoader classLoader, String name, Manifest man, Function<String, Attributes> trustedEntries, Function<String[], Package> definePackage) throws IllegalArgumentException {
        String pname = name.substring(0, name.lastIndexOf(46));
        if (classLoader.getDefinedPackage(pname) == null) {
            ClassLoader classLoader2 = classLoader;
            synchronized (classLoader2) {
                if (classLoader.getDefinedPackage(pname) != null) {
                    return classLoader.getDefinedPackage(pname);
                }
                String path = pname.replace('.', '/').concat("/");
                String specTitle = null;
                String specVersion = null;
                String specVendor = null;
                String implTitle = null;
                String implVersion = null;
                String implVendor = null;
                if (man != null) {
                    Attributes attr = trustedEntries.apply(path);
                    if (attr != null) {
                        specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
                        specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
                        specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                        implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                        implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                    }
                    if ((attr = man.getMainAttributes()) != null) {
                        if (specTitle == null) {
                            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
                        }
                        if (specVersion == null) {
                            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
                        }
                        if (specVendor == null) {
                            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                        }
                        if (implTitle == null) {
                            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                        }
                        if (implVersion == null) {
                            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        }
                        if (implVendor == null) {
                            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                        }
                    }
                }
                return definePackage.apply(new String[]{pname, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor});
            }
        }
        return classLoader.getDefinedPackage(pname);
    }

    static {
        try {
            Field trustedLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            trustedLookupField.setAccessible(true);
            MethodHandles.Lookup trustedLookup = (MethodHandles.Lookup)trustedLookupField.get(null);
            Class<?> namedPackage = Class.forName("java.lang.NamedPackage");
            PKG_MODULE_HANDLE = trustedLookup.findVarHandle(namedPackage, "module", Module.class);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error finding package module handle", t);
        }
    }
}

