/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.lookup.v1.block;

import java.util.Objects;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.impl.lookup.block.BlockApiCacheImpl;
import net.fabricmc.fabric.impl.lookup.block.BlockApiLookupImpl;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.NonExtendable
public interface BlockApiCache<A, C> {
    default public @Nullable A find(C context) {
        return this.find(null, context);
    }

    public @Nullable A find(@Nullable class_2680 var1, C var2);

    public @Nullable class_2586 getBlockEntity();

    public BlockApiLookup<A, C> getLookup();

    public class_3218 getWorld();

    public class_2338 getPos();

    public static <A, C> BlockApiCache<A, C> create(BlockApiLookup<A, C> lookup, class_3218 world, class_2338 pos) {
        Objects.requireNonNull(pos, "BlockPos may not be null.");
        Objects.requireNonNull(world, "ServerWorld may not be null.");
        if (!(lookup instanceof BlockApiLookupImpl)) {
            throw new IllegalArgumentException("Cannot cache foreign implementation of BlockApiLookup. Use `BlockApiLookup#get(Identifier, Class<A>, Class<C>);` to get instances.");
        }
        return new BlockApiCacheImpl((BlockApiLookupImpl)lookup, world, pos);
    }
}

