/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.LaunchServiceHandler;
import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformationServicesHandler;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.TypesafeMap;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.util.Supplier;

public class Launcher {
    public static Launcher INSTANCE;
    private final TypesafeMap blackboard;
    private final TransformationServicesHandler transformationServicesHandler;
    private final Environment environment;
    private final TransformStore transformStore;
    private final ArgumentHandler argumentHandler;
    private final LaunchServiceHandler launchService;
    private final LaunchPluginHandler launchPlugins;
    private final ModuleLayerHandler moduleLayerHandler;
    private TransformingClassLoader classLoader;

    private Launcher() {
        INSTANCE = this;
        LogManager.getLogger().info(LogMarkers.MODLAUNCHER, "ModLauncher {} starting: java version {} by {}; OS {} arch {} version {}", new Supplier[]{() -> IEnvironment.class.getPackage().getImplementationVersion(), () -> System.getProperty("java.version"), () -> System.getProperty("java.vendor"), () -> System.getProperty("os.name"), () -> System.getProperty("os.arch"), () -> System.getProperty("os.version")});
        this.moduleLayerHandler = new ModuleLayerHandler();
        this.launchService = new LaunchServiceHandler(this.moduleLayerHandler);
        this.blackboard = new TypesafeMap();
        this.environment = new Environment(this);
        this.environment.computePropertyIfAbsent(IEnvironment.Keys.MLSPEC_VERSION.get(), s -> IEnvironment.class.getPackage().getSpecificationVersion());
        this.environment.computePropertyIfAbsent(IEnvironment.Keys.MLIMPL_VERSION.get(), s -> IEnvironment.class.getPackage().getImplementationVersion());
        this.environment.computePropertyIfAbsent(IEnvironment.Keys.MODLIST.get(), s -> new ArrayList());
        this.transformStore = new TransformStore();
        this.transformationServicesHandler = new TransformationServicesHandler(this.transformStore, this.moduleLayerHandler);
        this.argumentHandler = new ArgumentHandler();
        this.launchPlugins = new LaunchPluginHandler(this.moduleLayerHandler);
    }

    public static void main(String ... args) {
        Properties props = System.getProperties();
        if (props.getProperty("java.vm.name").contains("OpenJ9")) {
            System.err.printf("WARNING: OpenJ9 is detected. This is definitely unsupported and you may encounter issues and significantly worse performance.\nFor support and performance reasons, we recommend installing a temurin JVM from https://adoptium.net/\nJVM information: %s %s %s\n", props.getProperty("java.vm.vendor"), props.getProperty("java.vm.name"), props.getProperty("java.vm.version"));
        }
        LogManager.getLogger().info(LogMarkers.MODLAUNCHER, "ModLauncher running: args {}", new Supplier[]{() -> LaunchServiceHandler.hideAccessToken(args)});
        LogManager.getLogger().info(LogMarkers.MODLAUNCHER, "JVM identified as {} {} {}", (Object)props.getProperty("java.vm.vendor"), (Object)props.getProperty("java.vm.name"), (Object)props.getProperty("java.vm.version"));
        new Launcher().run(args);
    }

    public final TypesafeMap blackboard() {
        return this.blackboard;
    }

    private void run(String ... args) {
        ArgumentHandler.DiscoveryData discoveryData = this.argumentHandler.setArgs(args);
        this.transformationServicesHandler.discoverServices(discoveryData);
        Map<IModuleLayerManager.Layer, List<ITransformationService.Resource>> scanResults = this.transformationServicesHandler.initializeTransformationServices(this.argumentHandler, this.environment).stream().collect(Collectors.groupingBy(ITransformationService.Resource::target));
        scanResults.getOrDefault((Object)IModuleLayerManager.Layer.PLUGIN, List.of()).stream().mapMulti((resource, action) -> resource.resources().forEach(action)).forEach(np -> this.moduleLayerHandler.addToLayer(IModuleLayerManager.Layer.PLUGIN, (SecureJar)np));
        this.moduleLayerHandler.buildLayer(IModuleLayerManager.Layer.PLUGIN);
        Map<IModuleLayerManager.Layer, List<ITransformationService.Resource>> gameResults = this.transformationServicesHandler.triggerScanCompletion(this.moduleLayerHandler).stream().collect(Collectors.groupingBy(ITransformationService.Resource::target));
        List<SecureJar> gameContents = Stream.of(scanResults, gameResults).flatMap(m -> m.getOrDefault((Object)IModuleLayerManager.Layer.GAME, List.of()).stream()).mapMulti((resource, action) -> resource.resources().forEach(action)).toList();
        gameContents.forEach(j -> this.moduleLayerHandler.addToLayer(IModuleLayerManager.Layer.GAME, (SecureJar)j));
        this.transformationServicesHandler.initialiseServiceTransformers();
        this.launchPlugins.offerScanResultsToPlugins(gameContents);
        this.launchService.validateLaunchTarget(this.argumentHandler);
        this.classLoader = this.transformationServicesHandler.buildTransformingClassLoader(this.launchPlugins, this.environment, this.moduleLayerHandler);
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.classLoader));
        this.launchService.launch(this.argumentHandler, this.moduleLayerHandler.getLayer(IModuleLayerManager.Layer.GAME).orElseThrow(), this.classLoader, this.launchPlugins);
    }

    public Environment environment() {
        return this.environment;
    }

    Optional<ILaunchPluginService> findLaunchPlugin(String name) {
        return this.launchPlugins.get(name);
    }

    Optional<ILaunchHandlerService> findLaunchHandler(String name) {
        return this.launchService.findLaunchHandler(name);
    }

    public Optional<IModuleLayerManager> findLayerManager() {
        return Optional.ofNullable(this.moduleLayerHandler);
    }
}

