/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.config;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.file.JsonArrayFileHelper;
import mezz.jei.common.util.DeduplicatingRunner;
import mezz.jei.common.util.ServerConfigPathUtil;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.config.ILookupHistoryConfig;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Unmodifiable;

public class LookupHistoryJsonConfig
implements ILookupHistoryConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Duration SAVE_DELAY_TIME = Duration.ofSeconds(5L);
    private static final int VERSION = 1;
    private final Path jeiConfigurationDir;
    private final DeduplicatingRunner delayedSave = new DeduplicatingRunner(SAVE_DELAY_TIME);

    private static Optional<Path> getPath(Path jeiConfigurationDir) {
        return ServerConfigPathUtil.getWorldPath(jeiConfigurationDir).flatMap(configPath -> {
            try {
                Files.createDirectories(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Unable to create lookup history config folder: {}", configPath, (Object)e);
                return Optional.empty();
            }
            Path path = configPath.resolve("lookupHistory.json");
            return Optional.of(path);
        });
    }

    public LookupHistoryJsonConfig(Path jeiConfigurationDir) {
        this.jeiConfigurationDir = jeiConfigurationDir;
    }

    private class_6903<JsonElement> getRegistryOps(class_5455 registryAccess) {
        return registryAccess.method_57093((DynamicOps)JsonOps.INSTANCE);
    }

    @Override
    public void save(IRecipeManager recipeManager, IIngredientManager ingredientManager, class_5455 registryAccess, ICodecHelper codecHelper, List<IBookmark> bookmarks, Codec<IBookmark> bookmarkCodec) {
        LookupHistoryJsonConfig.getPath(this.jeiConfigurationDir).ifPresent(path -> this.delayedSave.run(() -> this.save((Path)path, bookmarkCodec, registryAccess, bookmarks)));
    }

    private void save(Path path, Codec<IBookmark> bookmarkCodec, class_5455 registryAccess, List<IBookmark> bookmarks) {
        class_6903<JsonElement> registryOps = this.getRegistryOps(registryAccess);
        try (BufferedWriter out = Files.newBufferedWriter(path, new OpenOption[0]);){
            JsonArrayFileHelper.write(out, 1, bookmarks, bookmarkCodec, registryOps, error -> LOGGER.error("Encountered an error when saving the lookup history config to file {}\n{}", (Object)path, error), (element, exception) -> LOGGER.error("Encountered an exception when saving the lookup history config to file {}\n{}", (Object)path, element, exception));
            LOGGER.debug("Saved lookup history config to file: {}", (Object)path);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save lookup history config to file {}", (Object)path, (Object)e);
        }
    }

    @Override
    public List<IBookmark> load(IRecipeManager recipeManager, IIngredientManager ingredientManager, class_5455 registryAccess, ICodecHelper codecHelper, Codec<IBookmark> bookmarkCodec) {
        class_6903<JsonElement> registryOps = this.getRegistryOps(registryAccess);
        return this.loadJsonBookmarks(ingredientManager, recipeManager, registryOps, codecHelper, bookmarkCodec);
    }

    private @Unmodifiable List<IBookmark> loadJsonBookmarks(IIngredientManager ingredientManager, IRecipeManager recipeManager, class_6903<JsonElement> registryOps, ICodecHelper codecHelper, Codec<IBookmark> bookmarkCodec) {
        return LookupHistoryJsonConfig.getPath(this.jeiConfigurationDir).map(path -> {
            List<Object> bookmarks;
            if (!Files.exists(path, new LinkOption[0])) {
                return List.of();
            }
            try (BufferedReader reader = Files.newBufferedReader(path);){
                bookmarks = JsonArrayFileHelper.read(reader, 1, bookmarkCodec, (DynamicOps<JsonElement>)registryOps, (element, error) -> LOGGER.error("Encountered an error when loading the lookup history config from file {}\n{}\n{}", path, element, error), (element, exception) -> LOGGER.error("Encountered an exception when loading the lookup history config from file {}\n{}", path, element, exception));
                LOGGER.debug("Loaded lookup history config from file: {}", path);
            }
            catch (IOException | RuntimeException e) {
                LOGGER.error("Failed to load lookup history from file {}", path, (Object)e);
                bookmarks = new ArrayList();
            }
            return bookmarks;
        }).orElseGet(List::of);
    }
}

