/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.events;

import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.RectDebugger;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

public class GuiEventHandler {
    private final IngredientListOverlay ingredientListOverlay;
    private final IScreenHelper screenHelper;
    private final BookmarkOverlay bookmarkOverlay;

    public GuiEventHandler(IScreenHelper screenHelper, BookmarkOverlay bookmarkOverlay, IngredientListOverlay ingredientListOverlay) {
        this.screenHelper = screenHelper;
        this.bookmarkOverlay = bookmarkOverlay;
        this.ingredientListOverlay = ingredientListOverlay;
    }

    public void onGuiInit(class_437 screen) {
        Set<ImmutableRect2i> guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
        this.ingredientListOverlay.getScreenPropertiesUpdater().updateScreen(screen).updateExclusionAreas(guiExclusionAreas).update();
        this.bookmarkOverlay.getScreenPropertiesUpdater().updateScreen(screen).updateExclusionAreas(guiExclusionAreas).update();
    }

    public void onGuiOpen(class_437 screen) {
        this.ingredientListOverlay.getScreenPropertiesUpdater().updateScreen(screen).update();
        this.bookmarkOverlay.getScreenPropertiesUpdater().updateScreen(screen).update();
    }

    public void drawForContainerScreen(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY) {
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.pushMatrix();
        IGuiProperties guiProperties = this.screenHelper.getGuiProperties(screen).orElse(null);
        if (guiProperties != null) {
            poseStack.translate((float)(-guiProperties.guiLeft()), (float)(-guiProperties.guiTop()));
            this.bookmarkOverlay.drawOnForeground(guiGraphics, mouseX, mouseY);
            this.ingredientListOverlay.drawOnForeground(guiGraphics, mouseX, mouseY);
        }
        this.drawMainContents((class_437)screen, guiProperties, guiGraphics, mouseX, mouseY);
        poseStack.popMatrix();
    }

    public void drawForScreen(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY) {
        if (screen instanceof class_465) {
            return;
        }
        IGuiProperties guiProperties = this.screenHelper.getGuiProperties(screen).orElse(null);
        this.drawMainContents(screen, guiProperties, guiGraphics, mouseX, mouseY);
    }

    private void drawMainContents(class_437 screen, @Nullable IGuiProperties guiProperties, class_332 guiGraphics, int mouseX, int mouseY) {
        class_310 minecraft = class_310.method_1551();
        Set<ImmutableRect2i> guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
        this.ingredientListOverlay.getScreenPropertiesUpdater().updateScreen(guiProperties).updateExclusionAreas(guiExclusionAreas).update();
        this.bookmarkOverlay.getScreenPropertiesUpdater().updateScreen(guiProperties).updateExclusionAreas(guiExclusionAreas).update();
        class_9779 deltaTracker = minecraft.method_61966();
        float partialTicks = deltaTracker.method_60637(false);
        this.ingredientListOverlay.drawScreen(minecraft, guiGraphics, mouseX, mouseY, partialTicks);
        this.bookmarkOverlay.drawScreen(minecraft, guiGraphics, mouseX, mouseY, partialTicks);
        if (guiProperties != null && screen instanceof class_465) {
            class_465 guiContainer = (class_465)screen;
            int guiLeft = guiProperties.guiLeft();
            int guiTop = guiProperties.guiTop();
            this.screenHelper.getGuiClickableArea(guiContainer, mouseX - guiLeft, mouseY - guiTop).filter(IGuiClickableArea::isTooltipEnabled).findFirst().ifPresent(area -> {
                JeiTooltip tooltip = new JeiTooltip();
                area.getTooltip(tooltip);
                if (tooltip.isEmpty()) {
                    tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.show.recipes"));
                }
                tooltip.draw(guiGraphics, mouseX, mouseY);
            });
        }
        this.ingredientListOverlay.drawTooltips(minecraft, guiGraphics, mouseX, mouseY);
        this.bookmarkOverlay.drawTooltips(minecraft, guiGraphics, mouseX, mouseY);
        if (DebugConfig.isDebugGuisEnabled()) {
            this.drawDebugInfoForScreen(screen, guiProperties, guiGraphics);
        }
    }

    public boolean renderCompactPotionIndicators() {
        return this.ingredientListOverlay.isListDisplayed();
    }

    private void drawDebugInfoForScreen(class_437 screen, @Nullable IGuiProperties guiProperties, class_332 guiGraphics) {
        RectDebugger.INSTANCE.draw(guiGraphics);
        if (guiProperties != null) {
            Set guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).collect(Collectors.toUnmodifiableSet());
            for (class_768 area : guiExclusionAreas) {
                guiGraphics.method_25294(area.method_3321(), area.method_3322(), area.method_3321() + area.method_3319(), area.method_3322() + area.method_3320(), 0x44FF0000);
            }
        } else {
            return;
        }
        guiGraphics.method_25294(guiProperties.guiLeft(), guiProperties.guiTop(), guiProperties.guiLeft() + guiProperties.guiXSize(), guiProperties.guiTop() + guiProperties.guiYSize(), 0x22CCCC00);
    }
}

