/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.text2speech;

import ca.weblite.objc.Client;
import ca.weblite.objc.NSObject;
import ca.weblite.objc.Proxy;
import ca.weblite.objc.RuntimeUtils;
import ca.weblite.objc.annotations.Msg;
import com.google.common.collect.Queues;
import com.mojang.text2speech.Narrator;
import com.sun.jna.Pointer;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarratorMac
extends NSObject
implements Narrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NarratorMac.class);
    private final Proxy synth = Client.getInstance().sendProxy("NSSpeechSynthesizer", "alloc", new Object[0]);
    private final Queue<String> queue = Queues.newConcurrentLinkedQueue();
    private boolean speaking;
    private boolean crashed;

    public NarratorMac() {
        super("NSObject");
        if (Pointer.nativeValue((Pointer)this.synth.getPeer()) == 0L) {
            throw new Narrator.FatalException("Failed to create `NSSpeechSynthesizer`");
        }
        if (Pointer.nativeValue((Pointer)this.getPeer()) == 0L) {
            throw new Narrator.FatalException("Failed to create `NSSpeechSynthesizerDelegate`");
        }
        this.init();
        this.setDelegate();
    }

    private void init() {
        Pointer init = RuntimeUtils.sel((String)"init");
        if (Pointer.nativeValue((Pointer)init) == 0L) {
            throw new Narrator.FatalException("Failed to find `init` selector");
        }
        RuntimeUtils.msg((Pointer)this.synth.getPeer(), (Pointer)init, (Object[])new Object[0]);
    }

    private void setDelegate() {
        Pointer setDelegate = RuntimeUtils.sel((String)"setDelegate:");
        if (Pointer.nativeValue((Pointer)setDelegate) == 0L) {
            throw new Narrator.FatalException("Failed to find `setDelegate:` selector");
        }
        RuntimeUtils.msg((Pointer)this.synth.getPeer(), (Pointer)setDelegate, (Object[])new Object[]{this.getPeer()});
    }

    private void startSpeaking(String message) {
        this.synth.send("startSpeakingString:", new Object[]{message});
    }

    @Msg(selector="speechSynthesizer:didFinishSpeaking:", signature="v@:B")
    public void didFinishSpeaking(boolean naturally) {
        if (this.queue.isEmpty()) {
            this.speaking = false;
        } else {
            this.startSpeaking(this.queue.poll());
        }
    }

    @Override
    public void say(String msg, boolean interrupt, float volume) {
        if (this.crashed) {
            return;
        }
        try {
            this.synth.send("setVolume:", new Object[]{Float.valueOf(volume)});
            if (interrupt) {
                this.synth.send("stopSpeaking", new Object[0]);
            }
            if (this.speaking) {
                this.queue.offer(msg);
            } else {
                this.speaking = true;
                this.startSpeaking(msg);
            }
        }
        catch (Throwable e) {
            this.crashed = true;
            LOGGER.error("Narrator crashed", e);
        }
    }

    @Override
    public void clear() {
        this.queue.clear();
        this.synth.send("stopSpeaking", new Object[0]);
    }

    @Override
    public void destroy() {
    }
}

