/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.art.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.art.internal.Pair;

class AsyncHelper {
    private final ExecutorService exec;

    AsyncHelper(int threads) {
        if (threads <= 0) {
            throw new IllegalArgumentException("Really.. no threads to process things? What do you want me to use a genie?");
        }
        this.exec = threads == 1 ? Executors.newSingleThreadExecutor() : Executors.newWorkStealingPool(threads);
    }

    public <I> void consumeAll(Collection<? extends I> inputs, Function<I, String> namer, Consumer<I> consumer) {
        Function<Object, Pair> toCallable = i -> new Pair(namer.apply(i), () -> {
            consumer.accept(i);
            return null;
        });
        this.invokeAll(inputs.stream().map(toCallable).collect(Collectors.toList()));
    }

    public <I, O> List<O> invokeAll(Collection<? extends I> inputs, Function<I, String> namer, Function<I, O> converter) {
        Function<Object, Pair> toCallable = i -> new Pair(namer.apply(i), () -> converter.apply(i));
        return this.invokeAll(inputs.stream().map(toCallable).collect(Collectors.toList()));
    }

    public <O> List<O> invokeAll(Collection<Pair<String, ? extends Callable<O>>> tasks) {
        ArrayList ret = new ArrayList(tasks.size());
        ArrayList<Pair<String, Future<O>>> processed = new ArrayList<Pair<String, Future<O>>>(tasks.size());
        for (Pair<String, Callable<O>> pair : tasks) {
            processed.add(new Pair<String, Future<O>>(pair.getLeft(), this.exec.submit(pair.getRight())));
        }
        for (Pair<String, Callable<Object>> pair : processed) {
            try {
                Object done = ((Future)((Object)pair.getRight())).get();
                if (done == null) continue;
                ret.add(done);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Failed to execute task " + pair.getLeft(), e);
            }
        }
        return ret;
    }

    public void shutdown() {
        this.exec.shutdown();
    }
}

