/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.realmsclient.RealmsMainScreen;
import java.net.URI;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerLinksScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.social.SocialInteractionsScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerLinks;
import net.minecraft.util.CommonLinks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.ModListScreen;

@OnlyIn(value=Dist.CLIENT)
public class PauseScreen
extends Screen {
    private static final ResourceLocation DRAFT_REPORT_SPRITE = ResourceLocation.withDefaultNamespace("icon/draft_report");
    private static final int COLUMNS = 2;
    private static final int MENU_PADDING_TOP = 50;
    private static final int BUTTON_PADDING = 4;
    private static final int BUTTON_WIDTH_FULL = 204;
    private static final int BUTTON_WIDTH_HALF = 98;
    private static final Component RETURN_TO_GAME = Component.translatable((String)"menu.returnToGame");
    private static final Component ADVANCEMENTS = Component.translatable((String)"gui.advancements");
    private static final Component STATS = Component.translatable((String)"gui.stats");
    private static final Component SEND_FEEDBACK = Component.translatable((String)"menu.sendFeedback");
    private static final Component REPORT_BUGS = Component.translatable((String)"menu.reportBugs");
    private static final Component FEEDBACK_SUBSCREEN = Component.translatable((String)"menu.feedback");
    private static final Component SERVER_LINKS = Component.translatable((String)"menu.server_links");
    private static final Component OPTIONS = Component.translatable((String)"menu.options");
    private static final Component SHARE_TO_LAN = Component.translatable((String)"menu.shareToLan");
    private static final Component PLAYER_REPORTING = Component.translatable((String)"menu.playerReporting");
    private static final Component RETURN_TO_MENU = Component.translatable((String)"menu.returnToMenu");
    private static final Component SAVING_LEVEL = Component.translatable((String)"menu.savingLevel");
    private static final Component GAME = Component.translatable((String)"menu.game");
    private static final Component PAUSED = Component.translatable((String)"menu.paused");
    private final boolean showPauseMenu;
    @Nullable
    private Button disconnectButton;

    public PauseScreen(boolean p_96308_) {
        super(p_96308_ ? GAME : PAUSED);
        this.showPauseMenu = p_96308_;
    }

    public boolean showsPauseMenu() {
        return this.showPauseMenu;
    }

    @Override
    protected void init() {
        if (this.showPauseMenu) {
            this.createPauseMenu();
        }
        this.addRenderableWidget(new StringWidget(0, this.showPauseMenu ? 40 : 10, this.width, 9, this.title, this.font));
    }

    private void createPauseMenu() {
        GridLayout gridlayout = new GridLayout();
        gridlayout.defaultCellSetting().padding(4, 4, 4, 0);
        GridLayout.RowHelper gridlayout$rowhelper = gridlayout.createRowHelper(2);
        gridlayout$rowhelper.addChild((LayoutElement)Button.builder(RETURN_TO_GAME, p_280814_ -> {
            this.minecraft.setScreen(null);
            this.minecraft.mouseHandler.grabMouse();
        }).width(204).build(), 2, gridlayout.newCellSettings().paddingTop(50));
        gridlayout$rowhelper.addChild((LayoutElement)this.openScreenButton(ADVANCEMENTS, () -> new AdvancementsScreen(this.minecraft.player.connection.getAdvancements(), this)));
        gridlayout$rowhelper.addChild((LayoutElement)this.openScreenButton(STATS, () -> new StatsScreen((Screen)this, this.minecraft.player.getStats())));
        ServerLinks serverlinks = this.minecraft.player.connection.serverLinks();
        if (serverlinks.isEmpty()) {
            PauseScreen.addFeedbackButtons(this, gridlayout$rowhelper);
        } else {
            gridlayout$rowhelper.addChild((LayoutElement)this.openScreenButton(FEEDBACK_SUBSCREEN, () -> new FeedbackSubScreen(this)));
            gridlayout$rowhelper.addChild((LayoutElement)this.openScreenButton(SERVER_LINKS, () -> new ServerLinksScreen((Screen)this, serverlinks)));
        }
        gridlayout$rowhelper.addChild((LayoutElement)this.openScreenButton(OPTIONS, () -> new OptionsScreen((Screen)this, this.minecraft.options)));
        if (this.minecraft.hasSingleplayerServer() && !this.minecraft.getSingleplayerServer().isPublished()) {
            gridlayout$rowhelper.addChild((LayoutElement)this.openScreenButton(SHARE_TO_LAN, () -> new ShareToLanScreen((Screen)this)));
        } else {
            gridlayout$rowhelper.addChild((LayoutElement)this.openScreenButton(PLAYER_REPORTING, () -> new SocialInteractionsScreen((Screen)this)));
        }
        gridlayout$rowhelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"fml.menu.mods"), button -> this.minecraft.setScreen((Screen)new ModListScreen((Screen)this))).width(204).build(), 2);
        Component component = this.minecraft.isLocalServer() ? RETURN_TO_MENU : CommonComponents.GUI_DISCONNECT;
        this.disconnectButton = (Button)gridlayout$rowhelper.addChild((LayoutElement)Button.builder(component, p_280815_ -> {
            p_280815_.active = false;
            this.minecraft.getReportingContext().draftReportHandled(this.minecraft, (Screen)this, this::onDisconnect, true);
        }).width(204).build(), 2);
        gridlayout.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)gridlayout, (int)0, (int)0, (int)this.width, (int)this.height, (float)0.5f, (float)0.25f);
        gridlayout.visitWidgets(this::addRenderableWidget);
    }

    static void addFeedbackButtons(Screen p_350532_, GridLayout.RowHelper p_351050_) {
        p_351050_.addChild((LayoutElement)PauseScreen.openLinkButton(p_350532_, SEND_FEEDBACK, SharedConstants.getCurrentVersion().isStable() ? CommonLinks.RELEASE_FEEDBACK : CommonLinks.SNAPSHOT_FEEDBACK));
        ((Button)p_351050_.addChild((LayoutElement)PauseScreen.openLinkButton((Screen)p_350532_, (Component)PauseScreen.REPORT_BUGS, (URI)CommonLinks.SNAPSHOT_BUGS_FEEDBACK))).active = !SharedConstants.getCurrentVersion().getDataVersion().isSideSeries();
    }

    private void onDisconnect() {
        boolean flag = this.minecraft.isLocalServer();
        ServerData serverdata = this.minecraft.getCurrentServer();
        this.minecraft.level.disconnect();
        if (flag) {
            this.minecraft.disconnect((Screen)new GenericMessageScreen(SAVING_LEVEL));
        } else {
            this.minecraft.disconnect();
        }
        TitleScreen titlescreen = new TitleScreen();
        if (flag) {
            this.minecraft.setScreen(titlescreen);
        } else if (serverdata != null && serverdata.isRealm()) {
            this.minecraft.setScreen((Screen)new RealmsMainScreen((Screen)titlescreen));
        } else {
            this.minecraft.setScreen((Screen)new JoinMultiplayerScreen((Screen)titlescreen));
        }
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void render(GuiGraphics p_281899_, int p_281431_, int p_283183_, float p_281435_) {
        super.render(p_281899_, p_281431_, p_283183_, p_281435_);
        if (this.showPauseMenu && this.minecraft != null && this.minecraft.getReportingContext().hasDraftReport() && this.disconnectButton != null) {
            p_281899_.blitSprite(DRAFT_REPORT_SPRITE, this.disconnectButton.getX() + this.disconnectButton.getWidth() - 17, this.disconnectButton.getY() + 3, 15, 15);
        }
    }

    @Override
    public void renderBackground(GuiGraphics p_295883_, int p_294974_, int p_295209_, float p_295290_) {
        if (this.showPauseMenu) {
            super.renderBackground(p_295883_, p_294974_, p_295209_, p_295290_);
        }
    }

    private Button openScreenButton(Component p_262567_, Supplier<Screen> p_262581_) {
        return Button.builder(p_262567_, p_280817_ -> this.minecraft.setScreen((Screen)((Object)((Object)p_262581_.get())))).width(98).build();
    }

    private static Button openLinkButton(Screen p_350313_, Component p_262593_, URI p_352111_) {
        return Button.builder(p_262593_, ConfirmLinkScreen.confirmLink((Screen)p_350313_, (URI)p_352111_)).width(98).build();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FeedbackSubScreen
    extends Screen {
        private static final Component TITLE = Component.translatable((String)"menu.feedback.title");
        public final Screen parent;
        private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);

        protected FeedbackSubScreen(Screen p_350989_) {
            super(TITLE);
            this.parent = p_350989_;
        }

        @Override
        protected void init() {
            this.layout.addTitleHeader(TITLE, this.font);
            GridLayout gridlayout = (GridLayout)this.layout.addToContents((LayoutElement)new GridLayout());
            gridlayout.defaultCellSetting().padding(4, 4, 4, 0);
            GridLayout.RowHelper gridlayout$rowhelper = gridlayout.createRowHelper(2);
            PauseScreen.addFeedbackButtons(this, gridlayout$rowhelper);
            this.layout.addToFooter((LayoutElement)Button.builder(CommonComponents.GUI_BACK, p_350752_ -> this.onClose()).width(200).build());
            this.layout.visitWidgets(this::addRenderableWidget);
            this.repositionElements();
        }

        @Override
        protected void repositionElements() {
            this.layout.arrangeElements();
        }

        @Override
        public void onClose() {
            this.minecraft.setScreen(this.parent);
        }
    }
}

