/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.locale;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringDecomposer;
import net.neoforged.neoforge.server.LanguageHook;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class Language {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final Pattern UNSUPPORTED_FORMAT_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]");
    public static final String DEFAULT = "en_us";
    private static volatile Language instance = Language.loadDefault();

    private static Language loadDefault() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BiConsumer<String, String> biconsumer = (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1);
        final HashMap componentMap = new HashMap();
        Language.parseTranslations(biconsumer, componentMap::put, "/assets/minecraft/lang/en_us.json");
        final HashMap map = new HashMap(builder.build());
        LanguageHook.captureLanguageMap(map, componentMap);
        return new Language(){

            @Override
            public String getOrDefault(String p_128127_, String p_265421_) {
                return map.getOrDefault(p_128127_, p_265421_);
            }

            @Override
            public boolean has(String p_128135_) {
                return map.containsKey(p_128135_);
            }

            @Override
            public boolean isDefaultRightToLeft() {
                return false;
            }

            @Override
            public FormattedCharSequence getVisualOrder(FormattedText p_128129_) {
                return p_128132_ -> p_128129_.visit((p_177835_, p_177836_) -> StringDecomposer.iterateFormatted((String)p_177836_, (Style)p_177835_, (FormattedCharSink)p_128132_) ? Optional.empty() : FormattedText.STOP_ITERATION, Style.EMPTY).isPresent();
            }

            @Override
            public Map<String, String> getLanguageData() {
                return map;
            }

            @Override
            @Nullable
            public Component getComponent(String key) {
                return (Component)componentMap.get(key);
            }
        };
    }

    @Deprecated
    private static void parseTranslations(BiConsumer<String, String> p_282031_, String p_283638_) {
        Language.parseTranslations(p_282031_, (key, value) -> {}, p_283638_);
    }

    private static void parseTranslations(BiConsumer<String, String> p_282031_, BiConsumer<String, Component> componentConsumer, String p_283638_) {
        try (InputStream inputstream = Language.class.getResourceAsStream(p_283638_);){
            Language.loadFromJson(inputstream, p_282031_, componentConsumer);
        }
        catch (JsonParseException | IOException ioexception) {
            LOGGER.error("Couldn't read strings from {}", (Object)p_283638_, (Object)ioexception);
        }
    }

    public static void loadFromJson(InputStream p_128109_, BiConsumer<String, String> p_128110_) {
        Language.loadFromJson(p_128109_, p_128110_, (key, value) -> {});
    }

    public static void loadFromJson(InputStream p_128109_, BiConsumer<String, String> p_128110_, BiConsumer<String, Component> componentConsumer) {
        JsonObject jsonobject = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(p_128109_, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry entry : jsonobject.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonArray()) {
                Component component = (Component)ComponentSerialization.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue())).getOrThrow(msg -> new JsonParseException("Error parsing translation for " + (String)entry.getKey() + ": " + msg));
                p_128110_.accept((String)entry.getKey(), component.getString());
                componentConsumer.accept((String)entry.getKey(), component);
                continue;
            }
            String s = UNSUPPORTED_FORMAT_PATTERN.matcher(GsonHelper.convertToString((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()))).replaceAll("%$1s");
            p_128110_.accept((String)entry.getKey(), s);
        }
    }

    public static Language getInstance() {
        return instance;
    }

    public static void inject(Language p_128115_) {
        instance = p_128115_;
    }

    public Map<String, String> getLanguageData() {
        return ImmutableMap.of();
    }

    @Nullable
    public Component getComponent(String key) {
        return null;
    }

    public String getOrDefault(String p_128111_) {
        return this.getOrDefault(p_128111_, p_128111_);
    }

    public abstract String getOrDefault(String var1, String var2);

    public abstract boolean has(String var1);

    public abstract boolean isDefaultRightToLeft();

    public abstract FormattedCharSequence getVisualOrder(FormattedText var1);

    public List<FormattedCharSequence> getVisualOrder(List<FormattedText> p_128113_) {
        return (List)p_128113_.stream().map(this::getVisualOrder).collect(ImmutableList.toImmutableList());
    }
}

