/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Comparators;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.event.EventHooks;
import org.slf4j.Logger;

public class PlayerChunkSender {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final float MIN_CHUNKS_PER_TICK = 0.01f;
    public static final float MAX_CHUNKS_PER_TICK = 64.0f;
    private static final float START_CHUNKS_PER_TICK = 9.0f;
    private static final int MAX_UNACKNOWLEDGED_BATCHES = 10;
    private final LongSet pendingChunks = new LongOpenHashSet();
    private final boolean memoryConnection;
    private float desiredChunksPerTick = 9.0f;
    private float batchQuota;
    private int unacknowledgedBatches;
    private int maxUnacknowledgedBatches = 1;

    public PlayerChunkSender(boolean p_294754_) {
        this.memoryConnection = p_294754_;
    }

    public void markChunkPendingToSend(LevelChunk p_296454_) {
        this.pendingChunks.add(p_296454_.getPos().toLong());
    }

    public void dropChunk(ServerPlayer p_294214_, ChunkPos p_294933_) {
        if (!this.pendingChunks.remove(p_294933_.toLong()) && p_294214_.isAlive()) {
            p_294214_.connection.send((Packet<?>)new ClientboundForgetLevelChunkPacket(p_294933_));
        }
    }

    public void sendNextChunks(ServerPlayer p_296009_) {
        if (this.unacknowledgedBatches < this.maxUnacknowledgedBatches) {
            float f = Math.max(1.0f, this.desiredChunksPerTick);
            this.batchQuota = Math.min(this.batchQuota + this.desiredChunksPerTick, f);
            if (!(this.batchQuota < 1.0f) && !this.pendingChunks.isEmpty()) {
                ServerLevel serverlevel = p_296009_.serverLevel();
                ChunkMap chunkmap = serverlevel.getChunkSource().chunkMap;
                List<LevelChunk> list = this.collectChunksToSend(chunkmap, p_296009_.chunkPosition());
                if (!list.isEmpty()) {
                    ServerGamePacketListenerImpl servergamepacketlistenerimpl = p_296009_.connection;
                    ++this.unacknowledgedBatches;
                    servergamepacketlistenerimpl.send((Packet<?>)ClientboundChunkBatchStartPacket.INSTANCE);
                    for (LevelChunk levelchunk : list) {
                        PlayerChunkSender.sendChunk(servergamepacketlistenerimpl, serverlevel, levelchunk);
                    }
                    servergamepacketlistenerimpl.send((Packet<?>)new ClientboundChunkBatchFinishedPacket(list.size()));
                    this.batchQuota -= (float)list.size();
                }
            }
        }
    }

    private static void sendChunk(ServerGamePacketListenerImpl p_295237_, ServerLevel p_294963_, LevelChunk p_295144_) {
        p_295237_.send(p_295144_.getAuxLightManager(p_295144_.getPos()).sendLightDataTo(new ClientboundLevelChunkWithLightPacket(p_295144_, p_294963_.getLightEngine(), null, null)));
        ChunkPos chunkpos = p_295144_.getPos();
        DebugPackets.sendPoiPacketsForChunk((ServerLevel)p_294963_, (ChunkPos)chunkpos);
        EventHooks.fireChunkSent((ServerPlayer)p_295237_.player, (LevelChunk)p_295144_, (ServerLevel)p_294963_);
    }

    private List<LevelChunk> collectChunksToSend(ChunkMap p_296053_, ChunkPos p_295659_) {
        int i = Mth.floor((float)this.batchQuota);
        List<LevelChunk> list = !this.memoryConnection && this.pendingChunks.size() > i ? ((List)this.pendingChunks.stream().collect(Comparators.least((int)i, Comparator.comparingInt(arg_0 -> ((ChunkPos)p_295659_).distanceSquared(arg_0))))).stream().mapToLong(Long::longValue).mapToObj(p_296053_::getChunkToSend).filter(Objects::nonNull).toList() : this.pendingChunks.longStream().mapToObj(p_296053_::getChunkToSend).filter(Objects::nonNull).sorted(Comparator.comparingInt(p_294268_ -> p_295659_.distanceSquared(p_294268_.getPos()))).toList();
        for (LevelChunk levelchunk : list) {
            this.pendingChunks.remove(levelchunk.getPos().toLong());
        }
        return list;
    }

    public void onChunkBatchReceivedByClient(float p_294462_) {
        --this.unacknowledgedBatches;
        float f = this.desiredChunksPerTick = Double.isNaN(p_294462_) ? 0.01f : Mth.clamp((float)p_294462_, (float)0.01f, (float)64.0f);
        if (this.unacknowledgedBatches == 0) {
            this.batchQuota = 1.0f;
        }
        this.maxUnacknowledgedBatches = 10;
    }

    public boolean isPending(long p_296128_) {
        return this.pendingChunks.contains(p_296128_);
    }
}

