/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.RecipeBookType;
import net.neoforged.neoforge.common.CommonHooks;

public final class RecipeBookSettings {
    private static final Map<RecipeBookType, Pair<String, String>> TAG_FIELDS = CommonHooks.buildRecipeBookTypeTagFields((Map)ImmutableMap.of((Object)((Object)RecipeBookType.CRAFTING), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.FURNACE), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.BLAST_FURNACE), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.SMOKER), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable")));
    private final Map<RecipeBookType, TypeSettings> states;

    private RecipeBookSettings(Map<RecipeBookType, TypeSettings> p_12730_) {
        this.states = p_12730_;
    }

    public RecipeBookSettings() {
        this(Util.make(Maps.newEnumMap(RecipeBookType.class), p_12740_ -> {
            for (RecipeBookType recipebooktype : RecipeBookType.values()) {
                p_12740_.put(recipebooktype, new TypeSettings(false, false));
            }
        }));
    }

    public boolean isOpen(RecipeBookType p_12735_) {
        return this.states.get((Object)((Object)p_12735_)).open;
    }

    public void setOpen(RecipeBookType p_12737_, boolean p_12738_) {
        this.states.get((Object)((Object)p_12737_)).open = p_12738_;
    }

    public boolean isFiltering(RecipeBookType p_12755_) {
        return this.states.get((Object)((Object)p_12755_)).filtering;
    }

    public void setFiltering(RecipeBookType p_12757_, boolean p_12758_) {
        this.states.get((Object)((Object)p_12757_)).filtering = p_12758_;
    }

    public static RecipeBookSettings read(FriendlyByteBuf p_12753_) {
        EnumMap map = Maps.newEnumMap(RecipeBookType.class);
        for (RecipeBookType recipebooktype : CommonHooks.getFilteredRecipeBookTypeValues()) {
            boolean flag = p_12753_.readBoolean();
            boolean flag1 = p_12753_.readBoolean();
            map.put(recipebooktype, new TypeSettings(flag, flag1));
        }
        return new RecipeBookSettings(map);
    }

    public void write(FriendlyByteBuf p_12762_) {
        for (RecipeBookType recipebooktype : RecipeBookType.values()) {
            TypeSettings recipebooksettings$typesettings = this.states.get((Object)recipebooktype);
            if (recipebooksettings$typesettings == null) {
                p_12762_.writeBoolean(false);
                p_12762_.writeBoolean(false);
                continue;
            }
            p_12762_.writeBoolean(recipebooksettings$typesettings.open);
            p_12762_.writeBoolean(recipebooksettings$typesettings.filtering);
        }
    }

    public static RecipeBookSettings read(CompoundTag p_12742_) {
        EnumMap map = Maps.newEnumMap(RecipeBookType.class);
        TAG_FIELDS.forEach((p_12750_, p_12751_) -> {
            boolean flag = p_12742_.getBoolean((String)p_12751_.getFirst());
            boolean flag1 = p_12742_.getBoolean((String)p_12751_.getSecond());
            map.put(p_12750_, new TypeSettings(flag, flag1));
        });
        return new RecipeBookSettings(map);
    }

    public void write(CompoundTag p_12760_) {
        TAG_FIELDS.forEach((p_12745_, p_12746_) -> {
            TypeSettings recipebooksettings$typesettings = this.states.get(p_12745_);
            p_12760_.putBoolean((String)p_12746_.getFirst(), recipebooksettings$typesettings.open);
            p_12760_.putBoolean((String)p_12746_.getSecond(), recipebooksettings$typesettings.filtering);
        });
    }

    public RecipeBookSettings copy() {
        EnumMap map = Maps.newEnumMap(RecipeBookType.class);
        for (RecipeBookType recipebooktype : RecipeBookType.values()) {
            TypeSettings recipebooksettings$typesettings = this.states.get((Object)recipebooktype);
            map.put(recipebooktype, recipebooksettings$typesettings.copy());
        }
        return new RecipeBookSettings(map);
    }

    public void replaceFrom(RecipeBookSettings p_12733_) {
        this.states.clear();
        for (RecipeBookType recipebooktype : RecipeBookType.values()) {
            TypeSettings recipebooksettings$typesettings = p_12733_.states.get((Object)recipebooktype);
            this.states.put(recipebooktype, recipebooksettings$typesettings.copy());
        }
    }

    public boolean equals(Object p_12764_) {
        return this == p_12764_ || p_12764_ instanceof RecipeBookSettings && this.states.equals(((RecipeBookSettings)p_12764_).states);
    }

    public int hashCode() {
        return this.states.hashCode();
    }

    static final class TypeSettings {
        boolean open;
        boolean filtering;

        public TypeSettings(boolean p_12769_, boolean p_12770_) {
            this.open = p_12769_;
            this.filtering = p_12770_;
        }

        public TypeSettings copy() {
            return new TypeSettings(this.open, this.filtering);
        }

        public boolean equals(Object p_12783_) {
            boolean bl;
            if (this == p_12783_) {
                return true;
            }
            if (!(p_12783_ instanceof TypeSettings)) {
                bl = false;
            } else {
                TypeSettings recipebooksettings$typesettings = (TypeSettings)p_12783_;
                bl = this.open == recipebooksettings$typesettings.open && this.filtering == recipebooksettings$typesettings.filtering;
            }
            return bl;
        }

        public int hashCode() {
            int i = this.open ? 1 : 0;
            return 31 * i + (this.filtering ? 1 : 0);
        }

        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }
    }
}

