/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.neoforged.neoforge.fluids.FluidType;

public class Swim
extends Behavior<Mob> {
    private final float chance;

    public Swim(float p_24383_) {
        super((Map)ImmutableMap.of());
        this.chance = p_24383_;
    }

    public static boolean shouldSwim(Mob p_316787_) {
        return p_316787_.isInWater() && p_316787_.getFluidHeight(FluidTags.WATER) > p_316787_.getFluidJumpThreshold() || p_316787_.isInLava() || p_316787_.isInFluidType((fluidType, height) -> p_316787_.canSwimInFluidType((FluidType)fluidType) && height > p_316787_.getFluidJumpThreshold());
    }

    protected boolean checkExtraStartConditions(ServerLevel p_24388_, Mob p_24389_) {
        return Swim.shouldSwim(p_24389_);
    }

    protected boolean canStillUse(ServerLevel p_24391_, Mob p_24392_, long p_24393_) {
        return this.checkExtraStartConditions(p_24391_, p_24392_);
    }

    protected void tick(ServerLevel p_24399_, Mob p_24400_, long p_24401_) {
        if (p_24400_.getRandom().nextFloat() < this.chance) {
            p_24400_.getJumpControl().jump();
        }
    }
}

