/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.FastColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.neoforged.neoforge.common.util.AttributeUtil;

public record PotionContents(Optional<Holder<Potion>> potion, Optional<Integer> customColor, List<MobEffectInstance> customEffects) {
    private final List<MobEffectInstance> customEffects;
    public static final PotionContents EMPTY = new PotionContents(Optional.empty(), Optional.empty(), List.of());
    private static final Component NO_EFFECT = Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY);
    private static final int BASE_POTION_COLOR = -13083194;
    private static final Codec<PotionContents> FULL_CODEC = RecordCodecBuilder.create(p_348387_ -> p_348387_.group((App)Potion.CODEC.optionalFieldOf("potion").forGetter(PotionContents::potion), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(PotionContents::customColor), (App)MobEffectInstance.CODEC.listOf().optionalFieldOf("custom_effects", List.of()).forGetter(PotionContents::customEffects)).apply((Applicative)p_348387_, PotionContents::new));
    public static final Codec<PotionContents> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Potion.CODEC, PotionContents::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionContents> STREAM_CODEC = StreamCodec.composite((StreamCodec)Potion.STREAM_CODEC.apply(ByteBufCodecs::optional), PotionContents::potion, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs::optional), PotionContents::customColor, (StreamCodec)MobEffectInstance.STREAM_CODEC.apply(ByteBufCodecs.list()), PotionContents::customEffects, PotionContents::new);

    public PotionContents(Holder<Potion> p_331208_) {
        this(Optional.of(p_331208_), Optional.empty(), List.of());
    }

    public static ItemStack createItemStack(Item p_330388_, Holder<Potion> p_331030_) {
        ItemStack itemstack = new ItemStack(p_330388_);
        itemstack.set(DataComponents.POTION_CONTENTS, new PotionContents(p_331030_));
        return itemstack;
    }

    public boolean is(Holder<Potion> p_331328_) {
        return this.potion.isPresent() && this.potion.get().is(p_331328_) && this.customEffects.isEmpty();
    }

    public Iterable<MobEffectInstance> getAllEffects() {
        if (this.potion.isEmpty()) {
            return this.customEffects;
        }
        return this.customEffects.isEmpty() ? this.potion.get().value().getEffects() : Iterables.concat((Iterable)this.potion.get().value().getEffects(), this.customEffects);
    }

    public void forEachEffect(Consumer<MobEffectInstance> p_331190_) {
        if (this.potion.isPresent()) {
            for (MobEffectInstance mobeffectinstance : this.potion.get().value().getEffects()) {
                p_331190_.accept(new MobEffectInstance(mobeffectinstance));
            }
        }
        for (MobEffectInstance mobeffectinstance1 : this.customEffects) {
            p_331190_.accept(new MobEffectInstance(mobeffectinstance1));
        }
    }

    public PotionContents withPotion(Holder<Potion> p_330288_) {
        return new PotionContents(Optional.of(p_330288_), this.customColor, this.customEffects);
    }

    public PotionContents withEffectAdded(MobEffectInstance p_332083_) {
        return new PotionContents(this.potion, this.customColor, Util.copyAndAdd(this.customEffects, p_332083_));
    }

    public int getColor() {
        return this.customColor.isPresent() ? this.customColor.get() : PotionContents.getColor(this.getAllEffects());
    }

    public static int getColor(Holder<Potion> p_330619_) {
        return PotionContents.getColor(p_330619_.value().getEffects());
    }

    public static int getColor(Iterable<MobEffectInstance> p_331934_) {
        return PotionContents.getColorOptional(p_331934_).orElse(-13083194);
    }

    public static OptionalInt getColorOptional(Iterable<MobEffectInstance> p_332699_) {
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        for (MobEffectInstance mobeffectinstance : p_332699_) {
            if (!mobeffectinstance.isVisible()) continue;
            int i1 = mobeffectinstance.getEffect().value().getColor();
            int j1 = mobeffectinstance.getAmplifier() + 1;
            i += j1 * FastColor.ARGB32.red((int)i1);
            j += j1 * FastColor.ARGB32.green((int)i1);
            k += j1 * FastColor.ARGB32.blue((int)i1);
            l += j1;
        }
        return l == 0 ? OptionalInt.empty() : OptionalInt.of(FastColor.ARGB32.color((int)(i / l), (int)(j / l), (int)(k / l)));
    }

    public boolean hasEffects() {
        return !this.customEffects.isEmpty() ? true : this.potion.isPresent() && !this.potion.get().value().getEffects().isEmpty();
    }

    public List<MobEffectInstance> customEffects() {
        return Lists.transform(this.customEffects, MobEffectInstance::new);
    }

    public void addPotionTooltip(Consumer<Component> p_331688_, float p_330466_, float p_332190_) {
        PotionContents.addPotionTooltip(this.getAllEffects(), p_331688_, p_330466_, p_332190_);
    }

    public static void addPotionTooltip(Iterable<MobEffectInstance> p_331825_, Consumer<Component> p_331296_, float p_332038_, float p_332014_) {
        ArrayList list = Lists.newArrayList();
        boolean flag = true;
        for (MobEffectInstance mobeffectinstance : p_331825_) {
            flag = false;
            MutableComponent mutablecomponent = Component.translatable((String)mobeffectinstance.getDescriptionId());
            Holder<MobEffect> holder = mobeffectinstance.getEffect();
            holder.value().createModifiers(mobeffectinstance.getAmplifier(), (p_331556_, p_330860_) -> list.add(new Pair(p_331556_, p_330860_)));
            if (mobeffectinstance.getAmplifier() > 0) {
                mutablecomponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.translatable((String)("potion.potency." + mobeffectinstance.getAmplifier()))});
            }
            if (!mobeffectinstance.endsWithin(20)) {
                mutablecomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.formatDuration((MobEffectInstance)mobeffectinstance, (float)p_332038_, (float)p_332014_)});
            }
            p_331296_.accept((Component)mutablecomponent.withStyle(holder.value().getCategory().getTooltipFormatting()));
        }
        if (flag) {
            p_331296_.accept(NO_EFFECT);
        }
        if (!list.isEmpty()) {
            p_331296_.accept(CommonComponents.EMPTY);
            p_331296_.accept((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            AttributeUtil.addPotionTooltip((List)list, p_331296_);
            return;
        }
    }
}

