/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.option;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceNamedTextFieldWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextFieldWidget;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public class SpruceStringOption
extends SpruceOption {
    private final Supplier<String> getter;
    private final Consumer<String> setter;
    private final @Nullable Predicate<String> predicate;

    public SpruceStringOption(String key, Supplier<String> getter, Consumer<String> setter, @Nullable Predicate<String> predicate, TooltipData tooltip) {
        super(key);
        this.getter = getter;
        this.setter = setter;
        this.predicate = predicate;
        this.setTooltip(tooltip);
    }

    @Override
    public SpruceWidget createWidget(Position position, int width) {
        SpruceTextFieldWidget textField = new SpruceTextFieldWidget(position, width, 20, this.getPrefix());
        textField.setText(this.get());
        if (this.predicate != null) {
            textField.setTextPredicate(this.predicate);
        }
        textField.setChangedListener(this::set);
        this.getTooltip().ifPresent(textField::setTooltip);
        return new SpruceNamedTextFieldWidget(textField);
    }

    public void set(String value) {
        this.setter.accept(value);
    }

    public String get() {
        return this.getter.get();
    }

    public static class Builder
    extends SpruceOption.Builder<Builder, SpruceStringOption> {
        private final Supplier<String> getter;
        private final Consumer<String> setter;
        private Predicate<String> predicate;

        public Builder(String key, Supplier<String> getter, Consumer<String> setter) {
            super(key);
            this.getter = getter;
            this.setter = setter;
        }

        public Builder predicate(Predicate<String> predicate) {
            this.predicate = predicate;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpruceStringOption build() {
            return new SpruceStringOption(this.key, this.getter, this.setter, this.predicate, this.tooltip);
        }
    }
}

