/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.tooltip;

import com.google.common.collect.Queues;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.SpruceUI;
import dev.lambdaurora.spruceui.event.ScreenEvents;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.tooltip.Tooltipable;
import dev.lambdaurora.spruceui.tooltip.components.SpruceClientTooltipComponent;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import java.util.List;
import java.util.Queue;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_7999;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_8030;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public final class Tooltip
implements SprucePositioned {
    private static final Queue<Tooltip> TOOLTIPS = Queues.newConcurrentLinkedQueue();
    private static boolean delayed = false;
    private final int x;
    private final int y;
    private final List<class_5684> components;
    private final class_8000 positioner;
    private final @Nullable class_2960 style;

    public Tooltip(int x, int y, List<class_5684> components, class_8000 positioner, @Nullable class_2960 style) {
        this.x = x;
        this.y = y;
        this.components = components;
        this.positioner = positioner;
        this.style = style;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void render(class_332 graphics) {
        graphics.method_51435(class_310.method_1551().field_1772, this.components, this.x, this.y, this.positioner, this.style);
    }

    public void queue() {
        TOOLTIPS.add(this);
    }

    public static <T extends Tooltipable & SpruceWidget> void queueFor(T widget, int mouseX, int mouseY, int tooltipTicks, IntConsumer tooltipTicksSetter, long lastTick, LongConsumer lastTickSetter) {
        if (((SpruceWidget)widget).isVisible()) {
            TooltipData tooltip = widget.getTooltip();
            if (tooltip.isEmpty()) {
                return;
            }
            long currentRender = System.currentTimeMillis();
            if (lastTick != 0L) {
                if (currentRender - lastTick >= 20L) {
                    tooltipTicksSetter.accept(tooltipTicks + 1);
                    lastTickSetter.accept(currentRender);
                }
            } else {
                lastTickSetter.accept(currentRender);
            }
            if (!((SpruceWidget)widget).method_25370() && !((SpruceWidget)widget).isMouseHovered()) {
                tooltipTicksSetter.accept(0);
            }
            if (tooltipTicks < 45) {
                return;
            }
            int recommendedMaxWidth = Math.max(((SpruceWidget)widget).getWidth() * 2 / 3, 200);
            List<class_5684> tooltipComponents = tooltip.tooltip().stream().flatMap(entry -> {
                if (entry instanceof TooltipData.TextEntry) {
                    class_2561 text;
                    TooltipData.TextEntry $b$0 = (TooltipData.TextEntry)entry;
                    try {
                        class_2561 patt1$temp;
                        text = patt1$temp = $b$0.text();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    List wrappedTooltipText = class_310.method_1551().field_1772.method_1728((class_5348)text, recommendedMaxWidth);
                    return wrappedTooltipText.stream().map(class_5684::method_32662);
                }
                class_5684 component = entry.toComponent();
                if (component instanceof SpruceClientTooltipComponent) {
                    SpruceClientTooltipComponent spruceTooltipComponent = (SpruceClientTooltipComponent)component;
                    return Stream.of(spruceTooltipComponent.withMaxWidth(recommendedMaxWidth));
                }
                return Stream.of(entry.toComponent());
            }).toList();
            if (((SpruceWidget)widget).isMouseHovered()) {
                new Tooltip(mouseX, mouseY, tooltipComponents, class_8001.field_41687, tooltip.style()).queue();
            } else if (((SpruceWidget)widget).method_25370()) {
                new Tooltip(((SpruceWidget)widget).getX() - 12, ((SpruceWidget)widget).getY() + ((SpruceWidget)widget).getHeight() + 16, tooltipComponents, (class_8000)new class_7999(new class_8030(((SprucePositioned)widget).getScreenPosition(), ((SpruceWidget)widget).getWidth(), ((SpruceWidget)widget).getHeight())), tooltip.style()).queue();
            }
        }
    }

    @ApiStatus.Internal
    static void setDelayedRender(boolean delayed) {
        Tooltip.delayed = delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderAll(class_332 graphics) {
        if (delayed) {
            return;
        }
        Queue<Tooltip> queue = TOOLTIPS;
        synchronized (queue) {
            Tooltip tooltip;
            while ((tooltip = TOOLTIPS.poll()) != null) {
                tooltip.render(graphics);
            }
        }
    }

    static {
        class_2960 tooltipPhase = SpruceUI.id("tooltip");
        ScreenEvents.AFTER_RENDER.addPhaseOrdering((Comparable)((class_2960)ScreenEvents.AFTER_RENDER.defaultPhaseId()), (Comparable)tooltipPhase);
        ScreenEvents.AFTER_RENDER.register((Comparable)tooltipPhase, (screen, graphics, mouseX, mouseY, tickDelta) -> Tooltip.renderAll(graphics.vanilla()));
    }
}

