/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.tooltip.components;

import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.tooltip.components.SpruceClientTooltipComponent;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import net.minecraft.class_1041;
import net.minecraft.class_2477;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public record ClientThumbnailTooltipComponent(SpruceClientTooltipComponent thumbnailComponent, class_5348 text, boolean allowExtraTextBelow, OptionalInt maxWidth) implements SpruceClientTooltipComponent
{
    public ClientThumbnailTooltipComponent(SpruceClientTooltipComponent thumbnailComponent, class_5348 text, boolean allowExtraTextBelow) {
        this(thumbnailComponent, text, allowExtraTextBelow, OptionalInt.empty());
    }

    public ClientThumbnailTooltipComponent(SpruceClientTooltipComponent thumbnailComponent, class_5348 text) {
        this(thumbnailComponent, text, false);
    }

    public int method_32664(class_327 font) {
        return this.getLayout(font).width();
    }

    public int method_32661(class_327 font) {
        return this.getLayout(font).height();
    }

    @Override
    public void renderText(SpruceGuiGraphics graphics, class_327 font, int x, int y) {
        Layout layout = this.getLayout(font);
        this.thumbnailComponent.renderText(graphics, font, x, y + layout.thumbnailYOffset());
        int sideY = y;
        for (class_5481 line : layout.sideLines) {
            graphics.drawText(font, line, x + layout.thumbnailWidth + 2, sideY, -1, true);
            Objects.requireNonNull(font);
            sideY += 9 + 1;
        }
        int belowY = y + layout.belowLinesY;
        for (class_5481 line : layout.belowLines) {
            graphics.drawText(font, line, x, belowY, -1, true);
            Objects.requireNonNull(font);
            belowY += 9 + 1;
        }
    }

    @Override
    public void renderImage(class_327 font, int x, int y, int width, int height, SpruceGuiGraphics graphics) {
        Layout layout = this.getLayout(font);
        this.thumbnailComponent.renderImage(font, x, y + layout.thumbnailYOffset(), layout.thumbnailWidth, layout.thumbnailHeight, graphics);
    }

    @Override
    public SpruceClientTooltipComponent withMaxWidth(int maxWidth) {
        return new ClientThumbnailTooltipComponent(this.thumbnailComponent, this.text, this.allowExtraTextBelow, OptionalInt.of(maxWidth));
    }

    private Layout getLayout(class_327 font) {
        class_1041 window = class_310.method_1551().method_22683();
        int thumbnailWidth = this.thumbnailComponent.method_32664(font);
        int thumbnailHeight = this.thumbnailComponent.method_32661(font);
        int absoluteMaxWidth = (int)((float)window.method_4486() * 0.6666667f);
        int maxWidth = this.maxWidth.orElse(absoluteMaxWidth);
        int remainingWidth = maxWidth - (thumbnailWidth + 4);
        if (remainingWidth < 20 && absoluteMaxWidth - (thumbnailWidth + 4) >= absoluteMaxWidth / 3) {
            remainingWidth = absoluteMaxWidth - (thumbnailWidth + 4);
        } else if (remainingWidth < absoluteMaxWidth / 3) {
            List lines = font.method_1728(this.text, maxWidth);
            Objects.requireNonNull(font);
            return new Layout(thumbnailWidth, thumbnailHeight, 9, maxWidth, List.of(), thumbnailHeight + 2, lines);
        }
        List sideLines = font.method_72101(this.text, remainingWidth);
        List belowLines = List.of();
        int sideTextHeight = 0;
        for (int i = 0; i < sideLines.size(); ++i) {
            Objects.requireNonNull(font);
            if (thumbnailHeight >= (sideTextHeight += 9 + 1) || !this.allowExtraTextBelow) continue;
            if (i + 1 < sideLines.size()) {
                belowLines = sideLines.subList(i + 1, sideLines.size());
            }
            sideLines = sideLines.subList(0, i + 1);
        }
        Objects.requireNonNull(font);
        return new Layout(thumbnailWidth, thumbnailHeight, 9, maxWidth, class_2477.method_10517().method_30933(sideLines), sideTextHeight, class_2477.method_10517().method_30933(belowLines));
    }

    private record Layout(int thumbnailWidth, int thumbnailHeight, int lineHeight, int width, List<class_5481> sideLines, int belowLinesY, List<class_5481> belowLines) {
        public int height() {
            int height = 1 + this.belowLines.size() * (this.lineHeight + 1);
            height = this.sideLines.isEmpty() ? (height += this.thumbnailHeight) : (height += this.sideLines.size() * (this.lineHeight + 1));
            return height;
        }

        public int thumbnailYOffset() {
            if (this.sideLines.isEmpty()) {
                return 0;
            }
            return this.belowLinesY / 2 - this.thumbnailHeight / 2;
        }
    }
}

