/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.tooltip.Tooltip;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.tooltip.Tooltipable;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.wrapper.VanillaButtonWrapper;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11909;
import net.minecraft.class_12225;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8666;
import org.jspecify.annotations.Nullable;

public abstract class AbstractSpruceButtonWidget
extends AbstractSpruceWidget
implements Tooltipable {
    private class_2561 message;
    private TooltipData tooltip = TooltipData.EMPTY;
    private int tooltipTicks;
    private long lastTick;
    protected float alpha = 1.0f;
    protected static final class_8666 BUTTON_TEXTURES = new class_8666(class_2960.method_60656((String)"widget/button"), class_2960.method_60656((String)"widget/button_disabled"), class_2960.method_60656((String)"widget/button_highlighted"));

    public AbstractSpruceButtonWidget(Position position, int width, int height, class_2561 message) {
        super(position);
        this.width = width;
        this.height = height;
        this.message = message;
    }

    public class_2561 getMessage() {
        return this.message;
    }

    public void setMessage(class_2561 message) {
        this.message = message;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float value) {
        this.alpha = value;
    }

    @Override
    public TooltipData getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setTooltip(TooltipData tooltip) {
        Objects.requireNonNull(tooltip, "Tooltip cannot be null, the absence of a tooltip is represented by TooltipData.EMPTY.");
        this.tooltip = tooltip;
    }

    public VanillaButtonWrapper asVanilla() {
        return new VanillaButtonWrapper(this);
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    @Override
    protected boolean onMouseClick(class_11909 event, boolean doubleClick) {
        if (this.isValidClickButton(event.method_74245())) {
            this.onClick(event.comp_4798(), event.comp_4799());
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(class_11909 event) {
        if (this.isValidClickButton(event.method_74245())) {
            this.onRelease(event.comp_4798(), event.comp_4799());
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMouseDrag(class_11909 event, double deltaX, double deltaY) {
        if (this.isValidClickButton(event.method_74245())) {
            this.onDrag(event.comp_4798(), event.comp_4799(), deltaX, deltaY);
            return true;
        }
        return false;
    }

    protected void onClick(double mouseX, double mouseY) {
    }

    protected void onRelease(double mouseX, double mouseY) {
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
    }

    protected class_2960 getTexture() {
        return BUTTON_TEXTURES.method_52729(this.method_37303(), this.isFocusedOrHovered());
    }

    @Override
    protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderButton(graphics, mouseX, mouseY, delta);
        if (this.isMouseHovered()) {
            graphics.requestCursor(this.method_37303() ? class_11876.field_62455 : class_11876.field_62459);
        }
        if (!this.dragging) {
            Tooltip.queueFor(this, mouseX, mouseY, this.tooltipTicks, i -> {
                this.tooltipTicks = i;
            }, this.lastTick, i -> {
                this.lastTick = i;
            });
        }
    }

    protected void renderButton(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int color = this.active ? 0xFFFFFF : 0xA0A0A0;
        this.renderText(graphics, color | class_3532.method_15386((float)(this.alpha * 255.0f)) << 24);
    }

    protected void renderText(SpruceGuiGraphics graphics, int color) {
        int margin = 2;
        int startX = this.getX() + margin;
        int endX = this.getX() + this.getWidth() - margin;
        class_12225 collector = graphics.textRenderer(this.alpha, class_332.class_12228.field_63850);
        collector.method_75771(this.getMessage(), this.getX() + this.getWidth() / 2, startX, endX, this.getY(), this.getY() + this.getHeight());
    }

    @Override
    protected void renderBackground(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.drawSprite(class_10799.field_56883, this.getTexture(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    protected @Nullable class_2561 getNarrationMessage() {
        return class_2561.method_43469((String)"gui.narrate.button", (Object[])new Object[]{this.getMessage()});
    }

    protected class_2561 getNarrationFocusedUsageMessage() {
        return class_2561.method_43471((String)"narration.button.usage.focused");
    }

    protected class_2561 getNarrationHoveredUsageMessage() {
        return class_2561.method_43471((String)"narration.button.usage.hovered");
    }

    @Override
    public void method_37020(class_6382 builder) {
        super.method_37020(builder);
        if (this.method_37303()) {
            if (this.method_25370()) {
                builder.method_37034(class_6381.field_33791, this.getNarrationFocusedUsageMessage());
            } else {
                builder.method_37034(class_6381.field_33791, this.getNarrationHoveredUsageMessage());
            }
        }
        this.tooltip.method_37020(builder);
    }
}

