/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget.text;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.border.Border;
import dev.lambdaurora.spruceui.navigation.NavigationEvent;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.util.MultilineText;
import dev.lambdaurora.spruceui.widget.text.AbstractSpruceTextInputWidget;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import org.jspecify.annotations.Nullable;

public class SpruceTextAreaWidget
extends AbstractSpruceTextInputWidget<Cursor> {
    private final class_327 font;
    private final MultilineText lines;
    private final Cursor cursor = new Cursor(true);
    private final Selection selection = new Selection();
    private int firstLine = 0;
    private int displayedLines;

    public SpruceTextAreaWidget(Position position, int width, int height, class_2561 title) {
        this(position, width, height, title, null);
    }

    public SpruceTextAreaWidget(Position position, int width, int height, class_2561 title, @Nullable class_2561 placeholder) {
        super(position, width, height, title, placeholder);
        this.font = this.client.field_1772;
        int n = this.getInnerHeight();
        Objects.requireNonNull(this.font);
        this.displayedLines = n / 9;
        this.lines = new MultilineText(this.getInnerWidth());
        this.cursor.toStart();
        this.sanitize();
    }

    public List<String> getLines() {
        return this.lines.getLines();
    }

    public void setLines(List<String> lines) {
        this.lines.setLines(lines);
        this.selection.active = false;
        this.setCursorToEnd();
    }

    @Override
    public String getText() {
        return this.lines.getText();
    }

    @Override
    public void setText(@Nullable String text) {
        this.lines.clear();
        if (text != null) {
            this.lines.setText(text);
        }
    }

    public void clear() {
        this.lines.clear();
        this.sanitize();
    }

    public void setEditable(boolean editable) {
        this.setActive(editable);
    }

    public void setDisplayedLines(int lines) {
        if (lines <= 0) {
            lines = 1;
        }
        this.displayedLines = lines;
        this.cursor.adjustFirstLine();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.lines.setWidth(this.getInnerWidth());
        this.sanitize();
    }

    @Override
    protected Cursor cursor() {
        return this.cursor;
    }

    @Override
    protected AbstractSpruceTextInputWidget.Selection selection() {
        return this.selection;
    }

    @Override
    public void setCursorToStart() {
        this.cursor.toStart();
    }

    @Override
    public void setCursorToEnd() {
        this.cursor.toEnd();
    }

    @Override
    protected void insertCharacter(String character) {
        String line;
        if (this.lines.isEmpty()) {
            this.lines.add(String.valueOf(character));
            this.setCursorToStart();
            return;
        }
        this.selection.erase();
        if (character.equals("\n") && this.cursor.row == this.lines.size() - 1 && (line = this.lines.get(this.cursor.row)) != null && this.cursor.column >= line.length() - 1) {
            int currentRow = this.cursor.row;
            if (!line.endsWith("\n")) {
                this.lines.replaceRow(currentRow, s -> s + "\n");
            }
            this.lines.add(currentRow + 1, "");
            this.cursor.moveDown();
            return;
        }
        String text = this.getText();
        int cursorPosition = this.cursor.getPosition();
        int oldSize = this.lines.size();
        String newText = cursorPosition >= text.length() ? text + character : text.substring(0, cursorPosition) + character + text.substring(cursorPosition);
        this.lines.clear();
        this.lines.add(newText);
        if (character.equals("\n")) {
            this.cursor.moveRight();
        } else {
            this.cursor.moveRight();
            if (oldSize + 1 == this.lines.size()) {
                this.cursor.moveRight();
            }
        }
    }

    private void eraseCharacter() {
        if (this.selection.erase()) {
            this.sanitize();
            return;
        }
        String line = this.lines.get(this.cursor.row);
        if (line == null) {
            this.cursor.row = this.lines.getRows().size() - 1;
            this.cursor.toRowEnd();
            return;
        }
        if ((line.isEmpty() || line.equals("\n")) && this.lines.size() != 1) {
            this.lines.remove(this.cursor.row);
            this.cursor.moveUp();
            this.cursor.toRowEnd();
            return;
        }
        if (this.cursor.column == 0 && this.cursor.row == 0) {
            return;
        }
        String text = this.getText();
        int cursorPosition = this.cursor.getPosition();
        this.cursor.moveLeft();
        this.lines.clear();
        this.lines.add(text.substring(0, cursorPosition - 1) + text.substring(cursorPosition));
        this.sanitize();
    }

    private void removeCharacterForward() {
        if (this.selection.erase()) {
            this.sanitize();
            return;
        }
        String line = this.lines.get(this.cursor.row);
        if (line == null || line.isEmpty()) {
            int row = this.cursor.row;
            if (row >= this.lines.size() - 1) {
                return;
            }
            this.lines.remove(row);
            this.sanitize();
            return;
        }
        if (this.cursor.column >= line.length() && this.cursor.row == this.lines.size() - 1) {
            return;
        }
        String text = this.getText();
        int cursorPosition = this.cursor.getPosition();
        String newText = text.substring(0, cursorPosition) + text.substring(cursorPosition + 1);
        this.lines.clear();
        this.lines.add(newText);
        this.sanitize();
    }

    public void write(String text) {
        if (text.isEmpty()) {
            return;
        }
        if (this.lines.isEmpty()) {
            this.lines.add(text);
            this.cursor.toEnd();
            return;
        }
        this.selection.erase();
        int oldSize = this.lines.size();
        String whole = this.getText();
        int position = this.cursor.getPosition();
        String newText = position >= whole.length() ? whole + text : whole.substring(0, position) + text + whole.substring(position);
        this.lines.clear();
        this.lines.setLines(Arrays.asList(newText.split("\n")));
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                this.cursor.moveRight();
            }
            this.cursor.moveRight();
        }
        if (oldSize < this.lines.size()) {
            this.cursor.moveRight();
        }
    }

    protected boolean doesLineOccupyFullSpace(String cursorLine) {
        return this.font.method_1727(cursorLine) >= this.getInnerWidth();
    }

    @Override
    protected void sanitize() {
        if (this.lines.isEmpty()) {
            this.lines.add("");
        }
        this.cursor.sanitize();
    }

    @Override
    public boolean onNavigation(NavigationEvent event) {
        if (this.requiresCursor()) {
            return false;
        }
        if (!event.tab()) {
            boolean result;
            this.method_25365(true);
            switch (event.direction()) {
                default: {
                    throw new MatchException(null, null);
                }
                case field_41829: {
                    boolean bl = this.onSelectionUpdate(this.cursor::moveRight, event.hasShiftDown());
                    break;
                }
                case field_41828: {
                    boolean bl = this.onSelectionUpdate(this.cursor::moveLeft, event.hasShiftDown());
                    break;
                }
                case field_41826: {
                    boolean bl = this.onSelectionUpdate(this.cursor::moveUp, event.hasShiftDown());
                    break;
                }
                case field_41827: {
                    boolean bl = result = this.onSelectionUpdate(this.cursor::moveDown, event.hasShiftDown());
                }
            }
            if (result) {
                return true;
            }
        }
        return super.onNavigation(event);
    }

    @Override
    protected boolean onKeyPress(class_11908 event) {
        if (!this.isEditorActive()) {
            return false;
        }
        if (event.method_74241()) {
            this.selection.selectAll();
            return true;
        }
        if (event.method_74243()) {
            this.write(this.client.field_1774.method_1460());
            return true;
        }
        if (event.method_74242() || event.method_74244()) {
            String selected = this.selection.getSelectedText();
            if (!selected.isEmpty()) {
                this.client.field_1774.method_1455(selected);
            }
            if (event.method_74244() && this.isEditable()) {
                this.selection.erase();
                this.sanitize();
            }
            return true;
        }
        return switch (event.comp_4795()) {
            case 262 -> this.onSelectionUpdate(this.cursor::moveRight, event.method_74239());
            case 263 -> this.onSelectionUpdate(this.cursor::moveLeft, event.method_74239());
            case 265 -> this.onSelectionUpdate(this.cursor::moveUp, event.method_74239());
            case 264 -> this.onSelectionUpdate(this.cursor::moveDown, event.method_74239());
            case 269 -> this.onSelectionUpdate(event.method_74240() ? this.cursor::toEnd : this.cursor::toRowEnd, event.method_74239());
            case 268 -> this.onSelectionUpdate(event.method_74240() ? this.cursor::toStart : this.cursor::toLineStart, event.method_74239());
            case 266 -> this.onSelectionUpdate(() -> this.cursor.moveVertical(-this.cursor.row), event.method_74239());
            case 267 -> this.onSelectionUpdate(() -> this.cursor.moveVertical(this.lines.size() - this.cursor.row), event.method_74239());
            case 257, 335 -> {
                if (this.isEditable()) {
                    this.insertCharacter("\n");
                }
                yield true;
            }
            case 259 -> {
                if (this.isEditable()) {
                    this.eraseCharacter();
                }
                yield true;
            }
            case 261 -> {
                if (this.isEditable()) {
                    this.removeCharacterForward();
                }
                yield true;
            }
            case 68 -> {
                if (event.method_74240() && this.isEditable() && !this.lines.isEmpty()) {
                    this.lines.remove(this.cursor.row);
                    this.sanitize();
                }
                yield true;
            }
            default -> false;
        };
    }

    private boolean onSelectionUpdate(Runnable action, boolean hasShiftDown) {
        this.selection.tryStartSelection(hasShiftDown);
        action.run();
        this.selection.moveToCursor(hasShiftDown);
        return true;
    }

    @Override
    protected boolean onMouseClick(class_11909 event, boolean doubleClick) {
        if (event.method_74245() == 0) {
            int x = class_3532.method_15357((double)event.comp_4798()) - this.getX() - 4;
            int y = class_3532.method_15357((double)event.comp_4799()) - this.getY() - 4;
            this.method_25365(true);
            int row = this.firstLine + y / 9;
            if (row >= this.lines.size()) {
                this.cursor.toEnd();
                return true;
            }
            if (row < 0) {
                this.cursor.toStart();
                return true;
            }
            this.onSelectionUpdate(() -> {
                this.cursor.row = row;
                this.cursor.lastColumn = this.cursor.column = this.font.method_27523(this.lines.get(row), x).length();
            }, event.method_74239());
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.isEditorActive()) {
            return false;
        }
        if (scrollY > 0.0) {
            this.cursor.moveUp();
        } else {
            this.cursor.moveDown();
        }
        return true;
    }

    @Override
    protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.renderWidget(graphics, mouseX, mouseY, delta);
        this.drawText(graphics);
        this.drawCursor(graphics);
    }

    protected void drawText(SpruceGuiGraphics graphics) {
        int length = Math.min(this.lines.size(), this.displayedLines);
        int textColor = this.getTextColor();
        int textX = this.getX() + 4;
        int lineY = this.getY() + 4;
        class_2561 placeholder = this.getPlaceholder();
        if (this.getText().isEmpty() && placeholder != null) {
            graphics.drawShadowedText(this.client.field_1772, placeholder, textX, lineY, textColor);
            return;
        }
        for (int row = this.firstLine; row < this.firstLine + length; ++row) {
            String line = this.lines.get(row);
            if (line == null) continue;
            if (line.endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            graphics.drawShadowedText(this.font, (class_2561)class_2561.method_43470((String)line), textX, lineY, textColor);
            this.drawSelection(graphics, line, lineY, row);
            Objects.requireNonNull(this.font);
            lineY += 9;
        }
    }

    protected void drawSelection(SpruceGuiGraphics graphics, String line, int lineY, int row) {
        if (!this.method_25370()) {
            return;
        }
        if (!this.selection.isRowSelected(row)) {
            return;
        }
        int startIndex = ((Cursor)this.selection.getStart()).row != row ? 0 : ((Cursor)this.selection.getStart()).column;
        int endIndex = ((Cursor)this.selection.getEnd()).row != row ? line.length() : ((Cursor)this.selection.getEnd()).column;
        if (endIndex >= line.length()) {
            endIndex = line.length();
        }
        if (startIndex >= line.length() || startIndex == endIndex) {
            return;
        }
        int x = this.getX() + 4 + this.font.method_1727(line.substring(0, startIndex));
        String selected = line.substring(startIndex, endIndex);
        int x2 = x + this.font.method_1727(selected);
        Objects.requireNonNull(this.font);
        int y2 = lineY + 9;
        graphics.fill(class_10799.field_56881, x, lineY, x2, y2, -16776961);
    }

    protected void drawCursor(SpruceGuiGraphics graphics) {
        if (!this.method_25370()) {
            return;
        }
        if (this.lines.isEmpty()) {
            graphics.drawShadowedText(this.font, (class_2561)class_2561.method_43470((String)"_"), this.getX(), this.getY() + 4, -2039584);
            return;
        }
        this.cursor.sanitize();
        int actualRow = this.cursor.row - this.firstLine;
        String cursorLine = this.lines.get(this.cursor.row);
        int cursorX = this.getX() + 4 + this.font.method_1727(cursorLine.substring(0, this.cursor.column));
        int n = this.getY() + 4;
        Objects.requireNonNull(this.font);
        int cursorY = n + actualRow * 9;
        if (this.cursor.row < this.lines.size() - 1 || this.cursor.column < cursorLine.length() || this.doesLineOccupyFullSpace(cursorLine)) {
            graphics.fill(cursorX - 1, cursorY - 1, cursorX, cursorY + 9, -2039584);
        } else {
            graphics.drawShadowedText(this.font, "_", cursorX, cursorY, -2039584);
        }
    }

    public class Cursor
    implements AbstractSpruceTextInputWidget.Cursor<Cursor> {
        boolean main;
        int row = 0;
        int column = 0;
        private int lastColumn = 0;

        public Cursor(boolean main) {
            this.main = main;
        }

        public void toLineStart() {
            this.column = 0;
            this.lastColumn = 0;
        }

        public void resetRow() {
            this.row = 0;
        }

        public void moveRight() {
            this.moveHorizontal(1);
        }

        public void moveLeft() {
            this.moveHorizontal(-1);
        }

        public void moveUp() {
            this.moveVertical(-1);
        }

        public void moveDown() {
            this.moveVertical(1);
        }

        public void moveHorizontal(int amount) {
            String line;
            this.column += amount;
            if (this.row >= SpruceTextAreaWidget.this.lines.size()) {
                this.row = SpruceTextAreaWidget.this.lines.size() - 1;
                this.column = SpruceTextAreaWidget.this.lines.get(this.row).length();
            }
            if (this.column < 0) {
                if (this.row == 0) {
                    this.toLineStart();
                } else {
                    --this.row;
                    this.column = SpruceTextAreaWidget.this.lines.get(this.row).length();
                }
            }
            if ((line = SpruceTextAreaWidget.this.lines.get(this.row)).endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            if (this.column > line.length()) {
                if (amount > 0 && this.row != SpruceTextAreaWidget.this.lines.size() - 1) {
                    this.column = 0;
                    ++this.row;
                } else {
                    this.column = line.length();
                }
            }
            this.lastColumn = this.column;
            this.adjustFirstLine();
        }

        public void moveVertical(int amount) {
            this.row += amount;
            this.column = this.lastColumn;
            this.sanitize();
            this.adjustFirstLine();
        }

        @Override
        public void toStart() {
            this.resetRow();
            this.toLineStart();
            this.adjustFirstLine();
        }

        @Override
        public void toEnd() {
            this.row = Math.max(0, SpruceTextAreaWidget.this.lines.size() - 1);
            String line = SpruceTextAreaWidget.this.lines.get(this.row);
            if (line == null) {
                this.column = 0;
                this.lastColumn = 0;
            } else {
                this.lastColumn = line.endsWith("\n") ? (this.column = line.length() - 1) : (this.column = line.length());
            }
            this.adjustFirstLine();
        }

        public void toRowEnd() {
            String line = SpruceTextAreaWidget.this.lines.get(this.row);
            if (line == null) {
                this.column = 0;
                this.lastColumn = 0;
            } else {
                this.lastColumn = line.endsWith("\n") ? (this.column = line.length() - 1) : (this.column = line.length());
            }
        }

        @Override
        public void copy(Cursor cursor) {
            this.row = cursor.row;
            this.lastColumn = this.column = cursor.column;
        }

        public void sanitize() {
            String line;
            if (SpruceTextAreaWidget.this.lines.size() <= this.row) {
                this.row = SpruceTextAreaWidget.this.lines.size() - 1;
            }
            if (this.row < 0) {
                this.resetRow();
            }
            if ((line = SpruceTextAreaWidget.this.lines.get(this.row)).endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            if (this.column > line.length()) {
                this.column = line.length();
            }
            this.adjustFirstLine();
        }

        public boolean isSame(Cursor other) {
            return this.row == other.row && this.column == other.column;
        }

        public int getPosition() {
            int i;
            int position = 0;
            for (i = 0; i < this.row; ++i) {
                position += SpruceTextAreaWidget.this.lines.get(i).length();
            }
            for (i = 0; i < this.column; ++i) {
                ++position;
            }
            return position;
        }

        private void adjustFirstLine() {
            int endLine;
            if (!this.main) {
                return;
            }
            if (SpruceTextAreaWidget.this.firstLine > this.row) {
                SpruceTextAreaWidget.this.firstLine = this.row;
            }
            if (SpruceTextAreaWidget.this.firstLine == SpruceTextAreaWidget.this.lines.size()) {
                --SpruceTextAreaWidget.this.firstLine;
            }
            if ((endLine = SpruceTextAreaWidget.this.firstLine + SpruceTextAreaWidget.this.displayedLines - 1) >= SpruceTextAreaWidget.this.lines.size()) {
                SpruceTextAreaWidget.this.firstLine = SpruceTextAreaWidget.this.lines.size() - SpruceTextAreaWidget.this.displayedLines - 1;
            }
            if (this.row >= SpruceTextAreaWidget.this.firstLine + SpruceTextAreaWidget.this.displayedLines) {
                SpruceTextAreaWidget.this.firstLine = this.row - SpruceTextAreaWidget.this.displayedLines + 1;
            }
            if (SpruceTextAreaWidget.this.firstLine < 0) {
                SpruceTextAreaWidget.this.firstLine = 0;
            }
        }

        public String toString() {
            return "SpruceTextAreaWidget$Cursor{main=" + this.main + ", row=" + this.row + ", column=" + this.column + ", lastColumn=" + this.lastColumn + "}";
        }
    }

    public class Selection
    extends AbstractSpruceTextInputWidget.Selection {
        protected Selection() {
            super((AbstractSpruceTextInputWidget)SpruceTextAreaWidget.this, (AbstractSpruceTextInputWidget.Cursor)new Cursor(false), (AbstractSpruceTextInputWidget.Cursor)new Cursor(false));
        }

        public boolean isRowSelected(int row) {
            return this.active && ((Cursor)this.getStart()).row <= row && row <= ((Cursor)this.getEnd()).row;
        }

        public boolean erase() {
            Cursor end;
            if (!this.active) {
                return false;
            }
            Cursor start = (Cursor)this.getStart();
            if (start.isSame(end = (Cursor)this.getEnd())) {
                this.cancel();
                return false;
            }
            if (start.row == 0 && start.column == 0 && end.row == SpruceTextAreaWidget.this.lines.size() - 1 && end.column >= SpruceTextAreaWidget.this.lines.get(SpruceTextAreaWidget.this.lines.size() - 1).length()) {
                SpruceTextAreaWidget.this.lines.clear();
                SpruceTextAreaWidget.this.lines.add("");
                this.cancel();
                return true;
            }
            if (start.row == end.row) {
                String line = SpruceTextAreaWidget.this.lines.get(start.row);
                if (start.column == 0 && end.column >= line.length()) {
                    SpruceTextAreaWidget.this.lines.remove(start.row);
                } else {
                    SpruceTextAreaWidget.this.lines.replaceRow(start.row, line.substring(0, start.column) + line.substring(end.column));
                }
                SpruceTextAreaWidget.this.cursor.copy(start);
                this.cancel();
                return true;
            }
            String text = SpruceTextAreaWidget.this.getText();
            String newText = text.substring(0, start.getPosition()) + text.substring(end.getPosition());
            SpruceTextAreaWidget.this.lines.clear();
            SpruceTextAreaWidget.this.lines.add(newText);
            SpruceTextAreaWidget.this.cursor.copy(start);
            this.cancel();
            return true;
        }

        @Override
        public String getSelectedText() {
            Cursor end;
            if (!this.active) {
                return "";
            }
            Cursor start = (Cursor)this.getStart();
            if (start.isSame(end = (Cursor)this.getEnd())) {
                return "";
            }
            if (start.row == end.row) {
                return SpruceTextAreaWidget.this.lines.get(start.row).substring(start.column, end.column);
            }
            return SpruceTextAreaWidget.this.getText().substring(start.getPosition(), end.getPosition());
        }

        @Override
        protected boolean isInverted() {
            return ((Cursor)this.anchor).row > ((Cursor)this.follower).row || ((Cursor)this.anchor).row == ((Cursor)this.follower).row && ((Cursor)this.anchor).column > ((Cursor)this.follower).column;
        }
    }
}

