/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget.text;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.navigation.NavigationEvent;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.tooltip.Tooltip;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.tooltip.Tooltipable;
import dev.lambdaurora.spruceui.widget.text.AbstractSpruceTextInputWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextFieldWidgetBuilder;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3532;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import net.minecraft.class_8027;
import org.jspecify.annotations.Nullable;

public class SpruceTextFieldWidget
extends AbstractSpruceTextInputWidget<Cursor>
implements Tooltipable {
    public static final Predicate<String> INTEGER_INPUT_PREDICATE = input -> {
        if (input.isEmpty() || input.equals("-")) {
            return true;
        }
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> FLOAT_INPUT_PREDICATE = input -> {
        if (input.isEmpty() || input.equals("-") || input.equals(".")) {
            return true;
        }
        try {
            Float.parseFloat(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> DOUBLE_INPUT_PREDICATE = input -> {
        if (input.isEmpty() || input.equals("-") || input.equals(".")) {
            return true;
        }
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    private final Cursor cursor = new Cursor(true);
    private final Selection selection = new Selection();
    private String text = "";
    private TooltipData tooltip = TooltipData.EMPTY;
    private Consumer<String> changedListener;
    private Predicate<@Nullable String> textPredicate;
    private BiFunction<String, Integer, class_5481> renderTextProvider;
    private int firstCharacterIndex = 0;
    private long editingTime;
    private int tooltipTicks;
    private long lastTick;

    public SpruceTextFieldWidget(Position position, int width, int height, class_2561 title) {
        this(position, width, height, title, null);
    }

    public SpruceTextFieldWidget(Position position, int width, int height, class_2561 title, @Nullable class_2561 placeholder) {
        super(position, width, height, title, placeholder);
        this.cursor.toStart();
        this.sanitize();
        this.changedListener = input -> {};
        this.textPredicate = Objects::nonNull;
        this.renderTextProvider = (input, firstCharacterIndex) -> class_5481.method_30747((String)input, (class_2583)class_2583.field_24360);
    }

    public static SpruceTextFieldWidgetBuilder builder(Position position, int width, int height) {
        return new SpruceTextFieldWidgetBuilder(position, width, height);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(@Nullable String text) {
        if (this.textPredicate.test(text)) {
            this.text = text;
            this.setCursorToEnd();
            this.selection.cancel();
            this.sanitize();
            this.onChanged();
        }
    }

    @Override
    public TooltipData getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setTooltip(TooltipData tooltip) {
        Objects.requireNonNull(tooltip, "Tooltip cannot be null, the absence of a tooltip is represented by TooltipData.EMPTY.");
        this.tooltip = tooltip;
    }

    public Consumer<String> getChangedListener() {
        return this.changedListener;
    }

    public void setChangedListener(Consumer<String> changedListener) {
        Objects.requireNonNull(changedListener, "changedListener cannot be null");
        this.changedListener = changedListener;
    }

    public Predicate<String> getTextPredicate() {
        return this.textPredicate;
    }

    public void setTextPredicate(Predicate<String> textPredicate) {
        this.textPredicate = textPredicate;
    }

    public BiFunction<String, Integer, class_5481> getRenderTextProvider() {
        return this.renderTextProvider;
    }

    public void setRenderTextProvider(BiFunction<String, Integer, class_5481> renderTextProvider) {
        this.renderTextProvider = renderTextProvider;
    }

    @Override
    protected Cursor cursor() {
        return this.cursor;
    }

    @Override
    protected AbstractSpruceTextInputWidget.Selection selection() {
        return this.selection;
    }

    @Override
    public void setCursorToStart() {
        this.cursor.toStart();
    }

    @Override
    public void setCursorToEnd() {
        this.cursor.toEnd();
    }

    @Override
    protected void sanitize() {
        this.cursor.sanitize();
        int textLength = this.text.length();
        if (this.firstCharacterIndex > textLength) {
            this.firstCharacterIndex = textLength;
        }
        int width = this.getInnerWidth();
        String string = this.client.field_1772.method_27523(this.text.substring(this.firstCharacterIndex), width);
        int l = string.length() + this.firstCharacterIndex;
        if (this.cursor.column == this.firstCharacterIndex) {
            this.firstCharacterIndex -= this.client.field_1772.method_27524(this.text, width, true).length();
        }
        if (this.cursor.column > l) {
            this.firstCharacterIndex += this.cursor.column - l;
        } else if (this.cursor.column <= this.firstCharacterIndex) {
            this.firstCharacterIndex -= this.firstCharacterIndex - this.cursor.column;
        }
        this.firstCharacterIndex = class_3532.method_15340((int)this.firstCharacterIndex, (int)0, (int)textLength);
    }

    private void onChanged() {
        this.changedListener.accept(this.text);
        this.editingTime = class_156.method_658() + 5000L;
    }

    private boolean onSelectionUpdate(Runnable action, boolean hasShiftDown) {
        this.selection.tryStartSelection(hasShiftDown);
        action.run();
        this.selection.moveToCursor(hasShiftDown);
        this.sanitize();
        return true;
    }

    @Override
    protected void insertCharacter(String character) {
        if (this.getText().isEmpty()) {
            this.setText(character);
            return;
        }
        this.selection.erase();
        if (character.equals("\n")) {
            return;
        }
        String text = this.getText();
        int cursorPosition = this.cursor.getPosition();
        String newText = cursorPosition >= text.length() ? text + character : text.substring(0, cursorPosition) + character + text.substring(cursorPosition);
        if (this.textPredicate.test(newText)) {
            this.text = newText;
            this.onChanged();
            this.cursor.moveRight();
        }
        this.sanitize();
    }

    private void eraseCharacter() {
        int cursorPosition;
        if (this.selection.erase()) {
            this.sanitize();
            this.onChanged();
            return;
        }
        if (this.cursor.column == 0) {
            return;
        }
        String text = this.getText();
        String newText = text.substring(0, (cursorPosition = this.cursor.getPosition()) - 1) + text.substring(cursorPosition);
        if (this.textPredicate.test(newText)) {
            this.text = newText;
            this.onChanged();
            this.cursor.moveLeft();
        }
        this.sanitize();
    }

    private void removeCharacterForward() {
        int cursorPosition;
        if (this.selection.erase()) {
            this.sanitize();
            this.onChanged();
            return;
        }
        if (this.getText().isEmpty()) {
            this.sanitize();
            return;
        }
        if (this.cursor.column >= this.getText().length()) {
            return;
        }
        String text = this.getText();
        String newText = text.substring(0, cursorPosition = this.cursor.getPosition()) + text.substring(cursorPosition + 1);
        if (this.textPredicate.test(newText)) {
            this.text = newText;
            this.onChanged();
        }
        this.sanitize();
    }

    public void write(String text) {
        if (text.isEmpty()) {
            return;
        }
        if (this.getText().isEmpty()) {
            this.setText(text);
            this.setCursorToEnd();
            return;
        }
        this.selection.erase();
        String oldText = this.getText();
        int position = this.cursor.getPosition();
        String newText = position >= oldText.length() ? oldText + text : oldText.substring(0, position) + text + oldText.substring(position);
        if (this.textPredicate.test(newText)) {
            this.text = newText;
            this.onChanged();
            this.cursor.move(text.length());
        }
        this.sanitize();
    }

    @Override
    public boolean onNavigation(NavigationEvent event) {
        if (this.requiresCursor()) {
            return false;
        }
        if (!event.tab() && event.direction().method_48237() == class_8027.field_41822) {
            boolean result;
            this.method_25365(true);
            switch (event.direction()) {
                case field_41829: {
                    boolean bl = this.onSelectionUpdate(this.cursor::moveRight, event.hasShiftDown());
                    break;
                }
                case field_41828: {
                    boolean bl = this.onSelectionUpdate(this.cursor::moveLeft, event.hasShiftDown());
                    break;
                }
                default: {
                    boolean bl = result = false;
                }
            }
            if (result) {
                return true;
            }
        }
        return super.onNavigation(event);
    }

    @Override
    protected boolean onKeyPress(class_11908 event) {
        if (!this.isEditorActive()) {
            return false;
        }
        if (event.method_74241()) {
            this.selection.selectAll();
            this.sanitize();
            return true;
        }
        if (event.method_74243()) {
            this.write(this.client.field_1774.method_1460());
            return true;
        }
        if (event.method_74242() || event.method_74244()) {
            String selected = this.selection.getSelectedText();
            if (!selected.isEmpty()) {
                this.client.field_1774.method_1455(selected);
            }
            if (event.method_74244()) {
                this.selection.erase();
                this.sanitize();
            }
            return true;
        }
        return switch (event.comp_4795()) {
            case 262 -> this.onSelectionUpdate(this.cursor::moveRight, event.method_74239());
            case 263 -> this.onSelectionUpdate(this.cursor::moveLeft, event.method_74239());
            case 269 -> this.onSelectionUpdate(this.cursor::toEnd, event.method_74239());
            case 268 -> this.onSelectionUpdate(this.cursor::toStart, event.method_74239());
            case 259 -> {
                this.eraseCharacter();
                yield true;
            }
            case 261 -> {
                this.removeCharacterForward();
                yield true;
            }
            case 68 -> {
                if (event.method_74240() && !this.text.isEmpty()) {
                    this.setText("");
                }
                yield true;
            }
            default -> false;
        };
    }

    @Override
    protected boolean onMouseClick(class_11909 event, boolean doubleClick) {
        if (event.method_74245() == 0) {
            int x = class_3532.method_15357((double)event.comp_4798()) - this.getX() - 4;
            this.method_25365(true);
            this.onSelectionUpdate(() -> {
                String displayedText = this.client.field_1772.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
                this.cursor.lastColumn = this.cursor.column = this.firstCharacterIndex + this.client.field_1772.method_27523(displayedText, x).length();
            }, event.method_74239());
            return true;
        }
        return false;
    }

    @Override
    protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.renderWidget(graphics, mouseX, mouseY, delta);
        this.drawText(graphics);
        this.drawCursor(graphics);
        if (!this.dragging && this.editingTime == 0L) {
            Tooltip.queueFor(this, mouseX, mouseY, this.tooltipTicks, i -> {
                this.tooltipTicks = i;
            }, this.lastTick, i -> {
                this.lastTick = i;
            });
        } else if (this.editingTime < class_156.method_658()) {
            this.editingTime = 0L;
        }
    }

    protected void drawText(SpruceGuiGraphics graphics) {
        int textColor = this.getTextColor();
        int x = this.getX() + 4;
        int y = this.getY() + this.getHeight() / 2 - 4;
        class_2561 placeholder = this.getPlaceholder();
        if (this.text.isEmpty() && placeholder != null) {
            graphics.drawShadowedText(this.client.field_1772, placeholder, x, y, textColor);
            return;
        }
        String displayedText = this.client.field_1772.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
        graphics.drawShadowedText(this.client.field_1772, this.renderTextProvider.apply(displayedText, this.firstCharacterIndex), x, y, textColor);
        this.drawSelection(graphics, displayedText, y);
    }

    protected void drawSelection(SpruceGuiGraphics graphics, String line, int lineY) {
        if (!this.method_25370() || !this.selection.active) {
            return;
        }
        int startIndex = Math.max(0, ((Cursor)this.selection.getStart()).column - this.firstCharacterIndex);
        int endIndex = Math.min(line.length(), ((Cursor)this.selection.getEnd()).column - this.firstCharacterIndex);
        if (startIndex >= line.length()) {
            return;
        }
        int x = this.getX() + 4 + this.client.field_1772.method_1727(line.substring(0, startIndex));
        String selected = line.substring(startIndex, endIndex);
        int x2 = x + this.client.field_1772.method_1727(selected);
        Objects.requireNonNull(this.client.field_1772);
        int y2 = lineY + 9;
        graphics.fill(class_10799.field_56881, x, lineY, x2, y2, -16776961);
    }

    protected void drawCursor(SpruceGuiGraphics graphics) {
        if (!this.method_25370()) {
            return;
        }
        int cursorY = this.getY() + this.getHeight() / 2 - 4;
        if (this.text.isEmpty()) {
            graphics.drawShadowedText(this.client.field_1772, (class_2561)class_2561.method_43470((String)"_"), this.getX() + 4, cursorY, -2039584);
            return;
        }
        this.cursor.sanitize();
        String cursorLine = this.text.substring(this.firstCharacterIndex);
        int cursorX = this.getX() + 4 + this.client.field_1772.method_1727(cursorLine.substring(0, this.cursor.column - this.firstCharacterIndex));
        if (this.cursor.column - this.firstCharacterIndex < cursorLine.length()) {
            graphics.fill(cursorX - 1, cursorY - 1, cursorX, cursorY + 9, -2039584);
        } else {
            graphics.drawShadowedText(this.client.field_1772, "_", cursorX, cursorY, -2039584);
        }
    }

    @Override
    public void method_37020(class_6382 builder) {
        super.method_37020(builder);
        this.tooltip.method_37020(builder);
    }

    public class Cursor
    implements AbstractSpruceTextInputWidget.Cursor<Cursor> {
        boolean main;
        int column = 0;
        private int lastColumn = 0;

        public Cursor(boolean main) {
            this.main = main;
        }

        @Override
        public void toStart() {
            this.column = 0;
            this.lastColumn = 0;
        }

        public void moveRight() {
            this.move(1);
        }

        public void moveLeft() {
            this.move(-1);
        }

        public void move(int amount) {
            this.column += amount;
            if (this.column < 0) {
                this.toStart();
            } else if (this.column > SpruceTextFieldWidget.this.text.length()) {
                this.column = SpruceTextFieldWidget.this.text.length();
            }
            this.lastColumn = this.column;
            if (amount < 0 && this.column <= SpruceTextFieldWidget.this.firstCharacterIndex) {
                SpruceTextFieldWidget.this.firstCharacterIndex = this.column - 1;
                SpruceTextFieldWidget.this.firstCharacterIndex = class_3532.method_15340((int)SpruceTextFieldWidget.this.firstCharacterIndex, (int)0, (int)SpruceTextFieldWidget.this.text.length());
            }
        }

        @Override
        public void toEnd() {
            this.lastColumn = this.column = SpruceTextFieldWidget.this.text.length();
        }

        @Override
        public void copy(Cursor cursor) {
            this.lastColumn = this.column = cursor.column;
        }

        public void sanitize() {
            if (this.column < 0) {
                this.toStart();
            } else if (this.column > SpruceTextFieldWidget.this.text.length()) {
                this.column = SpruceTextFieldWidget.this.text.length();
            }
        }

        public boolean isSame(Cursor other) {
            return this.column == other.column;
        }

        public int getPosition() {
            return this.column;
        }

        public String toString() {
            return "SpruceTextAreaWidget$Cursor{main=" + this.main + ", column=" + this.column + ", lastColumn=" + this.lastColumn + "}";
        }
    }

    public class Selection
    extends AbstractSpruceTextInputWidget.Selection {
        protected Selection() {
            super((AbstractSpruceTextInputWidget)SpruceTextFieldWidget.this, (AbstractSpruceTextInputWidget.Cursor)new Cursor(false), (AbstractSpruceTextInputWidget.Cursor)new Cursor(false));
        }

        public boolean erase() {
            Cursor end;
            if (!this.active) {
                return false;
            }
            Cursor start = (Cursor)this.getStart();
            if (start.isSame(end = (Cursor)this.getEnd())) {
                this.cancel();
                return false;
            }
            if (start.column == 0 && end.column >= SpruceTextFieldWidget.this.text.length()) {
                SpruceTextFieldWidget.this.text = "";
                this.cancel();
                return true;
            }
            String text = SpruceTextFieldWidget.this.getText();
            String newText = text.substring(0, start.getPosition()) + text.substring(end.getPosition());
            if (SpruceTextFieldWidget.this.textPredicate.test(newText)) {
                SpruceTextFieldWidget.this.text = newText;
                SpruceTextFieldWidget.this.onChanged();
            }
            SpruceTextFieldWidget.this.cursor.copy(start);
            this.cancel();
            return true;
        }

        @Override
        public String getSelectedText() {
            Cursor end;
            if (!this.active) {
                return "";
            }
            Cursor start = (Cursor)this.getStart();
            if (start.isSame(end = (Cursor)this.getEnd())) {
                return "";
            }
            return SpruceTextFieldWidget.this.getText().substring(start.getPosition(), end.getPosition());
        }

        @Override
        protected boolean isInverted() {
            return ((Cursor)this.anchor).column > ((Cursor)this.follower).column;
        }
    }
}

