/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.hud.screen;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import me.jfenn.bingo.client.common.hud.BingoCardColors;
import me.jfenn.bingo.client.common.hud.BingoMessageRenderer;
import me.jfenn.bingo.client.common.state.BingoHudState;
import me.jfenn.bingo.client.platform.renderer.CursorType;
import me.jfenn.bingo.client.platform.renderer.IDrawService;
import me.jfenn.bingo.client.platform.renderer.IMatrixStack;
import me.jfenn.bingo.client.platform.screen.IButton;
import me.jfenn.bingo.client.platform.screen.IButtonFactory;
import me.jfenn.bingo.client.platform.screen.IDrawable;
import me.jfenn.bingo.client.platform.screen.IKeyInput;
import me.jfenn.bingo.client.platform.screen.IMutableScreenHelper;
import me.jfenn.bingo.client.platform.screen.IScreen;
import me.jfenn.bingo.client.platform.screen.IScreenFactory;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.config.CardAlignment;
import me.jfenn.bingo.common.scoring.GameMessagePacket;
import me.jfenn.bingo.common.scoring.ScoreMessagePacket;
import me.jfenn.bingo.common.team.BingoTeamKey;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.koin.core.Koin;
import me.jfenn.bingo.koin.core.parameter.ParametersHolder;
import me.jfenn.bingo.koin.core.qualifier.Qualifier;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.platform.text.IText;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0006\u008d\u0001\u008e\u0001\u008f\u0001B]\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0017J\u000f\u0010\u001a\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0017J\u000f\u0010\u001b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0017J\u001f\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010%\u001a\u00020$2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0002\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010'\u001a\u00020$2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0002\u00a2\u0006\u0004\b'\u0010&J\u001f\u0010(\u001a\u00020$2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0002\u00a2\u0006\u0004\b(\u0010&J\u001f\u0010)\u001a\u00020$2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0002\u00a2\u0006\u0004\b)\u0010&J\u001f\u0010*\u001a\u00020$2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0016\u00a2\u0006\u0004\b*\u0010&J\u001f\u0010+\u001a\u00020$2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0016\u00a2\u0006\u0004\b+\u0010&J\u0015\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002\u00a2\u0006\u0004\b.\u0010/J/\u00104\u001a\u00020\u00062\u0006\u00101\u001a\u0002002\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c2\u0006\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b4\u00105J\u000f\u00106\u001a\u00020$H\u0016\u00a2\u0006\u0004\b6\u00107J\u0017\u0010:\u001a\u00020$2\u0006\u00109\u001a\u000208H\u0016\u00a2\u0006\u0004\b:\u0010;R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010<R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010=R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010>R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010?R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010@R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010AR\u001b\u0010F\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\bB\u0010C*\u0004\bD\u0010ER\u001b\u0010I\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\bG\u0010C*\u0004\bH\u0010ER\u0014\u0010K\u001a\u00020J8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bK\u0010LR\u0014\u0010M\u001a\u00020J8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010LR\u0017\u0010O\u001a\u00020N8\u0006\u00a2\u0006\f\n\u0004\bO\u0010P\u001a\u0004\bQ\u0010RR\"\u0010S\u001a\u0002028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bS\u0010T\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR\"\u0010Z\u001a\u00020Y8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bZ\u0010[\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\"\u0010`\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b`\u0010a\u001a\u0004\bb\u0010C\"\u0004\bc\u0010dR\"\u0010e\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\be\u0010a\u001a\u0004\bf\u0010C\"\u0004\bg\u0010dR\"\u0010h\u001a\u0002028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bh\u0010T\u001a\u0004\bi\u0010V\"\u0004\bj\u0010XR\"\u0010k\u001a\u0002028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bk\u0010T\u001a\u0004\bl\u0010V\"\u0004\bm\u0010XR\u0011\u0010o\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\bn\u0010VR\u0011\u0010q\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\bp\u0010VR\"\u0010r\u001a\u0002028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\br\u0010T\u001a\u0004\bs\u0010V\"\u0004\bt\u0010XR\"\u0010u\u001a\u0002028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bu\u0010T\u001a\u0004\bv\u0010V\"\u0004\bw\u0010XR$\u0010y\u001a\u0004\u0018\u00010x8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\by\u0010z\u001a\u0004\b{\u0010|\"\u0004\b}\u0010~R$\u0010\u007f\u001a\u0002028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0014\n\u0004\b\u007f\u0010T\u001a\u0005\b\u0080\u0001\u0010V\"\u0005\b\u0081\u0001\u0010XR(\u0010\u0082\u0001\u001a\u0004\u0018\u00010x8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0082\u0001\u0010z\u001a\u0005\b\u0083\u0001\u0010|\"\u0005\b\u0084\u0001\u0010~R\u0016\u0010\u0085\u0001\u001a\u00020\u001c8\u0002X\u0082D\u00a2\u0006\u0007\n\u0005\b\u0085\u0001\u0010aR\u001e\u0010\u0087\u0001\u001a\t\u0012\u0004\u0012\u0002020\u0086\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0087\u0001\u0010\u0088\u0001R\u0018\u0010\u008a\u0001\u001a\u00030\u0089\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008a\u0001\u0010\u008b\u0001R\u0018\u0010\u008c\u0001\u001a\u00030\u0089\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008c\u0001\u0010\u008b\u0001\u00a8\u0006\u0090\u0001"}, d2={"Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen;", "Lme/jfenn/bingo/client/platform/screen/IScreen;", "Lme/jfenn/bingo/koin/core/Koin;", "koin", "Lkotlin/Function1;", "Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$Result;", "", "onCloseCallback", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "state", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/client/platform/screen/IMutableScreenHelper;", "helper", "Lme/jfenn/bingo/client/common/hud/BingoMessageRenderer;", "messageRenderer", "Lme/jfenn/bingo/client/platform/screen/IButtonFactory;", "buttonFactory", "<init>", "(Lorg/koin/core/Koin;Lkotlin/jvm/functions/Function1;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/client/common/state/BingoHudState;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/client/platform/screen/IMutableScreenHelper;Lme/jfenn/bingo/client/common/hud/BingoMessageRenderer;Lme/jfenn/bingo/client/platform/screen/IButtonFactory;)V", "initCardPosition", "()V", "applyCardPosition", "writeCardPosition", "initButtons", "init", "", "width", "height", "resize", "(II)V", "", "mouseX", "mouseY", "", "isIntersectingRightBorder", "(DD)Z", "isIntersectingBottomBorder", "isIntersectingCardBorder", "isIntersectingCard", "mouseDragged", "mouseReleased", "", "Lme/jfenn/bingo/client/common/state/BingoHudState$ScoreMessage;", "createDummyMessages", "()Ljava/util/List;", "Lme/jfenn/bingo/client/platform/renderer/IDrawService;", "drawService", "", "delta", "render", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;IIF)V", "shouldCloseOnEsc", "()Z", "Lme/jfenn/bingo/client/platform/screen/IKeyInput;", "input", "keyPressed", "(Lme/jfenn/bingo/client/platform/screen/IKeyInput;)Z", "Lkotlin/jvm/functions/Function1;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/client/platform/screen/IMutableScreenHelper;", "Lme/jfenn/bingo/client/common/hud/BingoMessageRenderer;", "getScaledWindowWidth", "()I", "getScaledWindowWidth$delegate", "(Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen;)Ljava/lang/Object;", "scaledWindowWidth", "getScaledWindowHeight", "getScaledWindowHeight$delegate", "scaledWindowHeight", "Lme/jfenn/bingo/client/platform/screen/IButton;", "cancelButton", "Lme/jfenn/bingo/client/platform/screen/IButton;", "saveButton", "Lme/jfenn/bingo/client/common/hud/BingoCardColors$TeamColors;", "cardColors", "Lme/jfenn/bingo/client/common/hud/BingoCardColors$TeamColors;", "getCardColors", "()Lme/jfenn/bingo/client/common/hud/BingoCardColors$TeamColors;", "cardScale", "F", "getCardScale", "()F", "setCardScale", "(F)V", "Lme/jfenn/bingo/common/config/CardAlignment;", "cardAlignment", "Lme/jfenn/bingo/common/config/CardAlignment;", "getCardAlignment", "()Lme/jfenn/bingo/common/config/CardAlignment;", "setCardAlignment", "(Lme/jfenn/bingo/common/config/CardAlignment;)V", "cardOffsetX", "I", "getCardOffsetX", "setCardOffsetX", "(I)V", "cardOffsetY", "getCardOffsetY", "setCardOffsetY", "cardLeft", "getCardLeft", "setCardLeft", "cardTop", "getCardTop", "setCardTop", "getCardRight", "cardRight", "getCardBottom", "cardBottom", "dragFromLeft", "getDragFromLeft", "setDragFromLeft", "dragFromTop", "getDragFromTop", "setDragFromTop", "Lorg/joml/Vector2d;", "dragStart", "Lorg/joml/Vector2d;", "getDragStart", "()Lorg/joml/Vector2d;", "setDragStart", "(Lorg/joml/Vector2d;)V", "resizeFromScale", "getResizeFromScale", "setResizeFromScale", "resizeStart", "getResizeStart", "setResizeStart", "resizeHandleSize", "", "cardScaleSnapToValues", "[Ljava/lang/Float;", "Lme/jfenn/bingo/platform/text/IText;", "helpText1", "Lme/jfenn/bingo/platform/text/IText;", "helpText2", "Factory", "Result", "CardDrawable", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nBingoCardPlacementScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoCardPlacementScreen.kt\nme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen\n+ 2 Koin.kt\norg/koin/core/Koin\n+ 3 Scope.kt\norg/koin/core/scope/Scope\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 IMatrixStack.kt\nme/jfenn/bingo/client/platform/renderer/IMatrixStackKt\n*L\n1#1,350:1\n124#2,4:351\n124#2,4:356\n124#2,4:361\n124#2,4:366\n124#2,4:371\n142#3:355\n142#3:360\n142#3:365\n142#3:370\n142#3:375\n1563#4:376\n1634#4,3:377\n17#5,7:380\n*S KotlinDebug\n*F\n+ 1 BingoCardPlacementScreen.kt\nme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen\n*L\n31#1:351,4\n32#1:356,4\n33#1:361,4\n35#1:366,4\n36#1:371,4\n31#1:355\n32#1:360\n33#1:365\n35#1:370\n36#1:375\n257#1:376\n257#1:377,3\n332#1:380,7\n*E\n"})
public final class BingoCardPlacementScreen
implements IScreen {
    @NotNull
    private final Function1<Result, Unit> onCloseCallback;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final BingoHudState state;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final IMutableScreenHelper helper;
    @NotNull
    private final BingoMessageRenderer messageRenderer;
    @NotNull
    private final IButton cancelButton;
    @NotNull
    private final IButton saveButton;
    @NotNull
    private final BingoCardColors.TeamColors cardColors;
    private float cardScale;
    @NotNull
    private CardAlignment cardAlignment;
    private int cardOffsetX;
    private int cardOffsetY;
    private float cardLeft;
    private float cardTop;
    private float dragFromLeft;
    private float dragFromTop;
    @Nullable
    private Vector2d dragStart;
    private float resizeFromScale;
    @Nullable
    private Vector2d resizeStart;
    private final int resizeHandleSize;
    @NotNull
    private final Float[] cardScaleSnapToValues;
    @NotNull
    private final IText helpText1;
    @NotNull
    private final IText helpText2;

    public BingoCardPlacementScreen(@NotNull Koin koin, @NotNull Function1<? super Result, Unit> onCloseCallback, @NotNull TextProvider text, @NotNull BingoHudState state, @NotNull BingoConfig config, @NotNull IMutableScreenHelper helper, @NotNull BingoMessageRenderer messageRenderer, @NotNull IButtonFactory buttonFactory) {
        Intrinsics.checkNotNullParameter((Object)koin, (String)"koin");
        Intrinsics.checkNotNullParameter(onCloseCallback, (String)"onCloseCallback");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)messageRenderer, (String)"messageRenderer");
        Intrinsics.checkNotNullParameter((Object)buttonFactory, (String)"buttonFactory");
        this.onCloseCallback = onCloseCallback;
        this.text = text;
        this.state = state;
        this.config = config;
        this.helper = helper;
        this.messageRenderer = messageRenderer;
        this.cancelButton = buttonFactory.createDefaultButton(this.text.translatable("gui.cancel", "Cancel", new Object[0]), (Function0<Unit>)((Function0)() -> BingoCardPlacementScreen.cancelButton$lambda$0(this)));
        this.saveButton = buttonFactory.createDefaultButton(this.text.translatable("gui.ok", "Ok", new Object[0]), (Function0<Unit>)((Function0)() -> BingoCardPlacementScreen.saveButton$lambda$0(this)));
        this.cardColors = this.state.getCardColors().getTeamColors-vRxwntw(null, null);
        this.cardScale = this.config.getClient().getCardScale();
        this.cardAlignment = this.config.getClient().getCardAlignment();
        this.cardOffsetX = this.config.getClient().getCardOffsetX();
        this.cardOffsetY = this.config.getClient().getCardOffsetY();
        this.resizeFromScale = 1.0f;
        this.resizeHandleSize = 10;
        Float[] floatArray = new Float[]{Float.valueOf(0.5f), Float.valueOf(0.75f), Float.valueOf(1.0f), Float.valueOf(1.5f), Float.valueOf(2.0f)};
        this.cardScaleSnapToValues = floatArray;
        this.helpText1 = this.text.string(StringKey.ConfigCardPositionHelpMove);
        this.helpText2 = this.text.string(StringKey.ConfigCardPositionHelpResize);
    }

    public /* synthetic */ BingoCardPlacementScreen(Koin koin, Function1 function1, TextProvider textProvider, BingoHudState bingoHudState, BingoConfig bingoConfig, IMutableScreenHelper iMutableScreenHelper, BingoMessageRenderer bingoMessageRenderer, IButtonFactory iButtonFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean $i$f$get;
        Scope this_$iv$iv;
        boolean $i$f$get2;
        Function0<? extends ParametersHolder> parameters$iv;
        Qualifier qualifier$iv;
        Koin $this$iv;
        if ((n & 4) != 0) {
            $this$iv = koin;
            qualifier$iv = null;
            parameters$iv = null;
            $i$f$get2 = false;
            this_$iv$iv = $this$iv.getScopeRegistry().getRootScope();
            $i$f$get = false;
            textProvider = (TextProvider)this_$iv$iv.get(Reflection.getOrCreateKotlinClass(TextProvider.class), qualifier$iv, parameters$iv);
        }
        if ((n & 8) != 0) {
            $this$iv = koin;
            qualifier$iv = null;
            parameters$iv = null;
            $i$f$get2 = false;
            this_$iv$iv = $this$iv.getScopeRegistry().getRootScope();
            $i$f$get = false;
            bingoHudState = (BingoHudState)this_$iv$iv.get(Reflection.getOrCreateKotlinClass(BingoHudState.class), qualifier$iv, parameters$iv);
        }
        if ((n & 0x10) != 0) {
            $this$iv = koin;
            qualifier$iv = null;
            parameters$iv = null;
            $i$f$get2 = false;
            this_$iv$iv = $this$iv.getScopeRegistry().getRootScope();
            $i$f$get = false;
            bingoConfig = (BingoConfig)this_$iv$iv.get(Reflection.getOrCreateKotlinClass(BingoConfig.class), qualifier$iv, parameters$iv);
        }
        if ((n & 0x40) != 0) {
            $this$iv = koin;
            qualifier$iv = null;
            parameters$iv = null;
            $i$f$get2 = false;
            this_$iv$iv = $this$iv.getScopeRegistry().getRootScope();
            $i$f$get = false;
            bingoMessageRenderer = (BingoMessageRenderer)this_$iv$iv.get(Reflection.getOrCreateKotlinClass(BingoMessageRenderer.class), qualifier$iv, parameters$iv);
        }
        if ((n & 0x80) != 0) {
            $this$iv = koin;
            qualifier$iv = null;
            parameters$iv = null;
            $i$f$get2 = false;
            this_$iv$iv = $this$iv.getScopeRegistry().getRootScope();
            $i$f$get = false;
            iButtonFactory = (IButtonFactory)this_$iv$iv.get(Reflection.getOrCreateKotlinClass(IButtonFactory.class), qualifier$iv, parameters$iv);
        }
        this(koin, (Function1<? super Result, Unit>)function1, textProvider, bingoHudState, bingoConfig, iMutableScreenHelper, bingoMessageRenderer, iButtonFactory);
    }

    private final int getScaledWindowWidth() {
        return this.helper.getWidth();
    }

    private static Object getScaledWindowWidth$delegate(BingoCardPlacementScreen bingoCardPlacementScreen) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)bingoCardPlacementScreen.helper, IMutableScreenHelper.class, "width", "getWidth()I", 0)));
    }

    private final int getScaledWindowHeight() {
        return this.helper.getHeight();
    }

    private static Object getScaledWindowHeight$delegate(BingoCardPlacementScreen bingoCardPlacementScreen) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)bingoCardPlacementScreen.helper, IMutableScreenHelper.class, "height", "getHeight()I", 0)));
    }

    @NotNull
    public final BingoCardColors.TeamColors getCardColors() {
        return this.cardColors;
    }

    public final float getCardScale() {
        return this.cardScale;
    }

    public final void setCardScale(float f) {
        this.cardScale = f;
    }

    @NotNull
    public final CardAlignment getCardAlignment() {
        return this.cardAlignment;
    }

    public final void setCardAlignment(@NotNull CardAlignment cardAlignment) {
        Intrinsics.checkNotNullParameter((Object)((Object)cardAlignment), (String)"<set-?>");
        this.cardAlignment = cardAlignment;
    }

    public final int getCardOffsetX() {
        return this.cardOffsetX;
    }

    public final void setCardOffsetX(int n) {
        this.cardOffsetX = n;
    }

    public final int getCardOffsetY() {
        return this.cardOffsetY;
    }

    public final void setCardOffsetY(int n) {
        this.cardOffsetY = n;
    }

    public final float getCardLeft() {
        return this.cardLeft;
    }

    public final void setCardLeft(float f) {
        this.cardLeft = f;
    }

    public final float getCardTop() {
        return this.cardTop;
    }

    public final void setCardTop(float f) {
        this.cardTop = f;
    }

    public final float getCardRight() {
        return this.cardLeft + (float)122 * this.cardScale;
    }

    public final float getCardBottom() {
        return this.cardTop + (float)132 * this.cardScale;
    }

    public final float getDragFromLeft() {
        return this.dragFromLeft;
    }

    public final void setDragFromLeft(float f) {
        this.dragFromLeft = f;
    }

    public final float getDragFromTop() {
        return this.dragFromTop;
    }

    public final void setDragFromTop(float f) {
        this.dragFromTop = f;
    }

    @Nullable
    public final Vector2d getDragStart() {
        return this.dragStart;
    }

    public final void setDragStart(@Nullable Vector2d vector2d) {
        this.dragStart = vector2d;
    }

    public final float getResizeFromScale() {
        return this.resizeFromScale;
    }

    public final void setResizeFromScale(float f) {
        this.resizeFromScale = f;
    }

    @Nullable
    public final Vector2d getResizeStart() {
        return this.resizeStart;
    }

    public final void setResizeStart(@Nullable Vector2d vector2d) {
        this.resizeStart = vector2d;
    }

    private final void initCardPosition() {
        int offsetX = this.cardOffsetX * (this.cardAlignment.getX() > 0 ? -1 : 1);
        int offsetY = this.cardOffsetY * (this.cardAlignment.getY() > 0 ? -1 : 1);
        this.cardLeft = RangesKt.coerceIn((float)((float)this.cardAlignment.getX() * ((float)this.getScaledWindowWidth() - (float)122 * this.cardScale) + (float)offsetX), (float)0.0f, (float)((float)this.getScaledWindowWidth() - (float)122 * this.cardScale));
        this.cardTop = RangesKt.coerceIn((float)((float)this.cardAlignment.getY() * ((float)this.getScaledWindowHeight() - (float)132 * this.cardScale) + (float)offsetY), (float)0.0f, (float)((float)this.getScaledWindowHeight() - (float)132 * this.cardScale));
    }

    private final void applyCardPosition() {
        boolean isBottomEdge;
        boolean isRightEdge = (float)this.getScaledWindowWidth() - this.getCardRight() < this.cardLeft;
        boolean bl = isBottomEdge = (float)this.getScaledWindowHeight() - this.getCardBottom() < this.cardTop;
        this.cardAlignment = isRightEdge && isBottomEdge ? CardAlignment.BOTTOM_RIGHT : (isRightEdge ? CardAlignment.TOP_RIGHT : (isBottomEdge ? CardAlignment.BOTTOM_LEFT : CardAlignment.TOP_LEFT));
        this.cardOffsetX = MathKt.roundToInt((float)(isRightEdge ? (float)this.getScaledWindowWidth() - this.getCardRight() : this.cardLeft));
        this.cardOffsetY = MathKt.roundToInt((float)(isBottomEdge ? (float)this.getScaledWindowHeight() - this.getCardBottom() : this.cardTop));
    }

    private final void writeCardPosition() {
        this.config.getClient().setCardAlignment(this.cardAlignment);
        this.config.getClient().setCardScale(this.cardScale);
        this.config.getClient().setCardOffsetX(this.cardOffsetX);
        this.config.getClient().setCardOffsetY(this.cardOffsetY);
    }

    private final void initButtons() {
        this.helper.clearChildren();
        this.helper.addDrawable(new CardDrawable());
        this.helper.addButton(this.cancelButton);
        this.helper.addButton(this.saveButton);
        this.cancelButton.setPosition(new Vector2i(this.getScaledWindowWidth() / 2 - this.cancelButton.getSize().x - 4, this.getScaledWindowHeight() - this.cancelButton.getSize().y - 8));
        this.saveButton.setPosition(new Vector2i(this.getScaledWindowWidth() / 2 + 4, this.getScaledWindowHeight() - this.cancelButton.getSize().y - 8));
    }

    @Override
    public void init() {
        this.initButtons();
        this.initCardPosition();
    }

    @Override
    public void resize(int width, int height) {
        this.initButtons();
        this.initCardPosition();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIntersectingRightBorder(double mouseX, double mouseY) {
        float f = this.getCardRight() - (float)this.resizeHandleSize;
        if (!(mouseX <= (double)(this.getCardRight() + (float)this.resizeHandleSize))) return false;
        if (!((double)f <= mouseX)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = this.cardTop;
        if (!(mouseY <= (double)this.getCardBottom())) return false;
        if (!((double)f <= mouseY)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIntersectingBottomBorder(double mouseX, double mouseY) {
        float f = this.cardLeft;
        if (!(mouseX <= (double)this.getCardRight())) return false;
        if (!((double)f <= mouseX)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = this.getCardBottom() - (float)this.resizeHandleSize;
        if (!(mouseY <= (double)(this.getCardBottom() + (float)this.resizeHandleSize))) return false;
        if (!((double)f <= mouseY)) return false;
        return true;
    }

    private final boolean isIntersectingCardBorder(double mouseX, double mouseY) {
        return this.isIntersectingRightBorder(mouseX, mouseY) || this.isIntersectingBottomBorder(mouseX, mouseY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIntersectingCard(double mouseX, double mouseY) {
        float f = this.cardLeft;
        if (!(mouseX <= (double)this.getCardRight())) return false;
        if (!((double)f <= mouseX)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = this.cardTop;
        if (!(mouseY <= (double)this.getCardBottom())) return false;
        if (!((double)f <= mouseY)) return false;
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY) {
        Vector2d pos = new Vector2d(mouseX, mouseY);
        if (this.resizeStart != null || this.isIntersectingCardBorder(mouseX, mouseY) && this.dragStart == null) {
            Vector2d vector2d = this.resizeStart;
            if (vector2d == null) {
                BingoCardPlacementScreen $this$mouseDragged_u24lambda_u240 = this;
                boolean bl = false;
                $this$mouseDragged_u24lambda_u240.resizeFromScale = $this$mouseDragged_u24lambda_u240.cardScale;
                $this$mouseDragged_u24lambda_u240.resizeStart = pos;
                vector2d = pos;
            }
            Vector2d start = vector2d;
            Vector2d cardPos = new Vector2d((double)this.cardLeft, (double)this.cardTop);
            float distanceToStart = (float)cardPos.distance((Vector2dc)start);
            float distanceToPos = (float)cardPos.distance((Vector2dc)pos);
            this.cardScale = RangesKt.coerceIn((float)(this.resizeFromScale / distanceToStart * distanceToPos), (float)0.25f, (float)((float)this.getScaledWindowHeight() / (float)132));
            Float[] bl = this.cardScaleSnapToValues;
            int n = bl.length;
            for (int i = 0; i < n; ++i) {
                float cardScaleValue = bl[i].floatValue();
                if (!((double)Math.abs(cardScaleValue - this.cardScale) < 0.05)) continue;
                this.cardScale = cardScaleValue;
            }
            return true;
        }
        if (this.dragStart != null || this.isIntersectingCard(mouseX, mouseY)) {
            Vector2d vector2d = this.dragStart;
            if (vector2d == null) {
                BingoCardPlacementScreen $this$mouseDragged_u24lambda_u241 = this;
                boolean bl = false;
                $this$mouseDragged_u24lambda_u241.dragFromLeft = $this$mouseDragged_u24lambda_u241.cardLeft;
                $this$mouseDragged_u24lambda_u241.dragFromTop = $this$mouseDragged_u24lambda_u241.cardTop;
                $this$mouseDragged_u24lambda_u241.dragStart = pos;
                vector2d = pos;
            }
            Vector2d start = vector2d;
            this.cardLeft = this.dragFromLeft + (float)(pos.x - start.x);
            this.cardTop = this.dragFromTop + (float)(pos.y - start.y);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY) {
        if (this.resizeStart != null) {
            this.resizeStart = null;
            this.applyCardPosition();
            this.initCardPosition();
            return true;
        }
        if (this.dragStart != null) {
            this.dragStart = null;
            this.applyCardPosition();
            this.initCardPosition();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BingoHudState.ScoreMessage> createDummyMessages() {
        void $this$mapTo$iv$iv;
        class_124[] class_124Array = new class_124[]{class_124.field_1076};
        IText playerName = this.text.literal("\ud83c\udf3a fennifith").formatted(class_124Array);
        Object[] objectArray = new Object[]{playerName, this.text.empty().append("[").append(this.text.string(StringKey.ObjectiveExampleYourNose)).append("]")};
        List messages = CollectionsKt.listOf((Object)this.text.string(StringKey.GameMessageCapturedItem, objectArray));
        Iterable $this$map$iv = messages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void message;
            IText iText = (IText)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Instant instant = this.state.getNow().minus(500L, ChronoUnit.MILLIS);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minus(...)");
            UUID uUID = new UUID(0L, 0L);
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
            collection.add(new BingoHudState.ScoreMessage(instant, new GameMessagePacket(uUID, duration2, BingoTeamKey.constructor-impl(""), null, null, null, ScoreMessagePacket.MessageType.ITEM_SCORED, (IText)message, false, 280, null), null, 0, 12, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(@NotNull IDrawService drawService, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)drawService, (String)"drawService");
        IMatrixStack $this$use$iv = drawService.getMatrices();
        boolean $i$f$use = false;
        try {
            $this$use$iv.push();
            IMatrixStack $this$render_u24lambda_u240 = $this$use$iv;
            boolean bl = false;
            int helpText1Size = drawService.getFont().getTextWidth(this.helpText1);
            drawService.drawText(this.helpText1, this.getScaledWindowWidth() / 2 - helpText1Size / 2, 8, -6031965, true);
            int helpText2Size = drawService.getFont().getTextWidth(this.helpText2);
            drawService.drawText(this.helpText2, this.getScaledWindowWidth() / 2 - helpText2Size / 2, 16 + drawService.getFont().getTextHeight(), -6031965, true);
        }
        finally {
            $this$use$iv.pop();
        }
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    public boolean keyPressed(@NotNull IKeyInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (input.isEscape()) {
            this.onCloseCallback.invoke((Object)Result.Cancel.INSTANCE);
            return true;
        }
        return false;
    }

    private static final Unit cancelButton$lambda$0(BingoCardPlacementScreen this$0) {
        this$0.onCloseCallback.invoke((Object)Result.Cancel.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit saveButton$lambda$0(BingoCardPlacementScreen this$0) {
        this$0.writeCardPosition();
        this$0.onCloseCallback.invoke((Object)new Result.Ok(this$0.cardScale, this$0.cardAlignment, this$0.cardOffsetX, this$0.cardOffsetY));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$CardDrawable;", "Lme/jfenn/bingo/client/platform/screen/IDrawable;", "<init>", "(Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen;)V", "Lme/jfenn/bingo/client/platform/renderer/IDrawService;", "drawService", "", "render", "(Lme/jfenn/bingo/client/platform/renderer/IDrawService;)V", "bingo-common_client"})
    @Environment(value=EnvType.CLIENT)
    @SourceDebugExtension(value={"SMAP\nBingoCardPlacementScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoCardPlacementScreen.kt\nme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$CardDrawable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IMatrixStack.kt\nme/jfenn/bingo/client/platform/renderer/IMatrixStackKt\n*L\n1#1,350:1\n1#2:351\n17#3,7:352\n*S KotlinDebug\n*F\n+ 1 BingoCardPlacementScreen.kt\nme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$CardDrawable\n*L\n276#1:352,7\n*E\n"})
    public final class CardDrawable
    implements IDrawable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void render(@NotNull IDrawService drawService) {
            void $this$use$iv;
            Intrinsics.checkNotNullParameter((Object)drawService, (String)"drawService");
            Vector2i it = drawService.getMouse();
            boolean bl = false;
            Pair pair = new Pair((Object)it.x, (Object)it.y);
            double mouseX = ((Number)pair.component1()).doubleValue();
            double mouseY = ((Number)pair.component2()).doubleValue();
            IMatrixStack iMatrixStack = drawService.getMatrices();
            BingoCardPlacementScreen bingoCardPlacementScreen = BingoCardPlacementScreen.this;
            boolean $i$f$use = false;
            try {
                $this$use$iv.push();
                void $this$render_u24lambda_u241 = $this$use$iv;
                boolean bl2 = false;
                drawService.getMatrices().translate(bingoCardPlacementScreen.getCardLeft(), bingoCardPlacementScreen.getCardTop(), 0.0f);
                drawService.getMatrices().scale(bingoCardPlacementScreen.getCardScale(), bingoCardPlacementScreen.getCardScale(), 1.0f);
                IDrawService.drawGuiTexture$default(drawService, bingoCardPlacementScreen.getCardColors().getCardTexture(), 0, 0, 0, 0.0f, 0.0f, 122, 132, 122, 132, 8, null);
                boolean isOverCardBorder = bingoCardPlacementScreen.isIntersectingCardBorder(mouseX, mouseY);
                boolean isOverCard = bingoCardPlacementScreen.isIntersectingCard(mouseX, mouseY);
                if (isOverCardBorder && bingoCardPlacementScreen.getResizeStart() == null) {
                    drawService.setCursor(bingoCardPlacementScreen.isIntersectingRightBorder(mouseX, mouseY) ? CursorType.RESIZE_HORIZONTAL : CursorType.RESIZE_VERTICAL);
                } else if (isOverCard || bingoCardPlacementScreen.getDragStart() != null || bingoCardPlacementScreen.getResizeStart() != null) {
                    drawService.setCursor(CursorType.RESIZE_ALL);
                }
                if (bingoCardPlacementScreen.getDragStart() != null || bingoCardPlacementScreen.getResizeStart() != null) {
                    drawService.overlayFill(0, 0, 122, 132, -2130706433);
                } else if (isOverCardBorder || isOverCard) {
                    IDrawService.drawGuiTexture$default(drawService, bingoCardPlacementScreen.getCardColors().getCardTextureOutline(), 0, 0, 0, 0.0f, 0.0f, 122, 132, 122, 132, 8, null);
                }
            }
            finally {
                $this$use$iv.pop();
            }
            BingoMessageRenderer.drawMessages$default(BingoCardPlacementScreen.this.messageRenderer, drawService, (int)BingoCardPlacementScreen.this.getCardLeft(), (int)BingoCardPlacementScreen.this.getCardTop() + (int)((float)132 * BingoCardPlacementScreen.this.getCardScale() * (float)(1 - BingoCardPlacementScreen.this.getCardAlignment().getY())), 0, 0.0f, BingoCardPlacementScreen.this.getCardAlignment(), BingoCardPlacementScreen.this.getCardScale(), BingoCardPlacementScreen.this.createDummyMessages(), 16, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u0013\u001a\u00020\u00122\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0017R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0018R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$Factory;", "", "Lme/jfenn/bingo/koin/core/Koin;", "koin", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "state", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/client/platform/screen/IScreenFactory;", "screenFactory", "<init>", "(Lorg/koin/core/Koin;Lme/jfenn/bingo/common/text/TextProvider;Lme/jfenn/bingo/client/common/state/BingoHudState;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/client/platform/screen/IScreenFactory;)V", "Lkotlin/Function1;", "Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$Result;", "", "onClose", "Lnet/minecraft/class_437;", "create", "(Lkotlin/jvm/functions/Function1;)Lnet/minecraft/class_437;", "Lme/jfenn/bingo/koin/core/Koin;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lme/jfenn/bingo/client/common/state/BingoHudState;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/client/platform/screen/IScreenFactory;", "bingo-common_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Factory {
        @NotNull
        private final Koin koin;
        @NotNull
        private final TextProvider text;
        @NotNull
        private final BingoHudState state;
        @NotNull
        private final BingoConfig config;
        @NotNull
        private final IScreenFactory screenFactory;

        public Factory(@NotNull Koin koin, @NotNull TextProvider text, @NotNull BingoHudState state, @NotNull BingoConfig config, @NotNull IScreenFactory screenFactory) {
            Intrinsics.checkNotNullParameter((Object)koin, (String)"koin");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)screenFactory, (String)"screenFactory");
            this.koin = koin;
            this.text = text;
            this.state = state;
            this.config = config;
            this.screenFactory = screenFactory;
        }

        @NotNull
        public final class_437 create(@NotNull Function1<? super Result, Unit> onClose) {
            Intrinsics.checkNotNullParameter(onClose, (String)"onClose");
            return this.screenFactory.build(this.text.string(StringKey.CardTitle), (Function1<? super IMutableScreenHelper, ? extends IScreen>)((Function1)arg_0 -> Factory.create$lambda$0(this, onClose, arg_0)));
        }

        private static final IScreen create$lambda$0(Factory this$0, Function1 $onClose, IMutableScreenHelper helper) {
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            return new BingoCardPlacementScreen(this$0.koin, $onClose, this$0.text, this$0.state, this$0.config, helper, null, null, 192, null);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$Result;", "", "Ok", "Cancel", "Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$Result$Cancel;", "Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$Result$Ok;", "bingo-common_client"})
    @Environment(value=EnvType.CLIENT)
    public static interface Result {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00d6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\n\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\fH\u00d6\u0001\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$Result$Cancel;", "Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$Result;", "<init>", "()V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "bingo-common_client"})
        @Environment(value=EnvType.CLIENT)
        public static final class Cancel
        implements Result {
            @NotNull
            public static final Cancel INSTANCE = new Cancel();

            private Cancel() {
            }

            @NotNull
            public String toString() {
                return "Cancel";
            }

            public int hashCode() {
                return -424192032;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Cancel)) {
                    return false;
                }
                Cancel cfr_ignored_0 = (Cancel)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0010J8\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0017\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010\u000eR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010!\u001a\u0004\b\"\u0010\u0010R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010!\u001a\u0004\b#\u0010\u0010\u00a8\u0006$"}, d2={"Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$Result$Ok;", "Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$Result;", "", "cardScale", "Lme/jfenn/bingo/common/config/CardAlignment;", "cardAlignment", "", "cardOffsetX", "cardOffsetY", "<init>", "(FLme/jfenn/bingo/common/config/CardAlignment;II)V", "component1", "()F", "component2", "()Lme/jfenn/bingo/common/config/CardAlignment;", "component3", "()I", "component4", "copy", "(FLme/jfenn/bingo/common/config/CardAlignment;II)Lme/jfenn/bingo/client/common/hud/screen/BingoCardPlacementScreen$Result$Ok;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "F", "getCardScale", "Lme/jfenn/bingo/common/config/CardAlignment;", "getCardAlignment", "I", "getCardOffsetX", "getCardOffsetY", "bingo-common_client"})
        @Environment(value=EnvType.CLIENT)
        public static final class Ok
        implements Result {
            private final float cardScale;
            @NotNull
            private final CardAlignment cardAlignment;
            private final int cardOffsetX;
            private final int cardOffsetY;

            public Ok(float cardScale, @NotNull CardAlignment cardAlignment, int cardOffsetX, int cardOffsetY) {
                Intrinsics.checkNotNullParameter((Object)((Object)cardAlignment), (String)"cardAlignment");
                this.cardScale = cardScale;
                this.cardAlignment = cardAlignment;
                this.cardOffsetX = cardOffsetX;
                this.cardOffsetY = cardOffsetY;
            }

            public final float getCardScale() {
                return this.cardScale;
            }

            @NotNull
            public final CardAlignment getCardAlignment() {
                return this.cardAlignment;
            }

            public final int getCardOffsetX() {
                return this.cardOffsetX;
            }

            public final int getCardOffsetY() {
                return this.cardOffsetY;
            }

            public final float component1() {
                return this.cardScale;
            }

            @NotNull
            public final CardAlignment component2() {
                return this.cardAlignment;
            }

            public final int component3() {
                return this.cardOffsetX;
            }

            public final int component4() {
                return this.cardOffsetY;
            }

            @NotNull
            public final Ok copy(float cardScale, @NotNull CardAlignment cardAlignment, int cardOffsetX, int cardOffsetY) {
                Intrinsics.checkNotNullParameter((Object)((Object)cardAlignment), (String)"cardAlignment");
                return new Ok(cardScale, cardAlignment, cardOffsetX, cardOffsetY);
            }

            public static /* synthetic */ Ok copy$default(Ok ok, float f, CardAlignment cardAlignment, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    f = ok.cardScale;
                }
                if ((n3 & 2) != 0) {
                    cardAlignment = ok.cardAlignment;
                }
                if ((n3 & 4) != 0) {
                    n = ok.cardOffsetX;
                }
                if ((n3 & 8) != 0) {
                    n2 = ok.cardOffsetY;
                }
                return ok.copy(f, cardAlignment, n, n2);
            }

            @NotNull
            public String toString() {
                return "Ok(cardScale=" + this.cardScale + ", cardAlignment=" + this.cardAlignment + ", cardOffsetX=" + this.cardOffsetX + ", cardOffsetY=" + this.cardOffsetY + ")";
            }

            public int hashCode() {
                int result = Float.hashCode(this.cardScale);
                result = result * 31 + this.cardAlignment.hashCode();
                result = result * 31 + Integer.hashCode(this.cardOffsetX);
                result = result * 31 + Integer.hashCode(this.cardOffsetY);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Ok)) {
                    return false;
                }
                Ok ok = (Ok)other;
                if (Float.compare(this.cardScale, ok.cardScale) != 0) {
                    return false;
                }
                if (this.cardAlignment != ok.cardAlignment) {
                    return false;
                }
                if (this.cardOffsetX != ok.cardOffsetX) {
                    return false;
                }
                return this.cardOffsetY == ok.cardOffsetY;
            }
        }
    }
}

