/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.client.common.settings;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.bingo.client.common.packet.ClientPacketEvents;
import me.jfenn.bingo.client.common.settings.ClientSettingsService;
import me.jfenn.bingo.client.platform.ClientPacket;
import me.jfenn.bingo.client.platform.event.model.ClientServerEvent;
import me.jfenn.bingo.common.config.PlayerSettings;
import me.jfenn.bingo.platform.event.IEventBus;
import me.jfenn.bingo.platform.event.IReturnEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\rR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lme/jfenn/bingo/client/common/settings/ClientSettingsController;", "", "Lorg/slf4j/Logger;", "log", "Lme/jfenn/bingo/client/common/settings/ClientSettingsService;", "clientSettings", "Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;", "packetEvents", "Lme/jfenn/bingo/platform/event/IEventBus;", "eventBus", "<init>", "(Lorg/slf4j/Logger;Lme/jfenn/bingo/client/common/settings/ClientSettingsService;Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;Lme/jfenn/bingo/platform/event/IEventBus;)V", "Lorg/slf4j/Logger;", "Lme/jfenn/bingo/client/common/settings/ClientSettingsService;", "Lme/jfenn/bingo/client/common/packet/ClientPacketEvents;", "bingo-common_client"})
@Environment(value=EnvType.CLIENT)
public final class ClientSettingsController {
    @NotNull
    private final Logger log;
    @NotNull
    private final ClientSettingsService clientSettings;
    @NotNull
    private final ClientPacketEvents packetEvents;

    public ClientSettingsController(@NotNull Logger log, @NotNull ClientSettingsService clientSettings, @NotNull ClientPacketEvents packetEvents, @NotNull IEventBus eventBus) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)clientSettings, (String)"clientSettings");
        Intrinsics.checkNotNullParameter((Object)packetEvents, (String)"packetEvents");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.log = log;
        this.clientSettings = clientSettings;
        this.packetEvents = packetEvents;
        eventBus.register((IReturnEvent)this.packetEvents.getReceivePlayerSettingsV1(), arg_0 -> ClientSettingsController._init_$lambda$0(this, arg_0));
        eventBus.register((IReturnEvent)this.packetEvents.getReceivePlayerSettingsV2(), arg_0 -> ClientSettingsController._init_$lambda$1(this, arg_0));
        eventBus.register(ClientServerEvent.ChannelRegister.INSTANCE, arg_0 -> ClientSettingsController._init_$lambda$2(this, arg_0));
    }

    private static final Unit _init_$lambda$0(ClientSettingsController this$0, ClientPacket clientPacket) {
        Intrinsics.checkNotNullParameter((Object)clientPacket, (String)"<destruct>");
        PlayerSettings packet = (PlayerSettings)clientPacket.component1();
        this$0.log.debug("[ClientSettingsController] Received a settings update (v1) from the server...");
        this$0.clientSettings.update(packet, false);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ClientSettingsController this$0, ClientPacket clientPacket) {
        Intrinsics.checkNotNullParameter((Object)clientPacket, (String)"<destruct>");
        PlayerSettings packet = (PlayerSettings)clientPacket.component1();
        this$0.log.debug("[ClientSettingsController] Received a settings update (v2) from the server...");
        this$0.clientSettings.update(packet, false);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ClientSettingsController this$0, ClientServerEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.log.debug("[ClientSettingsController] Sending initial settings to the server...");
        PlayerSettings settings = this$0.clientSettings.getSettings();
        if (this$0.packetEvents.getSendPlayerSettingsV2().send(settings) || this$0.packetEvents.getSendPlayerSettingsV1().send(settings)) {
            // empty if block
        }
        return Unit.INSTANCE;
    }
}

