/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.chat;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.chat.ChatMessageService;
import me.jfenn.bingo.common.chat.CoordsCommand$CoordinatesEntry$;
import me.jfenn.bingo.common.commands.CommonKt;
import me.jfenn.bingo.common.scope.BingoComponent;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.BingoTeam;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.common.utils.BlockPositionSerializer;
import me.jfenn.bingo.common.utils.DurationKt;
import me.jfenn.bingo.common.utils.InstantSerializer;
import me.jfenn.bingo.koin.core.parameter.ParametersHolder;
import me.jfenn.bingo.koin.core.qualifier.Qualifier;
import me.jfenn.bingo.koin.core.scope.Scope;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.block.BlockPosition;
import me.jfenn.bingo.platform.commands.CommandArgument;
import me.jfenn.bingo.platform.commands.CommandBuilder;
import me.jfenn.bingo.platform.commands.ICommandManager;
import me.jfenn.bingo.platform.commands.IExecutionContext;
import me.jfenn.bingo.platform.commands.IExecutionSource;
import me.jfenn.bingo.platform.commands.ISignedMessage;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000e\u001a\u00020\r*\u00020\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0010\u001a\u00020\r*\u00020\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0015\u001a\u00020\t*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lme/jfenn/bingo/common/chat/CoordsCommand;", "Lme/jfenn/bingo/common/scope/BingoComponent;", "Lme/jfenn/bingo/platform/commands/ICommandManager;", "commandManager", "<init>", "(Lme/jfenn/bingo/platform/commands/ICommandManager;)V", "Lme/jfenn/bingo/platform/commands/IExecutionContext;", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "Lme/jfenn/bingo/common/team/BingoTeam;", "team", "Lme/jfenn/bingo/platform/commands/ISignedMessage;", "message", "", "storeCoordinates", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/team/BingoTeam;Lme/jfenn/bingo/platform/commands/ISignedMessage;)V", "listCoordinates", "(Lme/jfenn/bingo/platform/commands/IExecutionContext;Lme/jfenn/bingo/platform/IPlayerHandle;Lme/jfenn/bingo/common/team/BingoTeam;)V", "Lme/jfenn/bingo/platform/commands/IExecutionSource;", "getTeamOrThrow", "(Lme/jfenn/bingo/platform/commands/IExecutionSource;)Lme/jfenn/bingo/common/team/BingoTeam;", "teamOrThrow", "CoordinatesEntry", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nCoordsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordsCommand.kt\nme/jfenn/bingo/common/chat/CoordsCommand\n+ 2 Scope.kt\norg/koin/core/scope/Scope\n*L\n1#1,128:1\n138#2,5:129\n138#2,5:134\n138#2,5:139\n138#2,5:144\n138#2,5:149\n*S KotlinDebug\n*F\n+ 1 CoordsCommand.kt\nme/jfenn/bingo/common/chat/CoordsCommand\n*L\n51#1:129,5\n65#1:134,5\n75#1:139,5\n93#1:144,5\n103#1:149,5\n*E\n"})
public final class CoordsCommand
extends BingoComponent {
    public CoordsCommand(@NotNull ICommandManager commandManager) {
        Intrinsics.checkNotNullParameter((Object)commandManager, (String)"commandManager");
        commandManager.register("coords", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> CoordsCommand._init_$lambda$0(this, arg_0)));
    }

    private final void storeCoordinates(IExecutionContext $this$storeCoordinates, IPlayerHandle player, BingoTeam team, ISignedMessage message) {
        Scope $this$iv = $this$storeCoordinates.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        TextProvider text = (TextProvider)$this$iv.get(Reflection.getOrCreateKotlinClass(TextProvider.class), qualifier$iv, parameters$iv);
        String string = player.getPlayerName();
        BlockPosition blockPosition = player.getBlockPos();
        String string2 = StringsKt.removePrefix((String)StringsKt.substringAfter$default((String)player.getWorld().getIdentifier(), (char)':', null, (int)2, null), (CharSequence)"the_");
        ISignedMessage iSignedMessage = message;
        String string3 = iSignedMessage != null ? iSignedMessage.getRaw() : null;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        CoordinatesEntry entry = new CoordinatesEntry(string, blockPosition, string2, string3, instant);
        team.getChatCoordinates().add(entry);
        Scope $this$iv2 = $this$storeCoordinates.getScope();
        Qualifier qualifier$iv2 = null;
        Function0<? extends ParametersHolder> parameters$iv2 = null;
        boolean $i$f$get2 = false;
        ChatMessageService chatMessageService = (ChatMessageService)$this$iv2.get(Reflection.getOrCreateKotlinClass(ChatMessageService.class), qualifier$iv2, parameters$iv2);
        if (message != null) {
            ISignedMessage signedMessage = message.withUnsignedContent(text.literal(entry.formatText()));
            v6 = chatMessageService.sendTeamMessage(signedMessage, player);
        } else {
            v6 = chatMessageService.sendTeamMessage(text.literal(entry.formatText()), player);
        }
    }

    private final void listCoordinates(IExecutionContext $this$listCoordinates, IPlayerHandle player, BingoTeam team) {
        Object object;
        Scope $this$iv = $this$listCoordinates.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        TextProvider text = (TextProvider)$this$iv.get(Reflection.getOrCreateKotlinClass(TextProvider.class), qualifier$iv, parameters$iv);
        List<CoordinatesEntry> coordMessages = team.getChatCoordinates();
        if (coordMessages.isEmpty()) {
            object = new class_124[]{class_124.field_1080};
            player.sendMessage(text.literal("No coordinates have been saved yet.").formatted((class_124[])object));
            return;
        }
        object = new class_124[]{class_124.field_1080, class_124.field_1067};
        player.sendMessage(text.literal("Coordinates:").formatted((class_124[])object));
        for (CoordinatesEntry entry : coordMessages) {
            Duration duration2 = Duration.between(entry.getCreated(), Instant.now());
            String string = entry.getPlayer();
            Intrinsics.checkNotNull((Object)duration2);
            class_124[] class_124Array = new class_124[]{class_124.field_1080};
            player.sendMessage(text.literal("  \u2022 " + string + " (" + DurationKt.formatStringSmall(duration2) + " ago): " + entry.formatText()).formatted(class_124Array));
        }
    }

    private final BingoTeam getTeamOrThrow(IExecutionSource $this$teamOrThrow) {
        Scope $this$iv = $this$teamOrThrow.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        BingoTeam bingoTeam = ((TeamService)$this$iv.get(Reflection.getOrCreateKotlinClass(TeamService.class), qualifier$iv, parameters$iv)).getPlayerTeam($this$teamOrThrow.getPlayerOrThrow());
        if (bingoTeam == null) {
            class_5250 class_52502 = class_2561.method_43470((String)"Player must be on a team!");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
            class_5250 class_52503 = class_52502;
            throw new IllegalStateException(class_52503.toString());
        }
        return bingoTeam;
    }

    private static final Unit _init_$lambda$0(CoordsCommand this$0, CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.requires((Function1<? super IExecutionSource, Boolean>)((Function1)CoordsCommand::lambda$0$0));
        $this$register.literal("list", (Function1<? super CommandBuilder, Unit>)((Function1)arg_0 -> CoordsCommand.lambda$0$1(this$0, arg_0)));
        $this$register.signedMessage("message", (Function2<? super CommandBuilder, ? super CommandArgument<CompletableFuture<ISignedMessage>>, Unit>)((Function2)(arg_0, arg_1) -> CoordsCommand.lambda$0$2(this$0, arg_0, arg_1)));
        $this$register.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> CoordsCommand.lambda$0$3(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean lambda$0$0(IExecutionSource $this$requires) {
        Intrinsics.checkNotNullParameter((Object)$this$requires, (String)"$this$requires");
        GameState[] gameStateArray = new GameState[]{GameState.PLAYING, GameState.POSTGAME};
        if (!CommonKt.hasState($this$requires, gameStateArray)) return false;
        if (!CommonKt.hasPermission($this$requires, Permission.INSTANCE.getCOMMAND_COORDS())) return false;
        Scope $this$iv = $this$requires.getScope();
        Qualifier qualifier$iv = null;
        Function0<? extends ParametersHolder> parameters$iv = null;
        boolean $i$f$get = false;
        if (!((TeamService)$this$iv.get(Reflection.getOrCreateKotlinClass(TeamService.class), qualifier$iv, parameters$iv)).isPlaying($this$requires.getPlayerOrThrow())) return false;
        return true;
    }

    private static final Unit lambda$0$1(CoordsCommand this$0, CommandBuilder $this$literal) {
        Intrinsics.checkNotNullParameter((Object)$this$literal, (String)"$this$literal");
        $this$literal.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> CoordsCommand.lambda$0$1$0(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1$0(CoordsCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.listCoordinates($this$executes, $this$executes.getPlayerOrThrow(), this$0.getTeamOrThrow($this$executes));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2(CoordsCommand this$0, CommandBuilder $this$signedMessage, CommandArgument message) {
        Intrinsics.checkNotNullParameter((Object)$this$signedMessage, (String)"$this$signedMessage");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        $this$signedMessage.executes((Function1<? super IExecutionContext, Unit>)((Function1)arg_0 -> CoordsCommand.lambda$0$2$0(this$0, message, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2$0(CoordsCommand this$0, CommandArgument $message, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        IPlayerHandle player = $this$executes.getPlayerOrThrow();
        BingoTeam team = this$0.getTeamOrThrow($this$executes);
        ((CompletableFuture)$this$executes.getArgument($message)).thenAccept(arg_0 -> CoordsCommand.lambda$0$2$0$1(arg_0 -> CoordsCommand.lambda$0$2$0$0(this$0, $this$executes, player, team, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2$0$0(CoordsCommand this$0, IExecutionContext $this_executes, IPlayerHandle $player, BingoTeam $team, ISignedMessage it) {
        this$0.storeCoordinates($this_executes, $player, $team, it);
        return Unit.INSTANCE;
    }

    private static final void lambda$0$2$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit lambda$0$3(CoordsCommand this$0, IExecutionContext $this$executes) {
        Intrinsics.checkNotNullParameter((Object)$this$executes, (String)"$this$executes");
        this$0.storeCoordinates($this$executes, $this$executes.getPlayerOrThrow(), this$0.getTeamOrThrow($this$executes), null);
        return Unit.INSTANCE;
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0087\b\u0018\u0000 :2\u00020\u0001:\u0002;:BW\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0019\u0010\t\u001a\u00150\u0004j\u0002`\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\b\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002\u0012\u0019\u0010\u000f\u001a\u00150\fj\u0002`\r\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011BM\b\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u0018J#\u0010\u001a\u001a\u00150\u0004j\u0002`\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\bH\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u0018J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u0018J#\u0010\u001e\u001a\u00150\fj\u0002`\r\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\u000eH\u00c6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJj\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u001b\b\u0002\u0010\t\u001a\u00150\u0004j\u0002`\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u00022\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u001b\b\u0002\u0010\u000f\u001a\u00150\fj\u0002`\r\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\u000eH\u00c6\u0001\u00a2\u0006\u0004\b \u0010!J\u001a\u0010$\u001a\u00020#2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b&\u0010'J\u0010\u0010(\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b(\u0010\u0018J'\u00101\u001a\u00020.2\u0006\u0010)\u001a\u00020\u00002\u0006\u0010+\u001a\u00020*2\u0006\u0010-\u001a\u00020,H\u0001\u00a2\u0006\u0004\b/\u00100R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00102\u001a\u0004\b3\u0010\u0018R*\u0010\t\u001a\u00150\u0004j\u0002`\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u00104\u001a\u0004\b5\u0010\u001bR\u0017\u0010\n\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u00102\u001a\u0004\b6\u0010\u0018R\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u00102\u001a\u0004\b7\u0010\u0018R*\u0010\u000f\u001a\u00150\fj\u0002`\r\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\t0\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u00108\u001a\u0004\b9\u0010\u001f\u00a8\u0006<"}, d2={"Lme/jfenn/bingo/common/chat/CoordsCommand$CoordinatesEntry;", "", "", "player", "Lme/jfenn/bingo/platform/block/BlockPosition;", "Lme/jfenn/bingo/common/utils/BlockPositionType;", "Lkotlinx/serialization/Serializable;", "with", "Lme/jfenn/bingo/common/utils/BlockPositionSerializer;", "pos", "dimension", "message", "Ljava/time/Instant;", "Lme/jfenn/bingo/common/utils/InstantType;", "Lme/jfenn/bingo/common/utils/InstantSerializer;", "created", "<init>", "(Ljava/lang/String;Lme/jfenn/bingo/platform/block/BlockPosition;Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;)V", "", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(ILjava/lang/String;Lme/jfenn/bingo/platform/block/BlockPosition;Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "formatText", "()Ljava/lang/String;", "component1", "component2", "()Lme/jfenn/bingo/platform/block/BlockPosition;", "component3", "component4", "component5", "()Ljava/time/Instant;", "copy", "(Ljava/lang/String;Lme/jfenn/bingo/platform/block/BlockPosition;Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;)Lme/jfenn/bingo/common/chat/CoordsCommand$CoordinatesEntry;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self$bingo_common", "(Lme/jfenn/bingo/common/chat/CoordsCommand$CoordinatesEntry;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "write$Self", "Ljava/lang/String;", "getPlayer", "Lme/jfenn/bingo/platform/block/BlockPosition;", "getPos", "getDimension", "getMessage", "Ljava/time/Instant;", "getCreated", "Companion", "$serializer", "bingo-common"})
    @SourceDebugExtension(value={"SMAP\nCoordsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordsCommand.kt\nme/jfenn/bingo/common/chat/CoordsCommand$CoordinatesEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
    public static final class CoordinatesEntry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String player;
        @NotNull
        private final BlockPosition pos;
        @NotNull
        private final String dimension;
        @Nullable
        private final String message;
        @NotNull
        private final Instant created;

        public CoordinatesEntry(@NotNull String player, @NotNull BlockPosition pos, @NotNull String dimension, @Nullable String message, @NotNull Instant created) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            Intrinsics.checkNotNullParameter((Object)created, (String)"created");
            this.player = player;
            this.pos = pos;
            this.dimension = dimension;
            this.message = message;
            this.created = created;
        }

        @NotNull
        public final String getPlayer() {
            return this.player;
        }

        @NotNull
        public final BlockPosition getPos() {
            return this.pos;
        }

        @NotNull
        public final String getDimension() {
            return this.dimension;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final Instant getCreated() {
            return this.created;
        }

        @NotNull
        public final String formatText() {
            String string;
            String string2;
            BlockPosition $this$formatText_u24lambda_u240 = this.pos;
            boolean $i$a$-with-CoordsCommand$CoordinatesEntry$formatText$22 = false;
            String $i$a$-with-CoordsCommand$CoordinatesEntry$formatText$22 = string2 = "(" + this.dimension + ") ";
            String string3 = "[" + $this$formatText_u24lambda_u240.getX() + ", " + $this$formatText_u24lambda_u240.getY() + ", " + $this$formatText_u24lambda_u240.getZ() + "] ";
            boolean bl = false;
            boolean bl2 = !Intrinsics.areEqual((Object)this.dimension, (Object)"overworld");
            Object object = bl2 ? string2 : null;
            if (object == null) {
                object = "";
            }
            if ((string = this.message) == null) {
                string = "";
            }
            return string3 + (String)object + string;
        }

        @NotNull
        public final String component1() {
            return this.player;
        }

        @NotNull
        public final BlockPosition component2() {
            return this.pos;
        }

        @NotNull
        public final String component3() {
            return this.dimension;
        }

        @Nullable
        public final String component4() {
            return this.message;
        }

        @NotNull
        public final Instant component5() {
            return this.created;
        }

        @NotNull
        public final CoordinatesEntry copy(@NotNull String player, @NotNull BlockPosition pos, @NotNull String dimension, @Nullable String message, @NotNull Instant created) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            Intrinsics.checkNotNullParameter((Object)created, (String)"created");
            return new CoordinatesEntry(player, pos, dimension, message, created);
        }

        public static /* synthetic */ CoordinatesEntry copy$default(CoordinatesEntry coordinatesEntry, String string, BlockPosition blockPosition, String string2, String string3, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                string = coordinatesEntry.player;
            }
            if ((n & 2) != 0) {
                blockPosition = coordinatesEntry.pos;
            }
            if ((n & 4) != 0) {
                string2 = coordinatesEntry.dimension;
            }
            if ((n & 8) != 0) {
                string3 = coordinatesEntry.message;
            }
            if ((n & 0x10) != 0) {
                instant = coordinatesEntry.created;
            }
            return coordinatesEntry.copy(string, blockPosition, string2, string3, instant);
        }

        @NotNull
        public String toString() {
            return "CoordinatesEntry(player=" + this.player + ", pos=" + this.pos + ", dimension=" + this.dimension + ", message=" + this.message + ", created=" + this.created + ")";
        }

        public int hashCode() {
            int result = this.player.hashCode();
            result = result * 31 + this.pos.hashCode();
            result = result * 31 + this.dimension.hashCode();
            result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
            result = result * 31 + this.created.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CoordinatesEntry)) {
                return false;
            }
            CoordinatesEntry coordinatesEntry = (CoordinatesEntry)other;
            if (!Intrinsics.areEqual((Object)this.player, (Object)coordinatesEntry.player)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pos, (Object)coordinatesEntry.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dimension, (Object)coordinatesEntry.dimension)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)coordinatesEntry.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.created, (Object)coordinatesEntry.created);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$bingo_common(CoordinatesEntry self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.player);
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)BlockPositionSerializer.INSTANCE, (Object)self.pos);
            output.encodeStringElement(serialDesc, 2, self.dimension);
            output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.message);
            output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)InstantSerializer.INSTANCE, (Object)self.created);
        }

        public /* synthetic */ CoordinatesEntry(int seen0, String player, BlockPosition pos, String dimension, String message, Instant created, SerializationConstructorMarker serializationConstructorMarker) {
            if (31 != (0x1F & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)31, (SerialDescriptor)CoordinatesEntry$$serializer.INSTANCE.getDescriptor());
            }
            this.player = player;
            this.pos = pos;
            this.dimension = dimension;
            this.message = message;
            this.created = created;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/jfenn/bingo/common/chat/CoordsCommand$CoordinatesEntry$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lme/jfenn/bingo/common/chat/CoordsCommand$CoordinatesEntry;", "serializer", "()Lkotlinx/serialization/KSerializer;", "bingo-common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<CoordinatesEntry> serializer() {
                return (KSerializer)CoordinatesEntry$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

