/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.bingo.common.ready;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.bingo.common.Permission;
import me.jfenn.bingo.common.config.BingoConfig;
import me.jfenn.bingo.common.ready.ReadyResult;
import me.jfenn.bingo.common.ready.ReadyTimerState;
import me.jfenn.bingo.common.state.BingoState;
import me.jfenn.bingo.common.state.GameState;
import me.jfenn.bingo.common.team.TeamService;
import me.jfenn.bingo.common.text.TextProvider;
import me.jfenn.bingo.generated.StringKey;
import me.jfenn.bingo.integrations.permissions.IPermissionsApi;
import me.jfenn.bingo.platform.IPlayerHandle;
import me.jfenn.bingo.platform.IPlayerManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0019\u0010\u0018J\r\u0010\u001a\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\r\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010\"\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010$\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b$\u0010%J\r\u0010&\u001a\u00020\u001d\u00a2\u0006\u0004\b&\u0010\u001fJ\r\u0010'\u001a\u00020\u001d\u00a2\u0006\u0004\b'\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010(R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010)R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010*R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010+R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010,R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010-R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010.R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010/\u00a8\u00060"}, d2={"Lme/jfenn/bingo/common/ready/ReadyService;", "", "Lme/jfenn/bingo/common/state/BingoState;", "state", "Lme/jfenn/bingo/common/team/TeamService;", "teamService", "Lme/jfenn/bingo/common/config/BingoConfig;", "config", "Lme/jfenn/bingo/common/ready/ReadyTimerState;", "readyTimerState", "Lme/jfenn/bingo/platform/IPlayerManager;", "playerManager", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "permissions", "Lme/jfenn/bingo/common/text/TextProvider;", "text", "Lorg/slf4j/Logger;", "log", "<init>", "(Lme/jfenn/bingo/common/state/BingoState;Lme/jfenn/bingo/common/team/TeamService;Lme/jfenn/bingo/common/config/BingoConfig;Lme/jfenn/bingo/common/ready/ReadyTimerState;Lme/jfenn/bingo/platform/IPlayerManager;Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;Lme/jfenn/bingo/common/text/TextProvider;Lorg/slf4j/Logger;)V", "Lme/jfenn/bingo/platform/IPlayerHandle;", "player", "", "isReadyEnabled", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Z", "canUseReady", "isFirstVoteSatisfied", "()Z", "isConditionSatisfied", "", "startTimer", "()V", "isReady", "Lme/jfenn/bingo/common/ready/ReadyResult;", "setReady", "(Lme/jfenn/bingo/platform/IPlayerHandle;Z)Lme/jfenn/bingo/common/ready/ReadyResult;", "toggleReady", "(Lme/jfenn/bingo/platform/IPlayerHandle;)Lme/jfenn/bingo/common/ready/ReadyResult;", "tick", "reset", "Lme/jfenn/bingo/common/state/BingoState;", "Lme/jfenn/bingo/common/team/TeamService;", "Lme/jfenn/bingo/common/config/BingoConfig;", "Lme/jfenn/bingo/common/ready/ReadyTimerState;", "Lme/jfenn/bingo/platform/IPlayerManager;", "Lme/jfenn/bingo/integrations/permissions/IPermissionsApi;", "Lme/jfenn/bingo/common/text/TextProvider;", "Lorg/slf4j/Logger;", "bingo-common"})
@SourceDebugExtension(value={"SMAP\nReadyService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadyService.kt\nme/jfenn/bingo/common/ready/ReadyService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Duration.kt\nme/jfenn/bingo/common/utils/DurationKt\n*L\n1#1,130:1\n1761#2,3:131\n827#2:134\n855#2,2:135\n1740#2,3:137\n1869#2,2:141\n65#3:140\n*S KotlinDebug\n*F\n+ 1 ReadyService.kt\nme/jfenn/bingo/common/ready/ReadyService\n*L\n49#1:131,3\n55#1:134\n55#1:135,2\n56#1:137,3\n126#1:141,2\n73#1:140\n*E\n"})
public final class ReadyService {
    @NotNull
    private final BingoState state;
    @NotNull
    private final TeamService teamService;
    @NotNull
    private final BingoConfig config;
    @NotNull
    private final ReadyTimerState readyTimerState;
    @NotNull
    private final IPlayerManager playerManager;
    @NotNull
    private final IPermissionsApi permissions;
    @NotNull
    private final TextProvider text;
    @NotNull
    private final Logger log;

    public ReadyService(@NotNull BingoState state, @NotNull TeamService teamService, @NotNull BingoConfig config, @NotNull ReadyTimerState readyTimerState, @NotNull IPlayerManager playerManager, @NotNull IPermissionsApi permissions, @NotNull TextProvider text, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)teamService, (String)"teamService");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)readyTimerState, (String)"readyTimerState");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.state = state;
        this.teamService = teamService;
        this.config = config;
        this.readyTimerState = readyTimerState;
        this.playerManager = playerManager;
        this.permissions = permissions;
        this.text = text;
        this.log = log;
    }

    public final boolean isReadyEnabled(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean isLobbyMode = this.state.isLobbyMode();
        boolean isPregameCountdown = this.state.getState() == GameState.PREGAME && this.config.getStartWhenReadySeconds() != null;
        boolean isPostgameCountdown = this.state.getState() == GameState.POSTGAME && this.config.getNextRoundWhenReadySeconds() != null;
        boolean isPermission = this.permissions.hasPermission(player, Permission.INSTANCE.getCOMMAND_READY());
        return isLobbyMode && (isPregameCountdown || isPostgameCountdown) && isPermission;
    }

    public final boolean canUseReady(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean isPostgameCountdown = this.state.getState() == GameState.POSTGAME && this.config.getNextRoundWhenReadySeconds() != null;
        boolean isTeamChosen = !this.config.getStartWhenReadyWaitsForTeams() || this.playerManager.getPlayers().size() == 1 || this.teamService.isPlaying(player) || this.state.getPlayersSpectatingIds().contains(player.getUuid()) || isPostgameCountdown;
        return this.isReadyEnabled(player) && isTeamChosen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFirstVoteSatisfied() {
        IPlayerHandle it;
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.getState().ordinal()]) {
            case 1: {
                if (!this.config.getStartWhenReadyWaitsForFirstVote()) {
                    return true;
                }
                bl = false;
                break;
            }
            case 2: {
                if (!this.config.getNextRoundWhenReadyWaitsForFirstVote()) {
                    return true;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) return true;
        Iterable $this$any$iv = this.playerManager.getPlayers();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (IPlayerHandle)element$iv;
            boolean bl2 = false;
        } while (!this.readyTimerState.isReady(it.getUuid()));
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isConditionSatisfied() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.getState().ordinal()]) {
            case 1: {
                List<IPlayerHandle> players = this.playerManager.getPlayers();
                if (this.config.getStartWhenReadyWaitsForTeams()) {
                    boolean bl;
                    void $this$filterNotTo$iv$iv;
                    Iterable $this$filterNot$iv = players;
                    boolean $i$f$filterNot = false;
                    Iterable iterable = $this$filterNot$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                        IPlayerHandle it = (IPlayerHandle)element$iv$iv;
                        boolean bl2 = false;
                        if (this.state.getPlayersSpectatingIds().contains(it.getPlayer().method_5667())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$all$iv = (List)destination$iv$iv;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            IPlayerHandle it = (IPlayerHandle)element$iv;
                            boolean bl3 = false;
                            if (this.teamService.isPlaying(it)) continue;
                            return false;
                        }
                        bl = true;
                    }
                    if (!bl) return false;
                }
                boolean bl = true;
                boolean isTeams = bl;
                if (!isTeams) return false;
                if (players.size() <= 1) return false;
                if (!this.state.getOptions().isValid()) return false;
                return true;
            }
            case 2: {
                return true;
            }
            default: {
                return false;
            }
        }
    }

    public final void startTimer() {
        Integer duration2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.getState().ordinal()]) {
            case 1: {
                Integer n = this.config.getStartWhenReadySeconds();
                break;
            }
            case 2: {
                Integer n = this.config.getNextRoundWhenReadySeconds();
                break;
            }
            default: {
                Integer n = duration2 = null;
            }
        }
        if (duration2 != null) {
            this.log.info("[ReadyService] Starting the " + this.state.getState() + " timer for " + duration2 + " seconds");
            int $this$seconds$iv = duration2;
            boolean $i$f$getSeconds = false;
            Duration duration3 = Duration.ofSeconds($this$seconds$iv);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(...)");
            this.readyTimerState.startTimer(duration3);
        }
    }

    @NotNull
    public final ReadyResult setReady(@NotNull IPlayerHandle player, boolean isReady) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.canUseReady(player)) {
            Object[] objectArray = new Object[]{"/join spectators"};
            return new ReadyResult.Failed(this.text.string(StringKey.CommandReadyNotOnATeam, objectArray));
        }
        if (isReady && !this.readyTimerState.isRunning() && this.isConditionSatisfied()) {
            this.startTimer();
        }
        if (!this.readyTimerState.isRunning()) {
            return new ReadyResult.Failed(this.text.string(StringKey.CommandReadyNotRunning));
        }
        this.readyTimerState.setReady(player.getUuid(), isReady);
        this.playerManager.updatePlayerListName(player);
        Object[] objectArray = new Object[]{player.getPlayerName()};
        return new ReadyResult.ChangedTo(isReady, this.text.string(isReady ? StringKey.CommandReadyTrue : StringKey.CommandReadyFalse, objectArray));
    }

    @NotNull
    public final ReadyResult toggleReady(@NotNull IPlayerHandle player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean isReady = !this.readyTimerState.isReady(player.getUuid());
        return this.setReady(player, isReady);
    }

    public final void tick() {
        if (!this.readyTimerState.isRunning() && !this.readyTimerState.isCancelled() && this.isFirstVoteSatisfied() && this.isConditionSatisfied()) {
            this.startTimer();
        }
        if (this.readyTimerState.isRunning() && !this.isConditionSatisfied()) {
            this.log.info("[ReadyService] Cancelling the " + this.state.getState() + " timer, as players are not ready");
            this.reset();
        }
    }

    public final void reset() {
        this.readyTimerState.reset();
        Iterable $this$forEach$iv = this.playerManager.getPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IPlayerHandle player = (IPlayerHandle)element$iv;
            boolean bl = false;
            this.playerManager.updatePlayerListName(player);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GameState.values().length];
            try {
                nArray[GameState.PREGAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameState.POSTGAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

