/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.selector;

import com.bawnorton.mixinsquared.TargetHandler;
import com.bawnorton.mixinsquared.reflection.AnnotatedMixinExtension;
import java.util.List;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.selectors.ElementNode;
import org.spongepowered.asm.mixin.injection.selectors.ISelectorContext;
import org.spongepowered.asm.mixin.injection.selectors.ITargetSelector;
import org.spongepowered.asm.mixin.injection.selectors.ITargetSelectorDynamic;
import org.spongepowered.asm.mixin.injection.selectors.InvalidSelectorException;
import org.spongepowered.asm.mixin.injection.selectors.MatchResult;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.mixin.struct.SpecialMethodInfo;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.asm.IAnnotatedElement;
import org.spongepowered.asm.util.asm.IAnnotationHandle;
import org.spongepowered.asm.util.asm.MethodNodeEx;
import org.spongepowered.tools.obfuscation.ObfuscationData;
import org.spongepowered.tools.obfuscation.interfaces.IObfuscationManager;
import org.spongepowered.tools.obfuscation.interfaces.IReferenceManager;
import org.spongepowered.tools.obfuscation.interfaces.ITypeHandleProvider;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;

@ITargetSelectorDynamic.SelectorId(value="Handler")
public final class DynamicSelectorHandler
implements ITargetSelectorDynamic {
    private final String mixinName;
    private final String name;
    private final String desc;
    private final String prefix;
    private final boolean print;

    public DynamicSelectorHandler(String mixinName, MemberInfo memberInfo, String prefix, boolean print) {
        this.mixinName = mixinName;
        this.name = memberInfo.getName();
        this.desc = memberInfo.getDesc();
        this.prefix = prefix == null ? null : (prefix.isEmpty() ? null : prefix);
        this.print = print;
    }

    public static DynamicSelectorHandler parse(String input, ISelectorContext context) {
        if (context.getMethod() instanceof MethodNode) {
            MethodNode method = (MethodNode)context.getMethod();
            AnnotationNode annotationNode = Annotations.getVisible((MethodNode)method, TargetHandler.class);
            return DynamicSelectorHandler.parseRuntime(annotationNode, context);
        }
        if (context.getMethod() instanceof IAnnotatedElement) {
            IAnnotatedElement element = (IAnnotatedElement)context.getMethod();
            return DynamicSelectorHandler.parseCompileTime(element, context);
        }
        throw new AssertionError((Object)"Could not get annotation for method");
    }

    private static DynamicSelectorHandler parseCompileTime(IAnnotatedElement element, ISelectorContext context) {
        IAnnotationHandle annotation = element.getAnnotation(TargetHandler.class);
        String name = (String)annotation.getValue("name");
        MemberInfo memberInfo = MemberInfo.parse((String)name, (ISelectorContext)context);
        String mixin = (String)annotation.getValue("mixin");
        if (memberInfo.getDesc() != null) {
            AnnotatedMixinExtension.tryAs(context.getMixin()).ifPresent(extension -> {
                IObfuscationManager obfManager = extension.getObfuscationManager();
                ITypeHandleProvider typeProvider = extension.getTypeProvider();
                TypeHandle typeHandle = typeProvider.getTypeHandle(mixin);
                MappingMethod targetMethod = typeHandle.getMappingMethod(memberInfo.getName(), memberInfo.getDesc());
                ObfuscationData obfData = obfManager.getDataProvider().getObfMethod(targetMethod);
                IReferenceManager refManager = obfManager.getReferenceManager();
                refManager.addMethodMapping(context.getMixin().getClassRef(), name, obfData);
            });
        }
        String prefix = (String)annotation.getValue("prefix", (Object)"");
        boolean print = (Boolean)annotation.getValue("print", (Object)Boolean.FALSE);
        return new DynamicSelectorHandler(mixin, memberInfo, prefix, print);
    }

    private static DynamicSelectorHandler parseRuntime(AnnotationNode node, ISelectorContext context) {
        String name = (String)Annotations.getValue((AnnotationNode)node, (String)"name");
        MemberInfo memberInfo = MemberInfo.parse((String)name, (ISelectorContext)context);
        String mixin = (String)Annotations.getValue((AnnotationNode)node, (String)"mixin");
        String prefix = (String)Annotations.getValue((AnnotationNode)node, (String)"prefix", (Object)"");
        boolean print = (Boolean)Annotations.getValue((AnnotationNode)node, (String)"print", (Object)Boolean.FALSE);
        return new DynamicSelectorHandler(mixin, memberInfo, prefix, print);
    }

    public ITargetSelector next() {
        return null;
    }

    public ITargetSelector configure(ITargetSelector.Configure request, String ... args) {
        return this;
    }

    public ITargetSelector validate() throws InvalidSelectorException {
        return this;
    }

    public ITargetSelector attach(ISelectorContext context) throws InvalidSelectorException {
        ClassNode classNode;
        if (context.getMixin().getClassName().equals(this.mixinName)) {
            throw new InvalidSelectorException("Dynamic selector targets self!");
        }
        if (!this.print) {
            return this;
        }
        PrettyPrinter printer = new PrettyPrinter();
        printer.kvWidth(20);
        printer.kv("Target Mixin", (Object)this.mixinName);
        printer.kv("Target Method", (Object)this.name);
        printer.kv("Target Desc", (Object)(this.desc == null ? "None" : this.desc));
        printer.kv("Target Prefix", (Object)(this.prefix == null ? "None" : this.prefix));
        printer.kv("Print", (Object)"Print is enabled, matching disabled!");
        printer.hr();
        if (!(context instanceof SpecialMethodInfo)) {
            return this;
        }
        SpecialMethodInfo specialMethodInfo = (SpecialMethodInfo)context;
        try {
            classNode = specialMethodInfo.getTargetClassNode();
        }
        catch (NoSuchMethodError ignored) {
            classNode = specialMethodInfo.getClassNode();
        }
        List methods = classNode.methods;
        for (MethodNode method : methods) {
            if (!(method instanceof MethodNodeEx)) continue;
            MethodNodeEx methodNodeEx = (MethodNodeEx)method;
            String mixinName = methodNodeEx.getOwner().getClassName();
            String originalName = methodNodeEx.getOriginalName();
            String prefix = method.name.split("\\$")[0];
            String originalDesc = method.desc;
            printer.kv("Name", (Object)(originalName + originalDesc));
            printer.kv("Prefix", (Object)prefix);
            String candidateType = "NO";
            MatchResult matchResult = this.matchInternal(mixinName, originalName, originalDesc, prefix);
            if (matchResult == MatchResult.EXACT_MATCH) {
                candidateType = "YES";
            } else if (matchResult == MatchResult.MATCH) {
                candidateType = "PARTIAL";
            }
            printer.kv("Candidate", (Object)candidateType);
            printer.hr('-');
        }
        printer.print(System.err);
        return this;
    }

    public int getMinMatchCount() {
        return 0;
    }

    public int getMaxMatchCount() {
        return 1;
    }

    public <TNode> MatchResult match(ElementNode<TNode> node) {
        if (this.print) {
            return MatchResult.NONE;
        }
        MethodNode method = node.getMethod();
        AnnotationNode annotation = Annotations.getVisible((MethodNode)method, MixinMerged.class);
        if (annotation == null) {
            return MatchResult.NONE;
        }
        if (!(method instanceof MethodNodeEx)) {
            return MatchResult.NONE;
        }
        MethodNodeEx methodNodeEx = (MethodNodeEx)method;
        String targetMixinName = (String)Annotations.getValue((AnnotationNode)annotation, (String)"mixin");
        String originalName = methodNodeEx.getOriginalName();
        String desc = methodNodeEx.desc;
        String prefix = methodNodeEx.name.split("\\$")[0];
        return this.matchInternal(targetMixinName, originalName, desc, prefix);
    }

    private MatchResult matchInternal(String targetMixinName, String name, String desc, String prefix) {
        if (!this.mixinName.equals(targetMixinName)) {
            return MatchResult.NONE;
        }
        if (this.desc != null && desc != null && !this.desc.equals(desc)) {
            return MatchResult.NONE;
        }
        if (this.prefix != null && prefix != null && !this.prefix.equals(prefix)) {
            return MatchResult.NONE;
        }
        if (this.name.equals(name)) {
            return MatchResult.EXACT_MATCH;
        }
        if (this.name.equalsIgnoreCase(name)) {
            return MatchResult.MATCH;
        }
        return MatchResult.NONE;
    }

    public String toString() {
        return "@MixinSquared:Handler[mixin='" + this.mixinName + '\'' + ", name='" + this.name + '\'' + ", desc='" + this.desc + '\'' + ", prefix='" + this.prefix + '\'' + ']';
    }
}

