/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.gui;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.ExperimentsScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ScrollableExperimentsScreen
extends ExperimentsScreen {
    private static final int DEFAULT_LIST_HEIGHT = 121;
    private static final int ROW_PADDING = 4;
    private static final int LIST_PADDING = 38;
    private static final int ENTRY_HEIGHT = 42;
    @Nullable
    private ExperimentSelectionList selectionList;
    @Nullable
    private LinearLayout listLayout;

    public ScrollableExperimentsScreen(Screen parent, PackRepository packRepository, Consumer<PackRepository> output) {
        super(parent, packRepository, output);
    }

    protected void init() {
        this.layout.addTitleHeader(TITLE, this.font);
        LinearLayout contentLayout = (LinearLayout)this.layout.addToContents((LayoutElement)LinearLayout.vertical(), LayoutSettings::alignVerticallyTop);
        contentLayout.addChild((LayoutElement)new MultiLineTextWidget(INFO, this.font).setMaxWidth(310), settings -> settings.paddingBottom(15).alignHorizontallyCenter());
        this.listLayout = (LinearLayout)contentLayout.addChild((LayoutElement)LinearLayout.vertical());
        this.selectionList = new ExperimentSelectionList(this.minecraft);
        this.packs.forEach((pack, selected) -> this.selectionList.addEntry(new ExperimentSelectionList.ExperimentEntry(ScrollableExperimentsScreen.getHumanReadableTitle((Pack)pack), () -> this.packs.getBoolean(pack), flag -> this.packs.put(pack, flag.booleanValue()), pack.getDescription())));
        this.listLayout.addChild((LayoutElement)this.selectionList);
        LinearLayout footerLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        footerLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onDone()).build());
        footerLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, btn -> this.onClose()).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        if (this.selectionList != null) {
            this.selectionList.setHeight(121);
        }
        super.repositionElements();
        if (this.selectionList != null && this.listLayout != null) {
            this.selectionList.setHeight(this.layout.getContentHeight() - this.listLayout.getY());
            this.selectionList.setPosition(this.listLayout.getX(), this.listLayout.getY());
            this.selectionList.clampScrollAmount();
        }
    }

    private static class ExperimentSelectionList
    extends ContainerObjectSelectionList<ExperimentEntry> {
        public ExperimentSelectionList(Minecraft mc) {
            super(mc, 348, 121, 0, 42);
        }

        public int getRowWidth() {
            return 314;
        }

        protected int addEntry(ExperimentEntry entry) {
            return super.addEntry((AbstractSelectionList.Entry)entry);
        }

        private static class ExperimentEntry
        extends ContainerObjectSelectionList.Entry<ExperimentEntry> {
            private static final int BUTTON_WIDTH = 44;
            private static final int TITLE_Y = 6;
            private static final int DESCRIPTION_Y = 20;
            private final StringWidget titleWidget;
            private final MultiLineTextWidget descriptionWidget;
            private final CycleButton<Boolean> button;
            private final List<AbstractWidget> children;

            public ExperimentEntry(Component title, BooleanSupplier selectedSupplier, Consumer<Boolean> selectedSetter, Component description) {
                this.titleWidget = new StringWidget(title, Minecraft.getInstance().font).alignLeft();
                this.descriptionWidget = new MultiLineTextWidget((Component)description.copy().withStyle(ChatFormatting.GRAY), Minecraft.getInstance().font).setMaxRows(2);
                this.button = CycleButton.onOffBuilder((boolean)selectedSupplier.getAsBoolean()).displayOnlyValue().withCustomNarration(btn -> CommonComponents.joinForNarration((Component[])new Component[]{title, btn.createDefaultNarrationMessage(), description})).create(0, 0, 44, 20, (Component)Component.empty(), (btn, val) -> selectedSetter.accept((Boolean)val));
                this.children = List.of(this.titleWidget, this.descriptionWidget, this.button);
            }

            public void render(GuiGraphics graphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
                this.titleWidget.setPosition(left, top + 6);
                this.descriptionWidget.setPosition(left, top + 20);
                this.descriptionWidget.setMaxWidth(entryWidth - this.button.getWidth());
                this.button.setPosition(left + entryWidth - this.button.getWidth() - 4, top);
                this.titleWidget.render(graphics, mouseX, mouseY, partialTick);
                this.descriptionWidget.render(graphics, mouseX, mouseY, partialTick);
                this.button.render(graphics, mouseX, mouseY, partialTick);
            }

            public List<? extends GuiEventListener> children() {
                return this.children;
            }

            public List<? extends NarratableEntry> narratables() {
                return this.children;
            }
        }
    }
}

