/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.neoforged.neoforge.common.command.IEntitySelectorType;

public class EntitySelectorManager {
    private static final HashMap<String, IEntitySelectorType> REGISTRY = new HashMap();

    public static void register(String token, IEntitySelectorType type) {
        if (token.isEmpty()) {
            throw new IllegalArgumentException("Token must not be empty");
        }
        if (Arrays.asList("p", "a", "r", "s", "e").contains(token)) {
            throw new IllegalArgumentException("Token clashes with vanilla @" + token);
        }
        for (char c : token.toCharArray()) {
            if (StringReader.isAllowedInUnquotedString((char)c)) continue;
            throw new IllegalArgumentException("Token must only contain allowed characters");
        }
        REGISTRY.put(token, type);
    }

    public static EntitySelector parseSelector(EntitySelectorParser parser) throws CommandSyntaxException {
        if (parser.getReader().canRead()) {
            int i = parser.getReader().getCursor();
            String token = parser.getReader().readUnquotedString();
            IEntitySelectorType type = REGISTRY.get(token);
            if (type != null) {
                return type.build(parser);
            }
            parser.getReader().setCursor(i);
        }
        return null;
    }

    public static void fillSelectorSuggestions(SuggestionsBuilder suggestionBuilder) {
        REGISTRY.forEach((token, type) -> suggestionBuilder.suggest("@" + token, (Message)type.getSuggestionTooltip()));
    }
}

