/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.filters;

import com.google.common.collect.ImmutableMap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.Connection;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.network.filters.DynamicChannelHandler;
import net.neoforged.neoforge.network.filters.GenericPacketSplitter;
import net.neoforged.neoforge.network.filters.VanillaConnectionNetworkFilter;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NetworkFilters {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Function<ConnectionType, DynamicChannelHandler>> instances = ImmutableMap.of((Object)"neoforge:vanilla_filter", VanillaConnectionNetworkFilter::new, (Object)"neoforge:splitter", connectionType -> new GenericPacketSplitter());

    public static void injectIfNecessary(Connection manager) {
        NetworkFilters.cleanIfNecessary(manager);
        ChannelPipeline pipeline = manager.channel().pipeline();
        if (pipeline.get("encoder") == null) {
            return;
        }
        ConnectionType connectionType = NetworkRegistry.getConnectionType(manager);
        instances.forEach((key, filterFactory) -> {
            DynamicChannelHandler filter = (DynamicChannelHandler)filterFactory.apply(connectionType);
            if (filter.isNecessary(manager)) {
                pipeline.addAfter("encoder", key, (ChannelHandler)filter);
                LOGGER.debug("Injected {} into {}", (Object)filter, (Object)manager);
            }
        });
    }

    public static void cleanIfNecessary(Connection manager) {
        ChannelPipeline pipeline = manager.channel().pipeline();
        List<DynamicChannelHandler> toRemove = pipeline.names().stream().map(arg_0 -> ((ChannelPipeline)pipeline).get(arg_0)).filter(DynamicChannelHandler.class::isInstance).map(DynamicChannelHandler.class::cast).toList();
        toRemove.forEach(arg_0 -> ((ChannelPipeline)pipeline).remove(arg_0));
    }

    private NetworkFilters() {
    }
}

