/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

class DataComponentCommand {
    private static final SimpleCommandExceptionType ERROR_NO_ITEM = new SimpleCommandExceptionType((Message)Component.translatableEscape((String)"commands.neoforge.data_components.list.error.held_stack_empty", (Object[])new Object[0]));

    DataComponentCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"data_components").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"list").executes(DataComponentCommand::listComponents));
    }

    private static int listComponents(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            throw ERROR_NO_ITEM.create();
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> {
            MutableComponent text = Component.translatable((String)"commands.neoforge.data_components.list.title", (Object[])new Object[]{stack.getItem().getName(stack)});
            DataComponentMap prototype = stack.getPrototype();
            DataComponentPatch patch = stack.getComponentsPatch();
            prototype.forEach(component -> {
                Optional optData = patch.get(component.type());
                if (optData == null) {
                    MutableComponent tooltip = Component.translatable((String)"commands.neoforge.data_components.list.tooltip.default", (Object[])new Object[]{DataComponentCommand.getTypeId(component.type())});
                    text.append(DataComponentCommand.print(component.type(), component.value(), ChatFormatting.WHITE, (Component)tooltip));
                } else if (optData.isEmpty()) {
                    MutableComponent tooltip = Component.translatable((String)"commands.neoforge.data_components.list.tooltip.deleted", (Object[])new Object[]{DataComponentCommand.getTypeId(component.type()), component.value().toString()});
                    text.append(DataComponentCommand.print(component.type(), component.value(), ChatFormatting.RED, (Component)tooltip));
                } else {
                    MutableComponent tooltip = Component.translatable((String)"commands.neoforge.data_components.list.tooltip.modified", (Object[])new Object[]{DataComponentCommand.getTypeId(component.type()), component.value().toString(), optData.get().toString()});
                    text.append(DataComponentCommand.print(component.type(), optData.get(), ChatFormatting.YELLOW, (Component)tooltip));
                }
            });
            patch.entrySet().forEach(entry -> {
                if (!prototype.has((DataComponentType)entry.getKey()) && ((Optional)entry.getValue()).isPresent()) {
                    MutableComponent tooltip = Component.translatable((String)"commands.neoforge.data_components.list.tooltip.added", (Object[])new Object[]{DataComponentCommand.getTypeId((DataComponentType)entry.getKey()), ((Optional)entry.getValue()).get().toString()});
                    text.append(DataComponentCommand.print((DataComponentType)entry.getKey(), ((Optional)entry.getValue()).get(), ChatFormatting.GREEN, (Component)tooltip));
                }
            });
            return text;
        }, false);
        return 1;
    }

    private static String getTypeId(DataComponentType<?> type) {
        return Objects.requireNonNull(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(type)).toString();
    }

    private static Component print(DataComponentType<?> type, Object data, ChatFormatting color, Component tooltip) {
        MutableComponent entry = Component.translatable((String)"commands.neoforge.data_components.list.entry.key_value", (Object[])new Object[]{DataComponentCommand.getTypeId(type), data.toString()});
        return Component.translatable((String)"commands.neoforge.data_components.list.entry", (Object[])new Object[]{entry.withStyle(color)}).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)tooltip)));
    }
}

