/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.mixin.transfer.ItemContainerContentsAccessor;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9288;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public class ContainerComponentStorage
extends CombinedSlottedStorage<ItemVariant, SingleSlotStorage<ItemVariant>> {
    final ContainerItemContext ctx;
    private final class_1792 originalItem;

    public ContainerComponentStorage(ContainerItemContext ctx, int slots) {
        super(Collections.emptyList());
        this.ctx = ctx;
        this.originalItem = ctx.getItemVariant().getItem();
        ArrayList<ContainerSlotWrapper> backingList = new ArrayList<ContainerSlotWrapper>(slots);
        for (int i = 0; i < slots; ++i) {
            backingList.add(new ContainerSlotWrapper(i));
        }
        this.parts = Collections.unmodifiableList(backingList);
    }

    class_9288 container() {
        return (class_9288)this.ctx.getItemVariant().getComponentMap().method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
    }

    ItemContainerContentsAccessor containerAccessor() {
        return (ItemContainerContentsAccessor)this.container();
    }

    private boolean isStillValid() {
        return this.ctx.getItemVariant().getItem() == this.originalItem;
    }

    private class ContainerSlotWrapper
    implements SingleSlotStorage<ItemVariant> {
        final int slot;

        ContainerSlotWrapper(int slot) {
            this.slot = slot;
        }

        private class_1799 getStack() {
            class_2371<class_1799> stacks = ContainerComponentStorage.this.containerAccessor().fabric_getStacks();
            if (stacks.size() <= this.slot) {
                return class_1799.field_8037;
            }
            return (class_1799)stacks.get(this.slot);
        }

        protected boolean setStack(class_1799 stack, TransactionContext transaction) {
            List stacks = ContainerComponentStorage.this.container().method_57489().collect(Collectors.toList());
            while (stacks.size() <= this.slot) {
                stacks.add(class_1799.field_8037);
            }
            stacks.set(this.slot, stack);
            ContainerItemContext ctx = ContainerComponentStorage.this.ctx;
            ItemVariant newVariant = ctx.getItemVariant().withComponentChanges(class_9326.method_57841().method_57854(class_9334.field_49622, (Object)class_9288.method_57493(stacks)).method_57852());
            return ctx.exchange(newVariant, 1L, transaction) == 1L;
        }

        @Override
        public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            int insertedAmount;
            StoragePreconditions.notBlankNotNegative(insertedVariant, maxAmount);
            if (!ContainerComponentStorage.this.isStillValid()) {
                return 0L;
            }
            class_1799 currentStack = this.getStack();
            if ((insertedVariant.matches(currentStack) || currentStack.method_7960()) && insertedVariant.getItem().method_31568() && (insertedAmount = (int)Math.min(maxAmount, this.getCapacity() - (long)currentStack.method_7947())) > 0) {
                currentStack = this.getStack().method_7972();
                if (currentStack.method_7960()) {
                    currentStack = insertedVariant.toStack(insertedAmount);
                } else {
                    currentStack.method_7933(insertedAmount);
                }
                if (!this.setStack(currentStack, transaction)) {
                    return 0L;
                }
                return insertedAmount;
            }
            return 0L;
        }

        @Override
        public long extract(ItemVariant variant, long maxAmount, TransactionContext transaction) {
            int extracted;
            StoragePreconditions.notBlankNotNegative(variant, maxAmount);
            if (!ContainerComponentStorage.this.isStillValid()) {
                return 0L;
            }
            class_1799 currentStack = this.getStack();
            if (variant.matches(currentStack) && (extracted = (int)Math.min((long)currentStack.method_7947(), maxAmount)) > 0) {
                currentStack = this.getStack().method_7972();
                currentStack.method_7934(extracted);
                if (!this.setStack(currentStack, transaction)) {
                    return 0L;
                }
                return extracted;
            }
            return 0L;
        }

        @Override
        public boolean isResourceBlank() {
            return this.getStack().method_7960();
        }

        @Override
        public ItemVariant getResource() {
            return ItemVariant.of(this.getStack());
        }

        @Override
        public long getAmount() {
            return this.getStack().method_7947();
        }

        @Override
        public long getCapacity() {
            return this.getStack().method_7909().method_7882();
        }

        public String toString() {
            return "ContainerSlotWrapper[%s#%d]".formatted(ContainerComponentStorage.this.ctx.getItemVariant(), this.slot);
        }
    }
}

