/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.behavior;

import dev.lambdaurora.lambdynlights.api.behavior.DynamicLightBehavior;
import java.util.OptionalInt;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Range;

public record BeaconLightBehavior(int x, OptionalInt y, int z, @Range(from=0L, to=15L) int luminance, class_1937 level) implements DynamicLightBehavior
{
    public BeaconLightBehavior(int x, int z, @Range(from=0L, to=15L) int luminance, class_1937 level) {
        this(x, OptionalInt.empty(), z, luminance, level);
    }

    private int getWorldBottom() {
        return this.level.method_31607();
    }

    private int getWorldTop() {
        return this.level.method_31600();
    }

    @Override
    public DynamicLightBehavior.BoundingBox getBoundingBox() {
        return new DynamicLightBehavior.BoundingBox(this.x, this.y.orElse(this.getWorldBottom()), this.z, this.x + 1, this.getWorldTop(), this.z + 1);
    }

    @Override
    public @Range(from=0L, to=15L) double lightAtPos(class_2338 pos, double falloffRatio) {
        double dx = pos.method_10263() - this.x;
        double dz = pos.method_10260() - this.z;
        double distanceSquared = dx * dx + dz * dz;
        if (this.y.isPresent() && pos.method_10264() < this.y.getAsInt()) {
            double dy = pos.method_10264() - this.y.getAsInt();
            distanceSquared += dy * dy;
        }
        return (double)this.luminance - Math.sqrt(distanceSquared) * falloffRatio;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }
}

