/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.entity.luminance;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public record ItemDerivedEntityLuminance(class_1799 item, boolean includeRain, Optional<Always> always) implements EntityLuminance
{
    public static final MapCodec<ItemDerivedEntityLuminance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1799.field_24671.fieldOf("item").forGetter(ItemDerivedEntityLuminance::item), (App)Codec.BOOL.optionalFieldOf("include_rain", (Object)false).forGetter(ItemDerivedEntityLuminance::includeRain), (App)Always.CODEC.optionalFieldOf("always").forGetter(ItemDerivedEntityLuminance::always)).apply((Applicative)instance, ItemDerivedEntityLuminance::new));

    @Override
    public EntityLuminance.Type type() {
        return EntityLuminance.Type.ITEM;
    }

    @Override
    public @Range(from=0L, to=15L) int getLuminance(ItemLightSourceManager itemLightSourceManager, class_1297 entity) {
        boolean wet = this.always.map(value -> switch (value.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> false;
            case 1 -> true;
        }).orElseGet(() -> this.includeRain ? entity.method_5721() : entity.method_5869());
        return itemLightSourceManager.getLuminance(this.item, wet);
    }

    public static Builder builder(class_1799 item) {
        return new Builder(item);
    }

    public static class Builder {
        private final class_1799 item;
        private boolean includeRain = false;
        private Optional<Always> always = Optional.empty();

        private Builder(class_1799 item) {
            this.item = item;
        }

        @Contract(value="_ -> this")
        public Builder includeRain(boolean includeRain) {
            this.includeRain = includeRain;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder always(@Nullable Always always) {
            this.always = Optional.ofNullable(always);
            return this;
        }

        public ItemDerivedEntityLuminance build() {
            return new ItemDerivedEntityLuminance(this.item, this.includeRain, this.always);
        }
    }

    public static enum Always {
        DRY,
        WET;

        private static final Map<String, Always> BY_NAME;
        public static final Codec<Always> CODEC;
        private final String name = this.name().toLowerCase();

        public String getName() {
            return this.name;
        }

        public static Always byName(String name) {
            return BY_NAME.get(name);
        }

        static {
            BY_NAME = (Map)class_156.method_656(() -> Stream.of(Always.values()).collect(HashMap::new, (map, type) -> map.put(type.getName(), type), HashMap::putAll));
            CODEC = Codec.stringResolver(Always::getName, Always::byName);
        }
    }
}

