/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.events;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.joml.Vector2i;

public interface ContainerEventHandler
extends GuiEventListener {
    public List<? extends GuiEventListener> children();

    default public Optional<GuiEventListener> getChildAt(double p_94730_, double p_94731_) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.isMouseOver(p_94730_, p_94731_)) continue;
            return Optional.of(guiEventListener);
        }
        return Optional.empty();
    }

    @Override
    default public boolean mouseClicked(double p_94695_, double p_94696_, int p_94697_) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.mouseClicked(p_94695_, p_94696_, p_94697_)) continue;
            this.setFocused(guiEventListener);
            if (p_94697_ == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean mouseReleased(double p_94722_, double p_94723_, int p_94724_) {
        if (p_94724_ == 0 && this.isDragging()) {
            this.setDragging(false);
            if (this.getFocused() != null) {
                return this.getFocused().mouseReleased(p_94722_, p_94723_, p_94724_);
            }
        }
        return this.getChildAt(p_94722_, p_94723_).filter(p_94708_ -> p_94708_.mouseReleased(p_94722_, p_94723_, p_94724_)).isPresent();
    }

    @Override
    default public boolean mouseDragged(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
        if (this.getFocused() != null && this.isDragging() && p_94701_ == 0) {
            return this.getFocused().mouseDragged(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
        }
        return false;
    }

    public boolean isDragging();

    public void setDragging(boolean var1);

    @Override
    default public boolean mouseScrolled(double p_94686_, double p_94687_, double p_94688_, double p_294830_) {
        return this.getChildAt(p_94686_, p_94687_).filter(p_293596_ -> p_293596_.mouseScrolled(p_94686_, p_94687_, p_94688_, p_294830_)).isPresent();
    }

    @Override
    default public boolean keyPressed(int p_94710_, int p_94711_, int p_94712_) {
        return this.getFocused() != null && this.getFocused().keyPressed(p_94710_, p_94711_, p_94712_);
    }

    @Override
    default public boolean keyReleased(int p_94715_, int p_94716_, int p_94717_) {
        return this.getFocused() != null && this.getFocused().keyReleased(p_94715_, p_94716_, p_94717_);
    }

    @Override
    default public boolean charTyped(char p_94683_, int p_94684_) {
        return this.getFocused() != null && this.getFocused().charTyped(p_94683_, p_94684_);
    }

    @Nullable
    public GuiEventListener getFocused();

    public void setFocused(@Nullable GuiEventListener var1);

    @Override
    default public void setFocused(boolean p_265504_) {
    }

    @Override
    default public boolean isFocused() {
        return this.getFocused() != null;
    }

    @Override
    @Nullable
    default public ComponentPath getCurrentFocusPath() {
        GuiEventListener $$0 = this.getFocused();
        if ($$0 != null) {
            return ComponentPath.path(this, $$0.getCurrentFocusPath());
        }
        return null;
    }

    @Override
    @Nullable
    default public ComponentPath nextFocusPath(FocusNavigationEvent p_265668_) {
        ComponentPath $$2;
        GuiEventListener $$1 = this.getFocused();
        if ($$1 != null && ($$2 = $$1.nextFocusPath(p_265668_)) != null) {
            return ComponentPath.path(this, $$2);
        }
        if (p_265668_ instanceof FocusNavigationEvent.TabNavigation) {
            FocusNavigationEvent.TabNavigation $$3 = (FocusNavigationEvent.TabNavigation)p_265668_;
            return this.handleTabNavigation($$3);
        }
        if (p_265668_ instanceof FocusNavigationEvent.ArrowNavigation) {
            FocusNavigationEvent.ArrowNavigation $$4 = (FocusNavigationEvent.ArrowNavigation)p_265668_;
            return this.handleArrowNavigation($$4);
        }
        return null;
    }

    @Nullable
    private ComponentPath handleTabNavigation(FocusNavigationEvent.TabNavigation p_265354_) {
        Supplier<GuiEventListener> $$10;
        BooleanSupplier $$9;
        int $$7;
        boolean $$1 = p_265354_.forward();
        GuiEventListener $$2 = this.getFocused();
        ArrayList<? extends GuiEventListener> $$3 = new ArrayList<GuiEventListener>(this.children());
        Collections.sort($$3, Comparator.comparingInt(p_344153_ -> p_344153_.getTabOrderGroup()));
        int $$4 = $$3.indexOf($$2);
        if ($$2 != null && $$4 >= 0) {
            int $$5 = $$4 + ($$1 ? 1 : 0);
        } else if ($$1) {
            boolean $$6 = false;
        } else {
            $$7 = $$3.size();
        }
        ListIterator $$8 = $$3.listIterator($$7);
        BooleanSupplier booleanSupplier = $$1 ? $$8::hasNext : ($$9 = $$8::hasPrevious);
        Supplier<GuiEventListener> supplier = $$1 ? $$8::next : ($$10 = $$8::previous);
        while ($$9.getAsBoolean()) {
            GuiEventListener $$11 = $$10.get();
            ComponentPath $$12 = $$11.nextFocusPath(p_265354_);
            if ($$12 == null) continue;
            return ComponentPath.path(this, $$12);
        }
        return null;
    }

    @Nullable
    private ComponentPath handleArrowNavigation(FocusNavigationEvent.ArrowNavigation p_265760_) {
        GuiEventListener $$1 = this.getFocused();
        if ($$1 == null) {
            ScreenDirection $$2 = p_265760_.direction();
            ScreenRectangle $$3 = this.getRectangle().getBorder($$2.getOpposite());
            return ComponentPath.path(this, this.nextFocusPathInDirection($$3, $$2, null, p_265760_));
        }
        ScreenRectangle $$4 = $$1.getRectangle();
        return ComponentPath.path(this, this.nextFocusPathInDirection($$4, p_265760_.direction(), $$1, p_265760_));
    }

    @Nullable
    private ComponentPath nextFocusPathInDirection(ScreenRectangle p_265054_, ScreenDirection p_265167_, @Nullable GuiEventListener p_265476_, FocusNavigationEvent p_265762_) {
        ScreenAxis $$4 = p_265167_.getAxis();
        ScreenAxis $$5 = $$4.orthogonal();
        ScreenDirection $$6 = $$5.getPositive();
        int $$7 = p_265054_.getBoundInDirection(p_265167_.getOpposite());
        ArrayList<GuiEventListener> $$8 = new ArrayList<GuiEventListener>();
        for (GuiEventListener guiEventListener : this.children()) {
            ScreenRectangle $$10;
            if (guiEventListener == p_265476_ || !($$10 = guiEventListener.getRectangle()).overlapsInAxis(p_265054_, $$5)) continue;
            int $$11 = $$10.getBoundInDirection(p_265167_.getOpposite());
            if (p_265167_.isAfter($$11, $$7)) {
                $$8.add(guiEventListener);
                continue;
            }
            if ($$11 != $$7 || !p_265167_.isAfter($$10.getBoundInDirection(p_265167_), p_265054_.getBoundInDirection(p_265167_))) continue;
            $$8.add(guiEventListener);
        }
        Comparator<GuiEventListener> $$12 = Comparator.comparing(p_264674_ -> p_264674_.getRectangle().getBoundInDirection(p_265167_.getOpposite()), p_265167_.coordinateValueComparator());
        Comparator<GuiEventListener> comparator = Comparator.comparing(p_264676_ -> p_264676_.getRectangle().getBoundInDirection($$6.getOpposite()), $$6.coordinateValueComparator());
        $$8.sort($$12.thenComparing(comparator));
        for (GuiEventListener $$14 : $$8) {
            ComponentPath $$15 = $$14.nextFocusPath(p_265762_);
            if ($$15 == null) continue;
            return $$15;
        }
        return this.nextFocusPathVaguelyInDirection(p_265054_, p_265167_, p_265476_, p_265762_);
    }

    @Nullable
    private ComponentPath nextFocusPathVaguelyInDirection(ScreenRectangle p_265390_, ScreenDirection p_265687_, @Nullable GuiEventListener p_265498_, FocusNavigationEvent p_265048_) {
        ScreenAxis $$4 = p_265687_.getAxis();
        ScreenAxis $$5 = $$4.orthogonal();
        ArrayList<Pair> $$6 = new ArrayList<Pair>();
        ScreenPosition $$7 = ScreenPosition.of($$4, p_265390_.getBoundInDirection(p_265687_), p_265390_.getCenterInAxis($$5));
        for (GuiEventListener guiEventListener : this.children()) {
            ScreenRectangle $$9;
            ScreenPosition $$10;
            if (guiEventListener == p_265498_ || !p_265687_.isAfter(($$10 = ScreenPosition.of($$4, ($$9 = guiEventListener.getRectangle()).getBoundInDirection(p_265687_.getOpposite()), $$9.getCenterInAxis($$5))).getCoordinate($$4), $$7.getCoordinate($$4))) continue;
            long $$11 = Vector2i.distanceSquared((int)$$7.x(), (int)$$7.y(), (int)$$10.x(), (int)$$10.y());
            $$6.add(Pair.of((Object)guiEventListener, (Object)$$11));
        }
        $$6.sort(Comparator.comparingDouble(Pair::getSecond));
        for (Pair pair : $$6) {
            ComponentPath $$13 = ((GuiEventListener)pair.getFirst()).nextFocusPath(p_265048_);
            if ($$13 == null) continue;
            return $$13;
        }
        return null;
    }
}

