/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.debug;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;

public class GameModeSwitcherScreen
extends Screen {
    static final ResourceLocation SLOT_SPRITE = ResourceLocation.withDefaultNamespace("gamemode_switcher/slot");
    static final ResourceLocation SELECTION_SPRITE = ResourceLocation.withDefaultNamespace("gamemode_switcher/selection");
    private static final ResourceLocation GAMEMODE_SWITCHER_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/container/gamemode_switcher.png");
    private static final int SPRITE_SHEET_WIDTH = 128;
    private static final int SPRITE_SHEET_HEIGHT = 128;
    private static final int SLOT_AREA = 26;
    private static final int SLOT_PADDING = 5;
    private static final int SLOT_AREA_PADDED = 31;
    private static final int HELP_TIPS_OFFSET_Y = 5;
    private static final int ALL_SLOTS_WIDTH = GameModeIcon.values().length * 31 - 5;
    private static final Component SELECT_KEY = Component.translatable("debug.gamemodes.select_next", Component.translatable("debug.gamemodes.press_f4").withStyle(ChatFormatting.AQUA));
    private final GameModeIcon previousHovered;
    private GameModeIcon currentlyHovered;
    private int firstMouseX;
    private int firstMouseY;
    private boolean setFirstMousePos;
    private final List<GameModeSlot> slots = Lists.newArrayList();

    public GameModeSwitcherScreen() {
        super(GameNarrator.NO_TITLE);
        this.currentlyHovered = this.previousHovered = GameModeIcon.getFromGameType(this.getDefaultSelected());
    }

    private GameType getDefaultSelected() {
        MultiPlayerGameMode $$0 = Minecraft.getInstance().gameMode;
        GameType $$1 = $$0.getPreviousPlayerMode();
        if ($$1 != null) {
            return $$1;
        }
        return $$0.getPlayerMode() == GameType.CREATIVE ? GameType.SURVIVAL : GameType.CREATIVE;
    }

    @Override
    protected void init() {
        super.init();
        this.currentlyHovered = this.previousHovered;
        for (int $$0 = 0; $$0 < GameModeIcon.VALUES.length; ++$$0) {
            GameModeIcon $$1 = GameModeIcon.VALUES[$$0];
            this.slots.add(new GameModeSlot(this, $$1, this.width / 2 - ALL_SLOTS_WIDTH / 2 + $$0 * 31, this.height / 2 - 31));
        }
    }

    @Override
    public void render(GuiGraphics p_281834_, int p_283223_, int p_282178_, float p_281339_) {
        if (this.checkToClose()) {
            return;
        }
        p_281834_.pose().pushPose();
        RenderSystem.enableBlend();
        int $$4 = this.width / 2 - 62;
        int $$5 = this.height / 2 - 31 - 27;
        p_281834_.blit(GAMEMODE_SWITCHER_LOCATION, $$4, $$5, 0.0f, 0.0f, 125, 75, 128, 128);
        p_281834_.pose().popPose();
        super.render(p_281834_, p_283223_, p_282178_, p_281339_);
        p_281834_.drawCenteredString(this.font, this.currentlyHovered.getName(), this.width / 2, this.height / 2 - 31 - 20, -1);
        p_281834_.drawCenteredString(this.font, SELECT_KEY, this.width / 2, this.height / 2 + 5, 0xFFFFFF);
        if (!this.setFirstMousePos) {
            this.firstMouseX = p_283223_;
            this.firstMouseY = p_282178_;
            this.setFirstMousePos = true;
        }
        boolean $$6 = this.firstMouseX == p_283223_ && this.firstMouseY == p_282178_;
        for (GameModeSlot $$7 : this.slots) {
            $$7.render(p_281834_, p_283223_, p_282178_, p_281339_);
            $$7.setSelected(this.currentlyHovered == $$7.icon);
            if ($$6 || !$$7.isHoveredOrFocused()) continue;
            this.currentlyHovered = $$7.icon;
        }
    }

    @Override
    public void renderBackground(GuiGraphics p_294233_, int p_295829_, int p_296393_, float p_294567_) {
    }

    private void switchToHoveredGameMode() {
        GameModeSwitcherScreen.switchToHoveredGameMode(this.minecraft, this.currentlyHovered);
    }

    private static void switchToHoveredGameMode(Minecraft p_281340_, GameModeIcon p_281358_) {
        if (p_281340_.gameMode == null || p_281340_.player == null) {
            return;
        }
        GameModeIcon $$2 = GameModeIcon.getFromGameType(p_281340_.gameMode.getPlayerMode());
        GameModeIcon $$3 = p_281358_;
        if (p_281340_.player.hasPermissions(2) && $$3 != $$2) {
            p_281340_.player.connection.sendUnsignedCommand($$3.getCommand());
        }
    }

    private boolean checkToClose() {
        if (!InputConstants.isKeyDown(this.minecraft.getWindow().getWindow(), 292)) {
            this.switchToHoveredGameMode();
            this.minecraft.setScreen(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int p_97553_, int p_97554_, int p_97555_) {
        if (p_97553_ == 293) {
            this.setFirstMousePos = false;
            this.currentlyHovered = this.currentlyHovered.getNext();
            return true;
        }
        return super.keyPressed(p_97553_, p_97554_, p_97555_);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    static enum GameModeIcon {
        CREATIVE(Component.translatable("gameMode.creative"), "gamemode creative", new ItemStack(Blocks.GRASS_BLOCK)),
        SURVIVAL(Component.translatable("gameMode.survival"), "gamemode survival", new ItemStack(Items.IRON_SWORD)),
        ADVENTURE(Component.translatable("gameMode.adventure"), "gamemode adventure", new ItemStack(Items.MAP)),
        SPECTATOR(Component.translatable("gameMode.spectator"), "gamemode spectator", new ItemStack(Items.ENDER_EYE));

        protected static final GameModeIcon[] VALUES;
        private static final int ICON_AREA = 16;
        protected static final int ICON_TOP_LEFT = 5;
        final Component name;
        final String command;
        final ItemStack renderStack;

        private GameModeIcon(Component p_97594_, String p_97595_, ItemStack p_97596_) {
            this.name = p_97594_;
            this.command = p_97595_;
            this.renderStack = p_97596_;
        }

        void drawIcon(GuiGraphics p_282609_, int p_283301_, int p_281692_) {
            p_282609_.renderItem(this.renderStack, p_283301_, p_281692_);
        }

        Component getName() {
            return this.name;
        }

        String getCommand() {
            return this.command;
        }

        GameModeIcon getNext() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> SURVIVAL;
                case 1 -> ADVENTURE;
                case 2 -> SPECTATOR;
                case 3 -> CREATIVE;
            };
        }

        static GameModeIcon getFromGameType(GameType p_283307_) {
            return switch (p_283307_) {
                default -> throw new MatchException(null, null);
                case GameType.SPECTATOR -> SPECTATOR;
                case GameType.SURVIVAL -> SURVIVAL;
                case GameType.CREATIVE -> CREATIVE;
                case GameType.ADVENTURE -> ADVENTURE;
            };
        }

        static {
            VALUES = GameModeIcon.values();
        }
    }

    public class GameModeSlot
    extends AbstractWidget {
        final GameModeIcon icon;
        private boolean isSelected;

        public GameModeSlot(GameModeSwitcherScreen p_97626_, GameModeIcon p_97627_, int p_97628_, int p_97629_) {
            super(p_97628_, p_97629_, 26, 26, p_97627_.getName());
            this.icon = p_97627_;
        }

        @Override
        public void renderWidget(GuiGraphics p_281380_, int p_283094_, int p_283558_, float p_282631_) {
            this.drawSlot(p_281380_);
            this.icon.drawIcon(p_281380_, this.getX() + 5, this.getY() + 5);
            if (this.isSelected) {
                this.drawSelection(p_281380_);
            }
        }

        @Override
        public void updateWidgetNarration(NarrationElementOutput p_259120_) {
            this.defaultButtonNarrationText(p_259120_);
        }

        @Override
        public boolean isHoveredOrFocused() {
            return super.isHoveredOrFocused() || this.isSelected;
        }

        public void setSelected(boolean p_97644_) {
            this.isSelected = p_97644_;
        }

        private void drawSlot(GuiGraphics p_281786_) {
            p_281786_.blitSprite(SLOT_SPRITE, this.getX(), this.getY(), 26, 26);
        }

        private void drawSelection(GuiGraphics p_281820_) {
            p_281820_.blitSprite(SELECTION_SPRITE, this.getX(), this.getY(), 26, 26);
        }
    }
}

