/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.CrafterSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CrafterScreen
extends AbstractContainerScreen<CrafterMenu> {
    private static final ResourceLocation DISABLED_SLOT_LOCATION_SPRITE = ResourceLocation.withDefaultNamespace("container/crafter/disabled_slot");
    private static final ResourceLocation POWERED_REDSTONE_LOCATION_SPRITE = ResourceLocation.withDefaultNamespace("container/crafter/powered_redstone");
    private static final ResourceLocation UNPOWERED_REDSTONE_LOCATION_SPRITE = ResourceLocation.withDefaultNamespace("container/crafter/unpowered_redstone");
    private static final ResourceLocation CONTAINER_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/container/crafter.png");
    private static final Component DISABLED_SLOT_TOOLTIP = Component.translatable("gui.togglable_slot");
    private final Player player;

    public CrafterScreen(CrafterMenu p_307225_, Inventory p_307403_, Component p_307629_) {
        super(p_307225_, p_307403_, p_307629_);
        this.player = p_307403_.player;
    }

    @Override
    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width(this.title)) / 2;
    }

    @Override
    protected void slotClicked(Slot p_307465_, int p_307203_, int p_307325_, ClickType p_307680_) {
        if (p_307465_ instanceof CrafterSlot && !p_307465_.hasItem() && !this.player.isSpectator()) {
            switch (p_307680_) {
                case PICKUP: {
                    if (((CrafterMenu)this.menu).isSlotDisabled(p_307203_)) {
                        this.enableSlot(p_307203_);
                        break;
                    }
                    if (!((CrafterMenu)this.menu).getCarried().isEmpty()) break;
                    this.disableSlot(p_307203_);
                    break;
                }
                case SWAP: {
                    ItemStack $$4 = this.player.getInventory().getItem(p_307325_);
                    if (!((CrafterMenu)this.menu).isSlotDisabled(p_307203_) || $$4.isEmpty()) break;
                    this.enableSlot(p_307203_);
                }
            }
        }
        super.slotClicked(p_307465_, p_307203_, p_307325_, p_307680_);
    }

    private void enableSlot(int p_309075_) {
        this.updateSlotState(p_309075_, true);
    }

    private void disableSlot(int p_308981_) {
        this.updateSlotState(p_308981_, false);
    }

    private void updateSlotState(int p_308878_, boolean p_309127_) {
        ((CrafterMenu)this.menu).setSlotState(p_308878_, p_309127_);
        super.handleSlotStateChanged(p_308878_, ((CrafterMenu)this.menu).containerId, p_309127_);
        float $$2 = p_309127_ ? 1.0f : 0.75f;
        this.player.playSound(SoundEvents.UI_BUTTON_CLICK.value(), 0.4f, $$2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void renderSlot(GuiGraphics p_307608_, Slot p_307570_) {
        if (p_307570_ instanceof CrafterSlot) {
            CrafterSlot $$2 = (CrafterSlot)p_307570_;
            if (((CrafterMenu)this.menu).isSlotDisabled(p_307570_.index)) {
                this.renderDisabledSlot(p_307608_, $$2);
                return;
            }
        }
        super.renderSlot(p_307608_, p_307570_);
    }

    private void renderDisabledSlot(GuiGraphics p_307416_, CrafterSlot p_307247_) {
        p_307416_.blitSprite(DISABLED_SLOT_LOCATION_SPRITE, p_307247_.x - 1, p_307247_.y - 1, 18, 18);
    }

    @Override
    public void render(GuiGraphics p_307196_, int p_307586_, int p_307288_, float p_307623_) {
        super.render(p_307196_, p_307586_, p_307288_, p_307623_);
        this.renderRedstone(p_307196_);
        this.renderTooltip(p_307196_, p_307586_, p_307288_);
        if (this.hoveredSlot instanceof CrafterSlot && !((CrafterMenu)this.menu).isSlotDisabled(this.hoveredSlot.index) && ((CrafterMenu)this.menu).getCarried().isEmpty() && !this.hoveredSlot.hasItem() && !this.player.isSpectator()) {
            p_307196_.renderTooltip(this.font, DISABLED_SLOT_TOOLTIP, p_307586_, p_307288_);
        }
    }

    private void renderRedstone(GuiGraphics p_307600_) {
        ResourceLocation $$4;
        int $$1 = this.width / 2 + 9;
        int $$2 = this.height / 2 - 48;
        if (((CrafterMenu)this.menu).isPowered()) {
            ResourceLocation $$3 = POWERED_REDSTONE_LOCATION_SPRITE;
        } else {
            $$4 = UNPOWERED_REDSTONE_LOCATION_SPRITE;
        }
        p_307600_.blitSprite($$4, $$1, $$2, 16, 16);
    }

    @Override
    protected void renderBg(GuiGraphics p_307513_, float p_307580_, int p_307561_, int p_307248_) {
        int $$4 = (this.width - this.imageWidth) / 2;
        int $$5 = (this.height - this.imageHeight) / 2;
        p_307513_.blit(CONTAINER_LOCATION, $$4, $$5, 0, 0, this.imageWidth, this.imageHeight);
    }
}

