/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.recipebook;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.recipebook.OverlayRecipeComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.RecipeShownListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RecipeBookPage {
    public static final int ITEMS_PER_PAGE = 20;
    private static final WidgetSprites PAGE_FORWARD_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace("recipe_book/page_forward"), ResourceLocation.withDefaultNamespace("recipe_book/page_forward_highlighted"));
    private static final WidgetSprites PAGE_BACKWARD_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace("recipe_book/page_backward"), ResourceLocation.withDefaultNamespace("recipe_book/page_backward_highlighted"));
    private final List<RecipeButton> buttons = Lists.newArrayListWithCapacity((int)20);
    @Nullable
    private RecipeButton hoveredButton;
    private final OverlayRecipeComponent overlay = new OverlayRecipeComponent();
    private Minecraft minecraft;
    private final List<RecipeShownListener> showListeners = Lists.newArrayList();
    private List<RecipeCollection> recipeCollections = ImmutableList.of();
    private StateSwitchingButton forwardButton;
    private StateSwitchingButton backButton;
    private int totalPages;
    private int currentPage;
    private RecipeBook recipeBook;
    @Nullable
    private RecipeHolder<?> lastClickedRecipe;
    @Nullable
    private RecipeCollection lastClickedRecipeCollection;

    public RecipeBookPage() {
        for (int $$0 = 0; $$0 < 20; ++$$0) {
            this.buttons.add(new RecipeButton());
        }
    }

    public void init(Minecraft p_100429_, int p_100430_, int p_100431_) {
        this.minecraft = p_100429_;
        this.recipeBook = p_100429_.player.getRecipeBook();
        for (int $$3 = 0; $$3 < this.buttons.size(); ++$$3) {
            this.buttons.get($$3).setPosition(p_100430_ + 11 + 25 * ($$3 % 5), p_100431_ + 31 + 25 * ($$3 / 5));
        }
        this.forwardButton = new StateSwitchingButton(p_100430_ + 93, p_100431_ + 137, 12, 17, false);
        this.forwardButton.initTextureValues(PAGE_FORWARD_SPRITES);
        this.backButton = new StateSwitchingButton(p_100430_ + 38, p_100431_ + 137, 12, 17, true);
        this.backButton.initTextureValues(PAGE_BACKWARD_SPRITES);
    }

    public void addListener(RecipeBookComponent p_100433_) {
        this.showListeners.remove(p_100433_);
        this.showListeners.add(p_100433_);
    }

    public void updateCollections(List<RecipeCollection> p_100437_, boolean p_100438_) {
        this.recipeCollections = p_100437_;
        this.totalPages = (int)Math.ceil((double)p_100437_.size() / 20.0);
        if (this.totalPages <= this.currentPage || p_100438_) {
            this.currentPage = 0;
        }
        this.updateButtonsForPage();
    }

    private void updateButtonsForPage() {
        int $$0 = 20 * this.currentPage;
        for (int $$1 = 0; $$1 < this.buttons.size(); ++$$1) {
            RecipeButton $$2 = this.buttons.get($$1);
            if ($$0 + $$1 < this.recipeCollections.size()) {
                RecipeCollection $$3 = this.recipeCollections.get($$0 + $$1);
                $$2.init($$3, this);
                $$2.visible = true;
                continue;
            }
            $$2.visible = false;
        }
        this.updateArrowButtons();
    }

    private void updateArrowButtons() {
        this.forwardButton.visible = this.totalPages > 1 && this.currentPage < this.totalPages - 1;
        this.backButton.visible = this.totalPages > 1 && this.currentPage > 0;
    }

    public void render(GuiGraphics p_281416_, int p_281888_, int p_281904_, int p_282278_, int p_282424_, float p_281712_) {
        if (this.totalPages > 1) {
            MutableComponent $$6 = Component.translatable("gui.recipebook.page", this.currentPage + 1, this.totalPages);
            int $$7 = this.minecraft.font.width($$6);
            p_281416_.drawString(this.minecraft.font, $$6, p_281888_ - $$7 / 2 + 73, p_281904_ + 141, -1, false);
        }
        this.hoveredButton = null;
        for (RecipeButton $$8 : this.buttons) {
            $$8.render(p_281416_, p_282278_, p_282424_, p_281712_);
            if (!$$8.visible || !$$8.isHoveredOrFocused()) continue;
            this.hoveredButton = $$8;
        }
        this.backButton.render(p_281416_, p_282278_, p_282424_, p_281712_);
        this.forwardButton.render(p_281416_, p_282278_, p_282424_, p_281712_);
        this.overlay.render(p_281416_, p_282278_, p_282424_, p_281712_);
    }

    public void renderTooltip(GuiGraphics p_283690_, int p_282626_, int p_282490_) {
        if (this.minecraft.screen != null && this.hoveredButton != null && !this.overlay.isVisible()) {
            p_283690_.renderComponentTooltip(this.minecraft.font, this.hoveredButton.getTooltipText(), p_282626_, p_282490_);
        }
    }

    @Nullable
    public RecipeHolder<?> getLastClickedRecipe() {
        return this.lastClickedRecipe;
    }

    @Nullable
    public RecipeCollection getLastClickedRecipeCollection() {
        return this.lastClickedRecipeCollection;
    }

    public void setInvisible() {
        this.overlay.setVisible(false);
    }

    public boolean mouseClicked(double p_100410_, double p_100411_, int p_100412_, int p_100413_, int p_100414_, int p_100415_, int p_100416_) {
        this.lastClickedRecipe = null;
        this.lastClickedRecipeCollection = null;
        if (this.overlay.isVisible()) {
            if (this.overlay.mouseClicked(p_100410_, p_100411_, p_100412_)) {
                this.lastClickedRecipe = this.overlay.getLastRecipeClicked();
                this.lastClickedRecipeCollection = this.overlay.getRecipeCollection();
            } else {
                this.overlay.setVisible(false);
            }
            return true;
        }
        if (this.forwardButton.mouseClicked(p_100410_, p_100411_, p_100412_)) {
            ++this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        if (this.backButton.mouseClicked(p_100410_, p_100411_, p_100412_)) {
            --this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        for (RecipeButton $$7 : this.buttons) {
            if (!$$7.mouseClicked(p_100410_, p_100411_, p_100412_)) continue;
            if (p_100412_ == 0) {
                this.lastClickedRecipe = $$7.getRecipe();
                this.lastClickedRecipeCollection = $$7.getCollection();
            } else if (p_100412_ == 1 && !this.overlay.isVisible() && !$$7.isOnlyOption()) {
                this.overlay.init(this.minecraft, $$7.getCollection(), $$7.getX(), $$7.getY(), p_100413_ + p_100415_ / 2, p_100414_ + 13 + p_100416_ / 2, $$7.getWidth());
            }
            return true;
        }
        return false;
    }

    public void recipesShown(List<RecipeHolder<?>> p_100435_) {
        for (RecipeShownListener $$1 : this.showListeners) {
            $$1.recipesShown(p_100435_);
        }
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public RecipeBook getRecipeBook() {
        return this.recipeBook;
    }

    protected void listButtons(Consumer<AbstractWidget> p_170054_) {
        p_170054_.accept(this.forwardButton);
        p_170054_.accept(this.backButton);
        this.buttons.forEach(p_170054_);
    }
}

