/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer.chat;

import com.google.common.collect.Queues;
import com.mojang.authlib.GameProfile;
import java.time.Instant;
import java.util.Deque;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.chat.ChatLog;
import net.minecraft.client.multiplayer.chat.ChatTrustLevel;
import net.minecraft.client.multiplayer.chat.LoggedChatMessage;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.util.StringDecomposer;
import org.apache.commons.lang3.StringUtils;

public class ChatListener {
    private static final Component CHAT_VALIDATION_ERROR = Component.translatable("chat.validation_error").withStyle(ChatFormatting.RED, ChatFormatting.ITALIC);
    private final Minecraft minecraft;
    private final Deque<Message> delayedMessageQueue = Queues.newArrayDeque();
    private long messageDelay;
    private long previousMessageTime;

    public ChatListener(Minecraft p_240569_) {
        this.minecraft = p_240569_;
    }

    public void tick() {
        if (this.messageDelay == 0L) {
            return;
        }
        if (Util.getMillis() >= this.previousMessageTime + this.messageDelay) {
            Message $$0 = this.delayedMessageQueue.poll();
            while ($$0 != null && !$$0.accept()) {
                $$0 = this.delayedMessageQueue.poll();
            }
        }
    }

    public void setMessageDelay(double p_240785_) {
        long $$1 = (long)(p_240785_ * 1000.0);
        if ($$1 == 0L && this.messageDelay > 0L) {
            this.delayedMessageQueue.forEach(Message::accept);
            this.delayedMessageQueue.clear();
        }
        this.messageDelay = $$1;
    }

    public void acceptNextDelayedMessage() {
        this.delayedMessageQueue.remove().accept();
    }

    public long queueSize() {
        return this.delayedMessageQueue.size();
    }

    public void clearQueue() {
        this.delayedMessageQueue.forEach(Message::accept);
        this.delayedMessageQueue.clear();
    }

    public boolean removeFromDelayedMessageQueue(MessageSignature p_241445_) {
        return this.delayedMessageQueue.removeIf(p_247887_ -> p_241445_.equals(p_247887_.signature()));
    }

    private boolean willDelayMessages() {
        return this.messageDelay > 0L && Util.getMillis() < this.previousMessageTime + this.messageDelay;
    }

    private void handleMessage(@Nullable MessageSignature p_249408_, BooleanSupplier p_250870_) {
        if (this.willDelayMessages()) {
            this.delayedMessageQueue.add(new Message(p_249408_, p_250870_));
        } else {
            p_250870_.getAsBoolean();
        }
    }

    public void handlePlayerChatMessage(PlayerChatMessage p_251553_, GameProfile p_250022_, ChatType.Bound p_252158_) {
        boolean $$3 = this.minecraft.options.onlyShowSecureChat().get();
        PlayerChatMessage $$4 = $$3 ? p_251553_.removeUnsignedContent() : p_251553_;
        Component $$5 = p_252158_.decorate($$4.decoratedContent());
        Instant $$6 = Instant.now();
        this.handleMessage(p_251553_.signature(), () -> {
            boolean $$6 = this.showMessageToPlayer(p_252158_, p_251553_, $$5, p_250022_, $$3, $$6);
            ClientPacketListener $$7 = this.minecraft.getConnection();
            if ($$7 != null) {
                $$7.markMessageAsProcessed(p_251553_, $$6);
            }
            return $$6;
        });
    }

    public void handleChatMessageError(UUID p_299306_, ChatType.Bound p_298901_) {
        this.handleMessage(null, () -> {
            if (this.minecraft.isBlocked(p_299306_)) {
                return false;
            }
            Component $$2 = p_298901_.decorate(CHAT_VALIDATION_ERROR);
            this.minecraft.gui.getChat().addMessage($$2, null, GuiMessageTag.chatError());
            this.previousMessageTime = Util.getMillis();
            return true;
        });
    }

    public void handleDisguisedChatMessage(Component p_250375_, ChatType.Bound p_251256_) {
        Instant $$2 = Instant.now();
        this.handleMessage(null, () -> {
            Component $$3 = p_251256_.decorate(p_250375_);
            this.minecraft.gui.getChat().addMessage($$3);
            this.narrateChatMessage(p_251256_, p_250375_);
            this.logSystemMessage($$3, $$2);
            this.previousMessageTime = Util.getMillis();
            return true;
        });
    }

    private boolean showMessageToPlayer(ChatType.Bound p_251766_, PlayerChatMessage p_249430_, Component p_249231_, GameProfile p_249177_, boolean p_251638_, Instant p_249665_) {
        ChatTrustLevel $$6 = this.evaluateTrustLevel(p_249430_, p_249231_, p_249665_);
        if (p_251638_ && $$6.isNotSecure()) {
            return false;
        }
        if (this.minecraft.isBlocked(p_249430_.sender()) || p_249430_.isFullyFiltered()) {
            return false;
        }
        GuiMessageTag $$7 = $$6.createTag(p_249430_);
        MessageSignature $$8 = p_249430_.signature();
        FilterMask $$9 = p_249430_.filterMask();
        if ($$9.isEmpty()) {
            this.minecraft.gui.getChat().addMessage(p_249231_, $$8, $$7);
            this.narrateChatMessage(p_251766_, p_249430_.decoratedContent());
        } else {
            Component $$10 = $$9.applyWithFormatting(p_249430_.signedContent());
            if ($$10 != null) {
                this.minecraft.gui.getChat().addMessage(p_251766_.decorate($$10), $$8, $$7);
                this.narrateChatMessage(p_251766_, $$10);
            }
        }
        this.logPlayerMessage(p_249430_, p_251766_, p_249177_, $$6);
        this.previousMessageTime = Util.getMillis();
        return true;
    }

    private void narrateChatMessage(ChatType.Bound p_241352_, Component p_243262_) {
        this.minecraft.getNarrator().sayChat(p_241352_.decorateNarration(p_243262_));
    }

    private ChatTrustLevel evaluateTrustLevel(PlayerChatMessage p_251246_, Component p_250576_, Instant p_249995_) {
        if (this.isSenderLocalPlayer(p_251246_.sender())) {
            return ChatTrustLevel.SECURE;
        }
        return ChatTrustLevel.evaluate(p_251246_, p_250576_, p_249995_);
    }

    private void logPlayerMessage(PlayerChatMessage p_252155_, ChatType.Bound p_249730_, GameProfile p_248589_, ChatTrustLevel p_248881_) {
        ChatLog $$4 = this.minecraft.getReportingContext().chatLog();
        $$4.push(LoggedChatMessage.player(p_248589_, p_252155_, p_248881_));
    }

    private void logSystemMessage(Component p_240609_, Instant p_240541_) {
        ChatLog $$2 = this.minecraft.getReportingContext().chatLog();
        $$2.push(LoggedChatMessage.system(p_240609_, p_240541_));
    }

    public void handleSystemMessage(Component p_240522_, boolean p_240642_) {
        if (this.minecraft.options.hideMatchedNames().get().booleanValue() && this.minecraft.isBlocked(this.guessChatUUID(p_240522_))) {
            return;
        }
        if (p_240642_) {
            this.minecraft.gui.setOverlayMessage(p_240522_, false);
        } else {
            this.minecraft.gui.getChat().addMessage(p_240522_);
            this.logSystemMessage(p_240522_, Instant.now());
        }
        this.minecraft.getNarrator().say(p_240522_);
    }

    private UUID guessChatUUID(Component p_240595_) {
        String $$1 = StringDecomposer.getPlainText(p_240595_);
        String $$2 = StringUtils.substringBetween((String)$$1, (String)"<", (String)">");
        if ($$2 == null) {
            return Util.NIL_UUID;
        }
        return this.minecraft.getPlayerSocialManager().getDiscoveredUUID($$2);
    }

    private boolean isSenderLocalPlayer(UUID p_241343_) {
        if (this.minecraft.isLocalServer() && this.minecraft.player != null) {
            UUID $$1 = this.minecraft.player.getGameProfile().getId();
            return $$1.equals(p_241343_);
        }
        return false;
    }

    record Message(@Nullable MessageSignature signature, BooleanSupplier handler) {
        public boolean accept() {
            return this.handler.getAsBoolean();
        }
    }
}

