/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class CherryParticle
extends TextureSheetParticle {
    private static final float ACCELERATION_SCALE = 0.0025f;
    private static final int INITIAL_LIFETIME = 300;
    private static final int CURVE_ENDPOINT_TIME = 300;
    private static final float FALL_ACC = 0.25f;
    private static final float WIND_BIG = 2.0f;
    private float rotSpeed;
    private final float particleRandom;
    private final float spinAcceleration;

    protected CherryParticle(ClientLevel p_277612_, double p_278010_, double p_277614_, double p_277673_, SpriteSet p_277465_) {
        super(p_277612_, p_278010_, p_277614_, p_277673_);
        float $$5;
        this.setSprite(p_277465_.get(this.random.nextInt(12), 12));
        this.rotSpeed = (float)Math.toRadians(this.random.nextBoolean() ? -30.0 : 30.0);
        this.particleRandom = this.random.nextFloat();
        this.spinAcceleration = (float)Math.toRadians(this.random.nextBoolean() ? -5.0 : 5.0);
        this.lifetime = 300;
        this.gravity = 7.5E-4f;
        this.quadSize = $$5 = this.random.nextBoolean() ? 0.05f : 0.075f;
        this.setSize($$5, $$5);
        this.friction = 1.0f;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (this.removed) {
            return;
        }
        float $$0 = 300 - this.lifetime;
        float $$1 = Math.min($$0 / 300.0f, 1.0f);
        double $$2 = Math.cos(Math.toRadians(this.particleRandom * 60.0f)) * 2.0 * Math.pow($$1, 1.25);
        double $$3 = Math.sin(Math.toRadians(this.particleRandom * 60.0f)) * 2.0 * Math.pow($$1, 1.25);
        this.xd += $$2 * (double)0.0025f;
        this.zd += $$3 * (double)0.0025f;
        this.yd -= (double)this.gravity;
        this.rotSpeed += this.spinAcceleration / 20.0f;
        this.oRoll = this.roll;
        this.roll += this.rotSpeed / 20.0f;
        this.move(this.xd, this.yd, this.zd);
        if (this.onGround || this.lifetime < 299 && (this.xd == 0.0 || this.zd == 0.0)) {
            this.remove();
        }
        if (this.removed) {
            return;
        }
        this.xd *= (double)this.friction;
        this.yd *= (double)this.friction;
        this.zd *= (double)this.friction;
    }
}

