/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class SingleQuadParticle
extends Particle {
    protected float quadSize;

    protected SingleQuadParticle(ClientLevel p_107665_, double p_107666_, double p_107667_, double p_107668_) {
        super(p_107665_, p_107666_, p_107667_, p_107668_);
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
    }

    protected SingleQuadParticle(ClientLevel p_107670_, double p_107671_, double p_107672_, double p_107673_, double p_107674_, double p_107675_, double p_107676_) {
        super(p_107670_, p_107671_, p_107672_, p_107673_, p_107674_, p_107675_, p_107676_);
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
    }

    public FacingCameraMode getFacingCameraMode() {
        return FacingCameraMode.LOOKAT_XYZ;
    }

    @Override
    public void render(VertexConsumer p_107678_, Camera p_107679_, float p_107680_) {
        Quaternionf $$3 = new Quaternionf();
        this.getFacingCameraMode().setRotation($$3, p_107679_, p_107680_);
        if (this.roll != 0.0f) {
            $$3.rotateZ(Mth.lerp(p_107680_, this.oRoll, this.roll));
        }
        this.renderRotatedQuad(p_107678_, p_107679_, $$3, p_107680_);
    }

    protected void renderRotatedQuad(VertexConsumer p_345690_, Camera p_344809_, Quaternionf p_344798_, float p_345099_) {
        Vec3 $$4 = p_344809_.getPosition();
        float $$5 = (float)(Mth.lerp((double)p_345099_, this.xo, this.x) - $$4.x());
        float $$6 = (float)(Mth.lerp((double)p_345099_, this.yo, this.y) - $$4.y());
        float $$7 = (float)(Mth.lerp((double)p_345099_, this.zo, this.z) - $$4.z());
        this.renderRotatedQuad(p_345690_, p_344798_, $$5, $$6, $$7, p_345099_);
    }

    protected void renderRotatedQuad(VertexConsumer p_346432_, Quaternionf p_345557_, float p_345634_, float p_345953_, float p_345531_, float p_346426_) {
        float $$6 = this.getQuadSize(p_346426_);
        float $$7 = this.getU0();
        float $$8 = this.getU1();
        float $$9 = this.getV0();
        float $$10 = this.getV1();
        int $$11 = this.getLightColor(p_346426_);
        this.renderVertex(p_346432_, p_345557_, p_345634_, p_345953_, p_345531_, 1.0f, -1.0f, $$6, $$8, $$10, $$11);
        this.renderVertex(p_346432_, p_345557_, p_345634_, p_345953_, p_345531_, 1.0f, 1.0f, $$6, $$8, $$9, $$11);
        this.renderVertex(p_346432_, p_345557_, p_345634_, p_345953_, p_345531_, -1.0f, 1.0f, $$6, $$7, $$9, $$11);
        this.renderVertex(p_346432_, p_345557_, p_345634_, p_345953_, p_345531_, -1.0f, -1.0f, $$6, $$7, $$10, $$11);
    }

    private void renderVertex(VertexConsumer p_345983_, Quaternionf p_345441_, float p_345563_, float p_345839_, float p_346305_, float p_345242_, float p_346207_, float p_344893_, float p_345909_, float p_345984_, int p_345037_) {
        Vector3f $$11 = new Vector3f(p_345242_, p_346207_, 0.0f).rotate((Quaternionfc)p_345441_).mul(p_344893_).add(p_345563_, p_345839_, p_346305_);
        p_345983_.addVertex($$11.x(), $$11.y(), $$11.z()).setUv(p_345909_, p_345984_).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(p_345037_);
    }

    public float getQuadSize(float p_107681_) {
        return this.quadSize;
    }

    @Override
    public Particle scale(float p_107683_) {
        this.quadSize *= p_107683_;
        return super.scale(p_107683_);
    }

    protected abstract float getU0();

    protected abstract float getU1();

    protected abstract float getV0();

    protected abstract float getV1();

    public static interface FacingCameraMode {
        public static final FacingCameraMode LOOKAT_XYZ = (p_312316_, p_311843_, p_312119_) -> p_312316_.set((Quaternionfc)p_311843_.rotation());
        public static final FacingCameraMode LOOKAT_Y = (p_312695_, p_312346_, p_312064_) -> p_312695_.set(0.0f, p_312346_.rotation().y, 0.0f, p_312346_.rotation().w);

        public void setRotation(Quaternionf var1, Camera var2, float var3);
    }
}

