/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.dimension.DimensionType;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LightTexture
implements AutoCloseable {
    public static final int FULL_BRIGHT = 0xF000F0;
    public static final int FULL_SKY = 0xF00000;
    public static final int FULL_BLOCK = 240;
    private final DynamicTexture lightTexture;
    private final NativeImage lightPixels;
    private final ResourceLocation lightTextureLocation;
    private boolean updateLightTexture;
    private float blockLightRedFlicker;
    private final GameRenderer renderer;
    private final Minecraft minecraft;

    public LightTexture(GameRenderer p_109878_, Minecraft p_109879_) {
        this.renderer = p_109878_;
        this.minecraft = p_109879_;
        this.lightTexture = new DynamicTexture(16, 16, false);
        this.lightTextureLocation = this.minecraft.getTextureManager().register("light_map", this.lightTexture);
        this.lightPixels = this.lightTexture.getPixels();
        for (int $$2 = 0; $$2 < 16; ++$$2) {
            for (int $$3 = 0; $$3 < 16; ++$$3) {
                this.lightPixels.setPixelRGBA($$3, $$2, -1);
            }
        }
        this.lightTexture.upload();
    }

    @Override
    public void close() {
        this.lightTexture.close();
    }

    public void tick() {
        this.blockLightRedFlicker += (float)((Math.random() - Math.random()) * Math.random() * Math.random() * 0.1);
        this.blockLightRedFlicker *= 0.9f;
        this.updateLightTexture = true;
    }

    public void turnOffLightLayer() {
        RenderSystem.setShaderTexture(2, 0);
    }

    public void turnOnLightLayer() {
        RenderSystem.setShaderTexture(2, this.lightTextureLocation);
        this.minecraft.getTextureManager().bindForSetup(this.lightTextureLocation);
        RenderSystem.texParameter(3553, 10241, 9729);
        RenderSystem.texParameter(3553, 10240, 9729);
    }

    private float getDarknessGamma(float p_234320_) {
        MobEffectInstance $$1 = this.minecraft.player.getEffect(MobEffects.DARKNESS);
        if ($$1 != null) {
            return $$1.getBlendFactor(this.minecraft.player, p_234320_);
        }
        return 0.0f;
    }

    private float calculateDarknessScale(LivingEntity p_234313_, float p_234314_, float p_234315_) {
        float $$3 = 0.45f * p_234314_;
        return Math.max(0.0f, Mth.cos(((float)p_234313_.tickCount - p_234315_) * (float)Math.PI * 0.025f) * $$3);
    }

    public void updateLightTexture(float p_109882_) {
        float $$11;
        float $$4;
        if (!this.updateLightTexture) {
            return;
        }
        this.updateLightTexture = false;
        this.minecraft.getProfiler().push("lightTex");
        ClientLevel $$1 = this.minecraft.level;
        if ($$1 == null) {
            return;
        }
        float $$2 = $$1.getSkyDarken(1.0f);
        if ($$1.getSkyFlashTime() > 0) {
            float $$3 = 1.0f;
        } else {
            $$4 = $$2 * 0.95f + 0.05f;
        }
        float $$5 = this.minecraft.options.darknessEffectScale().get().floatValue();
        float $$6 = this.getDarknessGamma(p_109882_) * $$5;
        float $$7 = this.calculateDarknessScale(this.minecraft.player, $$6, p_109882_) * $$5;
        float $$8 = this.minecraft.player.getWaterVision();
        if (this.minecraft.player.hasEffect(MobEffects.NIGHT_VISION)) {
            float $$9 = GameRenderer.getNightVisionScale(this.minecraft.player, p_109882_);
        } else if ($$8 > 0.0f && this.minecraft.player.hasEffect(MobEffects.CONDUIT_POWER)) {
            float $$10 = $$8;
        } else {
            $$11 = 0.0f;
        }
        Vector3f $$12 = new Vector3f($$2, $$2, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
        float $$13 = this.blockLightRedFlicker + 1.5f;
        Vector3f $$14 = new Vector3f();
        for (int $$15 = 0; $$15 < 16; ++$$15) {
            for (int $$16 = 0; $$16 < 16; ++$$16) {
                float $$26;
                float $$18;
                float $$17 = LightTexture.getBrightness($$1.dimensionType(), $$15) * $$4;
                float $$19 = $$18 = LightTexture.getBrightness($$1.dimensionType(), $$16) * $$13;
                float $$20 = $$18 * (($$18 * 0.6f + 0.4f) * 0.6f + 0.4f);
                float $$21 = $$18 * ($$18 * $$18 * 0.6f + 0.4f);
                $$14.set($$19, $$20, $$21);
                boolean $$22 = $$1.effects().forceBrightLightmap();
                if ($$22) {
                    $$14.lerp((Vector3fc)new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                    LightTexture.clampColor($$14);
                } else {
                    Vector3f $$23 = new Vector3f((Vector3fc)$$12).mul($$17);
                    $$14.add((Vector3fc)$$23);
                    $$14.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                    if (this.renderer.getDarkenWorldAmount(p_109882_) > 0.0f) {
                        float $$24 = this.renderer.getDarkenWorldAmount(p_109882_);
                        Vector3f $$25 = new Vector3f((Vector3fc)$$14).mul(0.7f, 0.6f, 0.6f);
                        $$14.lerp((Vector3fc)$$25, $$24);
                    }
                }
                if ($$11 > 0.0f && ($$26 = Math.max($$14.x(), Math.max($$14.y(), $$14.z()))) < 1.0f) {
                    float $$27 = 1.0f / $$26;
                    Vector3f $$28 = new Vector3f((Vector3fc)$$14).mul($$27);
                    $$14.lerp((Vector3fc)$$28, $$11);
                }
                if (!$$22) {
                    if ($$7 > 0.0f) {
                        $$14.add(-$$7, -$$7, -$$7);
                    }
                    LightTexture.clampColor($$14);
                }
                float $$29 = this.minecraft.options.gamma().get().floatValue();
                Vector3f $$30 = new Vector3f(this.notGamma($$14.x), this.notGamma($$14.y), this.notGamma($$14.z));
                $$14.lerp((Vector3fc)$$30, Math.max(0.0f, $$29 - $$6));
                $$14.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                LightTexture.clampColor($$14);
                $$14.mul(255.0f);
                int $$31 = 255;
                int $$32 = (int)$$14.x();
                int $$33 = (int)$$14.y();
                int $$34 = (int)$$14.z();
                this.lightPixels.setPixelRGBA($$16, $$15, 0xFF000000 | $$34 << 16 | $$33 << 8 | $$32);
            }
        }
        this.lightTexture.upload();
        this.minecraft.getProfiler().pop();
    }

    private static void clampColor(Vector3f p_254122_) {
        p_254122_.set(Mth.clamp(p_254122_.x, 0.0f, 1.0f), Mth.clamp(p_254122_.y, 0.0f, 1.0f), Mth.clamp(p_254122_.z, 0.0f, 1.0f));
    }

    private float notGamma(float p_109893_) {
        float $$1 = 1.0f - p_109893_;
        return 1.0f - $$1 * $$1 * $$1 * $$1;
    }

    public static float getBrightness(DimensionType p_234317_, int p_234318_) {
        float $$2 = (float)p_234318_ / 15.0f;
        float $$3 = $$2 / (4.0f - 3.0f * $$2);
        return Mth.lerp(p_234317_.ambientLight(), $$3, 1.0f);
    }

    public static int pack(int p_109886_, int p_109887_) {
        return p_109886_ << 4 | p_109887_ << 20;
    }

    public static int block(int p_109884_) {
        return p_109884_ >> 4 & 0xFFFF;
    }

    public static int sky(int p_109895_) {
        return p_109895_ >> 20 & 0xFFFF;
    }
}

