/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class ItemOverride {
    private final ResourceLocation model;
    private final List<Predicate> predicates;

    public ItemOverride(ResourceLocation p_173447_, List<Predicate> p_173448_) {
        this.model = p_173447_;
        this.predicates = ImmutableList.copyOf(p_173448_);
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public Stream<Predicate> getPredicates() {
        return this.predicates.stream();
    }

    public static class Predicate {
        private final ResourceLocation property;
        private final float value;

        public Predicate(ResourceLocation p_173457_, float p_173458_) {
            this.property = p_173457_;
            this.value = p_173458_;
        }

        public ResourceLocation getProperty() {
            return this.property;
        }

        public float getValue() {
            return this.value;
        }
    }

    protected static class Deserializer
    implements JsonDeserializer<ItemOverride> {
        protected Deserializer() {
        }

        public ItemOverride deserialize(JsonElement p_111725_, Type p_111726_, JsonDeserializationContext p_111727_) throws JsonParseException {
            JsonObject $$3 = p_111725_.getAsJsonObject();
            ResourceLocation $$4 = ResourceLocation.parse(GsonHelper.getAsString($$3, "model"));
            List<Predicate> $$5 = this.getPredicates($$3);
            return new ItemOverride($$4, $$5);
        }

        protected List<Predicate> getPredicates(JsonObject p_173451_) {
            LinkedHashMap $$1 = Maps.newLinkedHashMap();
            JsonObject $$2 = GsonHelper.getAsJsonObject(p_173451_, "predicate");
            for (Map.Entry $$3 : $$2.entrySet()) {
                $$1.put(ResourceLocation.parse((String)$$3.getKey()), Float.valueOf(GsonHelper.convertToFloat((JsonElement)$$3.getValue(), (String)$$3.getKey())));
            }
            return (List)$$1.entrySet().stream().map(p_173453_ -> new Predicate((ResourceLocation)p_173453_.getKey(), ((Float)p_173453_.getValue()).floatValue())).collect(ImmutableList.toImmutableList());
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

